<?php

defined('ABSPATH') || exit;

/**
 * Themify icon font
 */
class Themify_Icon_Themify extends Themify_Icon_Font {

    function get_id() {
        return 'ti';
    }

    function get_label() {
        return __('Themify', 'themify');
    }

    public function __construct() {
        parent::__construct();
    }

    /**
     * Check if the icon name belongs to the Themify icon font
     * Assumes yes, if the icon name has "ti-" prefix
     *
     * @return bool
     */
    function is_valid_icon($name) {
        return strpos($name, 'ti-') === 0;
    }

    function get_classname($icon, $lazy = false, $data_only = false, $attrs = array()) {
        $id = $this->get_id() . '-';
        $icon = str_replace($id, '', $icon);
        $k = $id . $icon;
        if (!isset(self::$usedIcons[$k])) {
            $icon = self::get_icons($icon);
            if ($icon !== '') {
                self::$usedIcons[$k] = array('p' => $icon);
            }
        }

        if ($data_only === true) {
            return self::$usedIcons[$k];
        }
        return self::get_svg($k, $attrs);
    }

    function get_categories() {
        $icons = self::get_icons_category();
        $res = array();
        foreach ($icons as $k => $v) {
            $res[$k] = $v['label'];
        }
        return $res;
    }

    public function get_icons_by_category($cat = '') {
        $icons = self::get_icons_category();
        if ($cat === '' || isset($icons[$cat])) {
            if ($cat !== '') {
                $icons = array($cat => $icons[$cat]);
            }
            $res = array();
            foreach ($icons as $k => $v) {
                $res[$k] = array();
                foreach ($v['icons'] as $ic) {
                    $res[$k][$ic] = self::get_icons($ic);
                }
            }
            return $res;
        }
        return array();
    }

    private static function get_icons_category() {
        return array(
            'arrows' => array(
                'label' => __('Arrows', 'themify'),
                'icons' => array(
                    'arrow-up',
                    'arrow-right',
                    'arrow-left',
                    'arrow-down',
                    'arrows-vertical',
                    'arrows-horizontal',
                    'angle-up',
                    'angle-right',
                    'angle-left',
                    'angle-down',
                    'angle-double-up',
                    'angle-double-right',
                    'angle-double-left',
                    'angle-double-down',
                    'move',
                    'fullscreen',
                    'arrow-top-right',
                    'arrow-top-left',
                    'arrow-circle-up',
                    'arrow-circle-right',
                    'arrow-circle-left',
                    'arrow-circle-down',
                    'arrows-corner',
                    'split-v',
                    'split-v-alt',
                    'split-h',
                    'hand-point-up',
                    'hand-point-right',
                    'hand-point-left',
                    'hand-point-down',
                    'back-right',
                    'back-left',
                    'exchange-vertical',
                )
            ),
            'web' => array(
                'label' => __('Web App', 'themify'),
                'icons' => array(
                    'wand',
                    'save',
                    'save-alt',
                    'direction',
                    'direction-alt',
                    'user',
                    'link',
                    'unlink',
                    'trash',
                    'target',
                    'tag',
                    'desktop',
                    'tablet',
                    'mobile',
                    'email',
                    'star',
                    'spray',
                    'signal',
                    'shopping-cart',
                    'shopping-cart-full',
                    'settings',
                    'search',
                    'zoom-in',
                    'zoom-out',
                    'cut',
                    'ruler',
                    'ruler-alt-2',
                    'ruler-pencil',
                    'ruler-alt',
                    'bookmark',
                    'bookmark-alt',
                    'reload',
                    'plus',
                    'minus',
                    'close',
                    'pin',
                    'pencil',
                    'pencil-alt',
                    'paint-roller',
                    'paint-bucket',
                    'na',
                    'medall',
                    'medall-alt',
                    'marker',
                    'marker-alt',
                    'lock',
                    'unlock',
                    'location-arrow',
                    'layout',
                    'layers',
                    'layers-alt',
                    'key',
                    'image',
                    'heart',
                    'heart-broken',
                    'hand-stop',
                    'hand-open',
                    'hand-drag',
                    'flag',
                    'flag-alt',
                    'flag-alt-2',
                    'eye',
                    'import',
                    'export',
                    'cup',
                    'crown',
                    'comments',
                    'comment',
                    'comment-alt',
                    'thought',
                    'clip',
                    'check',
                    'check-box',
                    'camera',
                    'announcement',
                    'brush',
                    'brush-alt',
                    'palette',
                    'briefcase',
                    'bolt',
                    'bolt-alt',
                    'blackboard',
                    'bag',
                    'world',
                    'wheelchair',
                    'car',
                    'truck',
                    'timer',
                    'ticket',
                    'thumb-up',
                    'thumb-down',
                    'stats-up',
                    'stats-down',
                    'shine',
                    'shift-right',
                    'shift-left',
                    'shift-right-alt',
                    'shift-left-alt',
                    'shield',
                    'notepad',
                    'server',
                    'pulse',
                    'printer',
                    'power-off',
                    'plug',
                    'pie-chart',
                    'panel',
                    'package',
                    'music',
                    'music-alt',
                    'mouse',
                    'mouse-alt',
                    'money',
                    'microphone',
                    'menu',
                    'menu-alt',
                    'map',
                    'map-alt',
                    'location-pin',
                    'light-bulb',
                    'info',
                    'infinite',
                    'id-badge',
                    'hummer',
                    'home',
                    'help',
                    'headphone',
                    'harddrives',
                    'harddrive',
                    'gift',
                    'game',
                    'filter',
                    'files',
                    'file',
                    'zip',
                    'folder',
                    'envelope',
                    'dashboard',
                    'cloud',
                    'cloud-up',
                    'cloud-down',
                    'clipboard',
                    'calendar',
                    'book',
                    'bell',
                    'basketball',
                    'bar-chart',
                    'bar-chart-alt',
                    'archive',
                    'anchor',
                    'alert',
                    'alarm-clock',
                    'agenda',
                    'write',
                    'wallet',
                    'video-clapper',
                    'video-camera',
                    'vector',
                    'support',
                    'stamp',
                    'slice',
                    'shortcode',
                    'receipt',
                    'pin2',
                    'pin-alt',
                    'pencil-alt2',
                    'eraser',
                    'more',
                    'more-alt',
                    'microphone-alt',
                    'magnet',
                    'line-double',
                    'line-dotted',
                    'line-dashed',
                    'ink-pen',
                    'info-alt',
                    'help-alt',
                    'headphone-alt',
                    'gallery',
                    'face-smile',
                    'face-sad',
                    'credit-card',
                    'comments-smiley',
                    'time',
                    'share',
                    'share-alt',
                    'rocket',
                    'new-window',
                    'rss',
                    'rss-alt',
                )
            ),
            'control' => array(
                'label' => __('Controls', 'themify'),
                'icons' => array(
                    'control-stop',
                    'control-shuffle',
                    'control-play',
                    'control-pause',
                    'control-forward',
                    'control-backward',
                    'volume',
                    'control-skip-forward',
                    'control-skip-backward',
                    'control-record',
                    'control-eject',
                )
            ),
            'text-editor' => array(
                'label' => __('Editor', 'themify'),
                'icons' => array(
                    'paragraph',
                    'uppercase',
                    'underline',
                    'text',
                    'Italic',
                    'smallcap',
                    'list',
                    'list-ol',
                    'align-right',
                    'align-left',
                    'align-justify',
                    'align-center',
                    'quote-right',
                    'quote-left',
                )
            ),
            'layout' => array(
                'label' => __('Layouts', 'themify'),
                'icons' => array(
                    'layout-width-full',
                    'layout-width-default',
                    'layout-width-default-alt',
                    'layout-tab',
                    'layout-tab-window',
                    'layout-tab-v',
                    'layout-tab-min',
                    'layout-slider',
                    'layout-slider-alt',
                    'layout-sidebar-right',
                    'layout-sidebar-none',
                    'layout-sidebar-left',
                    'layout-placeholder',
                    'layout-menu',
                    'layout-menu-v',
                    'layout-menu-separated',
                    'layout-menu-full',
                    'layout-media-right',
                    'layout-media-right-alt',
                    'layout-media-overlay',
                    'layout-media-overlay-alt',
                    'layout-media-overlay-alt-2',
                    'layout-media-left',
                    'layout-media-left-alt',
                    'layout-media-center',
                    'layout-media-center-alt',
                    'layout-list-thumb',
                    'layout-list-thumb-alt',
                    'layout-list-post',
                    'layout-list-large-image',
                    'layout-line-solid',
                    'layout-grid4',
                    'layout-grid3',
                    'layout-grid2',
                    'layout-grid2-thumb',
                    'layout-cta-right',
                    'layout-cta-left',
                    'layout-cta-center',
                    'layout-cta-btn-right',
                    'layout-cta-btn-left',
                    'layout-column4',
                    'layout-column3',
                    'layout-column2',
                    'layout-accordion-separated',
                    'layout-accordion-merged',
                    'layout-accordion-list',
                    'widgetized',
                    'widget',
                    'widget-alt',
                    'view-list',
                    'view-list-alt',
                    'view-grid',
                    'upload',
                    'download',
                    'loop',
                    'layout-sidebar-2',
                    'layout-grid4-alt',
                    'layout-grid3-alt',
                    'layout-grid2-alt',
                    'layout-column4-alt',
                    'layout-column3-alt',
                    'layout-column2-alt',
                )
            ),
            'brand' => array(
                'label' => __('Brands', 'themify'),
                'icons' => array(
                    'flickr',
                    'flickr-alt',
                    'instagram',
                    'google',
                    'github',
                    'facebook',
                    'dropbox',
                    'dropbox-alt',
                    'dribbble',
                    'apple',
                    'android',
                    'yahoo',
                    'trello',
                    'stack-overflow',
                    'soundcloud',
                    'sharethis',
                    'sharethis-alt',
                    'reddit',
                    'microsoft',
                    'microsoft-alt',
                    'linux',
                    'jsfiddle',
                    'joomla',
                    'html5',
                    'css3',
                    'drupal',
                    'wordpress',
                    'tumblr',
                    'tumblr-alt',
                    'skype',
                    'youtube',
                    'vimeo',
                    'vimeo-alt',
                    'twitter',
                    'twitter-alt',
                    'linkedin',
                    'pinterest',
                    'pinterest-alt',
                    'themify-logo',
                    'themify-favicon',
                    'themify-favicon-alt',
                )
            )
        );
    }

    public static function get_icons($icon = '') {
        $icons = array(
            'wand' => 'M32 9.4V7.5h-6.2l4.3-4.3L28.7 2l-4.2 4.3V0h-2v6.2l-4.3-4.4-1.3 1.3 4.3 4.4h-6.1v2h6.1l-20 20 1.4 1.3 20-20v6.1h1.9v-6.1l4.4 4.3 1.3-1.3-4.4-4.4H32z',
            'volume' => 'M6.8 11.2H10L20.8.4v31L10 20.5H6.7c-.7 0-1.5-.3-2-.9s-.9-1.2-.9-2v-4c0-1.6 1.1-2.5 3-2.5zm12-6.2L11 13H6.7c-1 0-1 .4-1 .6v4c0 .7.5 1.2 1 1.2h4.1l8 8V5zm3.8 15.7a3.8 3.8 0 0 0 0-7.6V15c1 0 1.9.9 1.9 1.9 0 1-.9 2-1.9 2v1.8zm7.6-3.8c0-4.1-3.4-7.5-7.6-7.5v1.9c3.1 0 5.7 2.5 5.7 5.6 0 3.1-2.6 5.7-5.7 5.7v1.8c4.2 0 7.6-3.3 7.6-7.5',
            'user' => 'M32 31.06V32H0v-.94c.13-5.12 5.31-9.5 12.44-10.62v-2.38a9.45 9.45 0 0 1-2.19-3.75 3.57 3.57 0 0 1-1.44-1.69c-.62-1.37-.44-2.68.38-3.25-.07-.37-.07-.8-.07-1.18v-.7c-.06-2.12-.06-4.8 3.13-5.12 0 0 .12-.12.19-.25.5-1 1.25-2 3.69-2.12h.5c3.56 0 6 1.31 6.8 3.69.26.68 0 1.31-.18 1.81a4.8 4.8 0 0 0-.38 2.56c.07.44 0 .94 0 1.38.63.56.82 1.75.38 3.06a3.27 3.27 0 0 1-1.5 1.94 9.95 9.95 0 0 1-2 3.44v2.62c7 1.13 12.13 5.5 12.25 10.56zm-30-.93h28c-.69-3.88-5.31-7.13-11.31-7.88l-.88-.13V17l.38-.31c.68-.5 1.37-1.7 1.93-3.32l.2-.62H21c0-.06.25-.31.44-.88.12-.37.19-.68.19-.87l-.88.06.19-1.5c.06-.44.12-.94.06-1.25a6.3 6.3 0 0 1 .5-3.5c.07-.19.13-.44.13-.5-.69-2.12-3.44-2.44-5-2.44h-.44c-1.56.07-1.81.57-2.06 1.13-.25.44-.63 1.19-1.7 1.25-1.37.12-1.5.69-1.43 3.19v.75c0 .56.06 1.19.13 1.81l.18 1.38-1-.25c.07.18.13.43.25.75.2.56.5.8.63.8l.56.13.13.5c.56 1.7 1.31 3 2.06 3.5l.37.25v5.07l-.8.06c-6.13.75-10.76 4-11.5 7.94z',
            'unlock' => 'M17.9 20.6c0-1-.8-1.9-1.9-1.9s-1.9 1-1.9 2c0 .7.4 1.2 1 1.6v4h1.8v-4c.6-.4 1-1 1-1.7zM28.3 16c0-1.5-1.4-2.8-2.9-2.8V9.4c0-5.2-4.2-9.5-9.4-9.5S6.6 4.2 6.6 9.4h1.9c0-4.2 3.4-7.6 7.5-7.6s7.5 3.4 7.5 7.6V13H6.6a2.9 2.9 0 0 0-2.9 3v13.4c0 1.5 1.4 2.8 3 2.8h18.7c1.5 0 2.8-1.3 2.8-2.8V15.9zm-2 0v13.4c0 .5-.4.9-1 .9H6.7a1 1 0 0 1-1-1V16c0-.5.5-.9 1-.9h18.8c.5 0 1 .4 1 1z',
            'unlink' => 'M4 9.7a6.6 6.6 0 0 0 5.6 10.2c1.8 0 3.6-.8 5-2.5l-1.4-1.2c-1.8 2-4.1 2.4-6.3 1a4.8 4.8 0 0 1-1.3-6.6l2.7-4.8a4.8 4.8 0 0 1 6.5-1.4l1-1.5c-3-2-7.1-1.2-9.2 2zM7.6 15a6.6 6.6 0 0 1 9.3 9.3L11.3 30a6.6 6.6 0 1 1-9.4-9.3l2-2L5.3 20l-2 2a4.8 4.8 0 0 0 0 6.7 4.7 4.7 0 0 0 6.6 0l5.7-5.7A4.7 4.7 0 0 0 9 16.4l-.3.3-1.3-1.3zm13-2v-1.8h7.7v1.9h-7.7zm-.9 2.6 1-1.6 3.7 2-1 1.7zm.6-13.5 1.6 1-3 5-1.6-.9zm9.6 3-9.4 5.4-1-1.7 9.4-5.4z',
            'trash' => 'M20.6 3.8h6.7v1.9H6.6V3.8h6.7C13.8 2.1 15.2 1 17 1s3.3 1.3 3.7 3zm-3.7-1a2 2 0 0 0-1.6 1h3.3c-.4-.5-1-1-1.7-1zm7.6 4.7v19.8c0 .5-.4 1-1 1H10.4a1 1 0 0 1-1-1V7.5H7.5v19.8c0 1.6 1.3 2.8 2.9 2.8h13.1c1.6 0 2.9-1.2 2.9-2.8V7.5h-1.9zm-9.4 2h-2v15h2v-15zm5.6 0h-1.9v15h1.9v-15z',
            'thought' => 'M21.6 19c-.8 0-1.7 0-2.6-.3a7 7 0 0 1-9.4.3H8.5C3.8 19 0 15.7 0 11.3s3.8-7.8 8.5-7.8c1.5 0 3 .4 4.3 1.2 1.9-3 5.3-4.7 8.8-4.7C27.4 0 32 4.2 32 9.5s-4.6 9.6-10.4 9.6zm-3.3-2.4.6.2c1 .2 2 .4 2.7.4 4.7 0 8.5-3.4 8.5-7.7 0-4.2-3.8-7.6-8.5-7.6A8.6 8.6 0 0 0 14 6.3l-.5 1-1-.6a6.5 6.5 0 0 0-4-1.4c-3.7 0-6.6 2.7-6.6 6s3 5.9 6.6 5.9l1.2-.1.5-.2.4.4c.8 1 2.2 1.5 3.5 1.5 1.5 0 3-.6 3.8-1.7zm3.3 3.1a3.8 3.8 0 1 1 0 7.6 3.8 3.8 0 0 1 0-7.6zm0 5.7a1.9 1.9 0 1 0 0-3.8 2 2 0 0 0-1.9 1.9c0 1 1 2 2 2zm7 1c1.4 0 2.5 1 2.5 2.3a2.4 2.4 0 0 1-2.4 2.3 2.3 2.3 0 0 1-2.3-2.4c0-1.3 1-2.3 2.3-2.3zm-.4 2.3c0 .6 1 .6 1 0 0-.3-.3-.5-.5-.5s-.5.2-.5.5z',
            'target' => 'M32.06 15.06v1.88H28.2c-.44 6-5.31 10.81-11.31 11.25V32H15v-3.8A12.25 12.25 0 0 1 3.81 16.94H-.06v-1.88H3.8c.45-6 5.26-10.75 11.2-11.25V-.06h1.88V3.8a12.21 12.21 0 0 1 11.3 11.25h3.88zM16.87 26.31c5-.43 9-4.37 9.44-9.37h-3.68v-1.88h3.68c-.43-5-4.43-8.93-9.43-9.37V9.3H15V5.7a10.4 10.4 0 0 0-9.31 9.37h3.68v1.88H5.7A10.4 10.4 0 0 0 15 26.3v-3.75h1.88v3.75z',
            'tag' => 'M16.88 1.88 24.5 7.3v22.9l-7.63-5.25-7.5 5.25V7.3zm5.75 24.68V8.31L16.88 4.2l-5.63 4.06v18.31l5.63-3.93zm-9-15.25c0-1.81 1.5-3.31 3.3-3.31s3.32 1.5 3.32 3.31-1.5 3.25-3.31 3.25-3.32-1.43-3.32-3.25zm3.3-1.44a1.4 1.4 0 0 0-1.37 1.44c0 .75.63 1.38 1.38 1.38a1.4 1.4 0 0 0 1.44-1.38c0-.81-.63-1.44-1.44-1.44z',
            'tablet' => 'M17.44 27.31c0-.81-.69-1.43-1.44-1.43s-1.44.62-1.44 1.43c0 .75.69 1.38 1.44 1.38s1.44-.63 1.44-1.38zm12.68-24.5C30.13 1.25 28.95 0 27.5 0h-23C3.06 0 1.87 1.25 1.87 2.81V29.2c0 1.56 1.2 2.81 2.63 2.81h23c1.44 0 2.63-1.25 2.63-2.81V2.8zm-1.87 0V29.2c0 .5-.38.94-.75.94h-23c-.38 0-.75-.44-.75-.94V2.8c0-.5.38-.94.75-.94h23c.38 0 .75.44.75.94zm-22.63.94V24.5h20.75V3.75H5.63zM7.5 22.56V5.63h17v16.93h-17z',
            'star' => 'm31.31 13.19-9.44 6.94 3.63 11.12-9.5-6.87-9.5 6.87 3.63-11.12-9.44-6.94h11.69L16 2.06l3.63 11.13H31.3zM21.87 26.3l-2.25-6.93 5.94-4.32h-7.31L16 8.12l-2.25 6.94H6.44l5.93 4.32-2.24 6.93L16 22z',
            'spray' => 'M12.25 5.63c2.69 0 5.13 1.5 6.5 3.8h1.94V29.2a2.8 2.8 0 0 1-2.82 2.8H6.57a2.84 2.84 0 0 1-2.82-2.81V9.44h2a7.54 7.54 0 0 1 6.5-3.82zm0 1.87c-1.63 0-3.19.75-4.19 1.94h8.38a5.65 5.65 0 0 0-4.2-1.94zm6.56 21.69V11.3H5.63v17.9c0 .5.43.94.93.94h11.32c.5 0 .93-.44.93-.94zM15.06 0v5.63H9.44V0h5.62zM13.2 3.75V1.87h-1.9v1.88h1.88zm9.31-.88 5.88-1L28.05 0 16.81 1.88l.13 1-.13.93L28.06 5.7l.32-1.88z',
            'signal' => 'M21.63 7.5c0 2.81-2 5.13-4.7 5.56v15.2h3.76v1.87H11.3v-1.88h3.75V13.06A5.64 5.64 0 0 1 16 1.87a5.64 5.64 0 0 1 5.62 5.63zm-9.38 0A3.77 3.77 0 0 0 16 11.31a3.78 3.78 0 0 0 0-7.56 3.76 3.76 0 0 0-3.75 3.75zM8.5 4.12 7 2.95a6.68 6.68 0 0 0-1.5 4.12c0 1.56.56 3 1.5 4.19l1.5-1.19a4.48 4.48 0 0 1 0-5.94zM3.75 7.06c0-2 .75-3.94 2.13-5.5L4.44.31a10.56 10.56 0 0 0-2.57 6.75c0 2.5.94 4.88 2.57 6.82l1.43-1.25a8.35 8.35 0 0 1-2.12-5.57zm22.75 0c0-1.5-.56-2.94-1.5-4.12l-1.5 1.19a4.44 4.44 0 0 1 0 5.93l1.5 1.2a6.72 6.72 0 0 0 1.5-4.2zm3.63 0c0-2.44-.94-4.81-2.57-6.75l-1.44 1.25a8.32 8.32 0 0 1 2.13 5.5c0 2.07-.75 4-2.13 5.57l1.44 1.25a10.6 10.6 0 0 0 2.57-6.82z',
            'shopping-cart' => 'M5.19 23.5C7 23.5 8.5 25 8.5 26.81S7 30.13 5.2 30.13s-3.32-1.5-3.32-3.32 1.5-3.31 3.32-3.31zm0 4.75a1.4 1.4 0 0 0 1.37-1.44c0-.75-.62-1.37-1.37-1.37a1.4 1.4 0 0 0-1.44 1.37c0 .82.63 1.44 1.44 1.44zm16-4.75c1.81 0 3.31 1.5 3.31 3.31s-1.5 3.32-3.31 3.32-3.32-1.5-3.32-3.32 1.5-3.31 3.32-3.31zm0 4.75a1.4 1.4 0 0 0 1.37-1.44c0-.75-.62-1.37-1.37-1.37a1.4 1.4 0 0 0-1.44 1.37c0 .82.63 1.44 1.44 1.44zm4-24.5H32v1.88h-5.19l-.5 3-1.93 14H1.93L-.13 7.5h24.75zm-.88 5.69H2l.31 1.87h21.75zM3.63 20.75h19.12l1.06-7.56H2.56z',
            'shopping-cart-full' => 'M5.19 23.5C7 23.5 8.5 25 8.5 26.81S7 30.13 5.2 30.13s-3.32-1.5-3.32-3.32 1.5-3.31 3.32-3.31zm0 4.75a1.4 1.4 0 0 0 1.37-1.44c0-.75-.62-1.37-1.37-1.37a1.4 1.4 0 0 0-1.44 1.37c0 .82.63 1.44 1.44 1.44zm16-4.75c1.81 0 3.31 1.5 3.31 3.31s-1.5 3.32-3.31 3.32-3.32-1.5-3.32-3.32 1.5-3.31 3.32-3.31zm0 4.75a1.4 1.4 0 0 0 1.37-1.44c0-.75-.62-1.37-1.37-1.37a1.4 1.4 0 0 0-1.44 1.37c0 .82.63 1.44 1.44 1.44zm4-24.5H32v1.88h-5.19l-.43 2.93-2 14.07H1.93L-.13 7.5h24.75zm-2.44 17 1.56-11.31H2l1.63 11.31h19.12zm-2.06-1.94v-7.43H18.8v5.56H7.5v-5.57H5.62v7.44H20.7zM7.5 5.56V3.75h11.31V5.5h1.88V1.87H5.62v3.7H7.5z',
            'settings' => 'M16 11.3a4.6 4.6 0 1 1 0 9.4 4.7 4.7 0 0 1-4.7-4.8c0-2.5 2-4.7 4.7-4.7zm0 7.4c1.6 0 2.8-1.2 2.8-2.8s-1.2-2.8-2.8-2.8a2.8 2.8 0 1 0 0 5.6zm15.9-1L27 19.4a8 8 0 0 1-.9 2l2.4 4.6a16 16 0 0 1-2.6 2.6l-4.5-2.4a9 9 0 0 1-2 .8l-1.6 5a16.4 16.4 0 0 1-3.6 0l-1.5-5a9 9 0 0 1-2.1-.8L6 28.5a16 16 0 0 1-2.6-2.6l2.4-4.5c-.4-.7-.7-1.4-.9-2.2L.1 17.7a16.4 16.4 0 0 1 0-3.6L5 12.6a9 9 0 0 1 .9-2.1L3.5 6c.7-1 1.6-1.8 2.6-2.6l4.5 2.4a9 9 0 0 1 2-.9L14.3.1a16.4 16.4 0 0 1 3.6 0l1.5 4.8c.8.3 1.5.5 2.1 1L26 3.3a16 16 0 0 1 2.6 2.6l-2.4 4.5.9 2.1L32 14a16.4 16.4 0 0 1 0 3.6zm-6.4 0 4.6-1.3v-.8l-3.6-1.2-1-.2-.3-1-.8-1.8-.4-.9.4-.9 1.9-3.4-.6-.5-4.3 2.2-.8-.4-1.9-.8-.9-.3-.3-.9-1.1-3.7h-.8l-1.1 3.7-.3 1-1 .2-1.8.8-.8.4-4.3-2.2-.6.5L8 10.5l-.4.9c-.4.5-.6 1.2-.8 1.8l-.3 1-4.6 1.4v.8l4.6 1.4.3.9c.2.6.4 1.2.8 1.8l.4.9-2.3 4.2.6.6 4.3-2.3.8.5c.6.4 1.2.6 1.8.8l1 .2.3 1 1.1 3.7h.8l1.1-3.7.3-1 1-.2c.6-.3 1.2-.4 1.8-.8l.8-.5 4.3 2.3.6-.6-1.9-3.3-.4-1 .4-.8c.4-.6.6-1.2.8-1.8z',
            'search' => 'm31.25 29.875-1.313 1.313-9.75-9.75a12.019 12.019 0 0 1-7.938 3c-6.75 0-12.25-5.5-12.25-12.25 0-3.25 1.25-6.375 3.563-8.688C5.875 1.25 8.937-.063 12.25-.063c6.75 0 12.25 5.5 12.25 12.25 0 3-1.125 5.813-3 7.938zm-19-7.312c5.688 0 10.313-4.688 10.313-10.375S17.938 1.813 12.25 1.813c-2.813 0-5.375 1.125-7.313 3.063-2 1.938-3.063 4.563-3.063 7.313 0 5.688 4.625 10.375 10.375 10.375z',
            'zoom-in' => 'm31.25 29.94-1.31 1.31-9.75-9.75a12 12 0 0 1-7.94 3A12.27 12.27 0 0 1 3.56 3.56a12.27 12.27 0 0 1 20.94 8.69c0 3-1.13 5.81-3 7.94zm-19-7.38a10.34 10.34 0 0 0 0-20.69 10 10 0 0 0-7.31 3.07 10 10 0 0 0-3.07 7.31c0 5.69 4.63 10.31 10.38 10.31zm.94-11.25V7.5H11.3v3.81H7.5v1.88h3.81v3.75h1.88v-3.75h3.75V11.3h-3.75z',
            'zoom-out' => 'm31.25 29.875-1.313 1.313-9.75-9.75a12.019 12.019 0 0 1-7.938 3c-6.75 0-12.25-5.5-12.25-12.25 0-3.25 1.25-6.375 3.563-8.688C5.875 1.25 8.937-.063 12.25-.063c6.75 0 12.25 5.5 12.25 12.25 0 3-1.125 5.813-3 7.938zm-19-7.312c5.688 0 10.313-4.688 10.313-10.375S17.938 1.813 12.25 1.813c-2.813 0-5.375 1.125-7.313 3.063-2 1.938-3.063 4.563-3.063 7.313 0 5.688 4.625 10.375 10.375 10.375zM7.5 11.25v1.875h9.438V11.25H7.5z',
            'cut' => 'M24.5 20.69a5.7 5.7 0 0 1 5.63 5.69A5.68 5.68 0 0 1 24.5 32a5.7 5.7 0 0 1-5.69-5.62c0-1.44.57-2.7 1.38-3.7l-4.2-4.43-4.18 4.44c.81 1 1.38 2.25 1.38 3.69A5.7 5.7 0 0 1 7.49 32a5.68 5.68 0 0 1-5.62-5.62 5.7 5.7 0 0 1 5.63-5.7c1.06 0 2 .32 2.81.82l4.38-4.62L2.94 4.44 4.3 3.12 16 15.5 27.69 3.12l1.37 1.32-11.75 12.44 4.38 4.62a5.3 5.3 0 0 1 2.81-.81zm-17 9.43a3.78 3.78 0 1 0 0-7.56 3.77 3.77 0 0 0 0 7.57zm17 0a3.78 3.78 0 1 0-3.81-3.75 3.77 3.77 0 0 0 3.81 3.75z',
            'ruler' => 'M9.44 0h13.12v32H9.44V0zm11.25 30.13V1.88H11.3v1.87h3.75v1.88H11.3V7.5h1.88v1.94H11.3v1.87h3.75v1.88H11.3v1.87h1.88V17H11.3v1.81h3.75v1.88H11.3v1.87h1.88v1.94H11.3v1.88h3.75v1.87H11.3v1.88h9.38z',
            'ruler-pencil' => 'M8.44 0a2.8 2.8 0 0 1 2.81 2.81v20.07l-4.62 9.3-4.75-9.3V2.8A2.85 2.85 0 0 1 4.75 0h3.69zM4.75 1.88c-.56 0-1 .43-1 .93v1.94h5.63V2.81c0-.5-.38-.93-.94-.93h-3.7zm-1 6.68h5.63V6.62H3.75v1.94zm3.69 17.81 1.94-3.93v-12H7.56v12.19H5.7v-12.2H3.75v12l2.06 3.94h1.63zM15.06 0h13.2v32h-13.2V0zm11.31 30.13V1.88h-9.43v1.87h3.75v1.88h-3.75V7.5h1.87v1.94h-1.87v1.87h3.75v1.88h-3.75v1.87h1.87V17h-1.87v1.81h3.75v1.88h-3.75v1.87h1.87v1.94h-1.87v1.88h3.75v1.87h-3.75v1.88h9.43z',
            'ruler-alt' => 'M22.63 0 32 9.38 9.37 32 0 22.62zM2.68 22.63l6.69 6.68L29.3 9.38l-6.68-6.7L21.3 4 24 6.69 22.62 8 20 5.38l-1.31 1.3L20 8l-1.3 1.38L17.3 8 16 9.38 18.63 12l-1.32 1.38-2.69-2.7-1.3 1.32 1.3 1.38-1.3 1.31L12 13.38l-1.32 1.31 2.63 2.63L12 18.69 9.37 16 8 17.32l1.37 1.37L8 20l-1.32-1.3L5.31 20 8 22.7 6.68 24 4 21.38z',
            'bookmark' => 'M6.69 1.88H24.5v29.06l-9-6.13-8.81 6.2V1.87zm15.87 25.5V3.75h-14v23.63l6.94-4.82z',
            'bookmark-alt' => 'm18.88 18.94-5.7-3.82-5.68 3.82V0h11.37v18.94zm-9.5-3.5 3.8-2.63L17 15.44V1.88H9.38v13.56zM30.11 1.87H20.7v1.88h7.56v24.5H3.75V3.75h1.88V1.87H1.88v28.25h28.25V1.88z',
            'reload' => 'M11.3 15v-1.8h-8A13 13 0 0 1 16 3.1a13 13 0 0 1 12.4 9.4l1.8-.5A14.8 14.8 0 0 0 16 1.2 14.9 14.9 0 0 0 1.9 11.5V3.7H0v11.4h11.3zm9.4 2H32v11.3h-1.9v-7.8A15 15 0 0 1 16 30.8 14.8 14.8 0 0 1 1.7 20l1.9-.5A13 13 0 0 0 16 29a13 13 0 0 0 12.6-10.1h-8V17z',
            'plus' => 'M30.13 16.94v-1.88h-13.2V1.87h-1.87v13.2H1.87v1.87h13.2v13.19h1.87v-13.2h13.19z',
            'pin' => 'M22.56 8.5a6.6 6.6 0 0 1-5.68 6.5v15.13H15v-15.2a6.58 6.58 0 0 1 1-13.06 6.58 6.58 0 0 1 6.56 6.63zM16 13.19a4.68 4.68 0 0 0 4.69-4.69 4.7 4.7 0 1 0-9.38 0A4.68 4.68 0 0 0 16 13.19zm2.81-3.75a3.78 3.78 0 0 0-3.75-3.81V7.5a1.9 1.9 0 0 1 1.88 1.94h1.87z',
            'pencil' => 'M29.3 5.4a2.9 2.9 0 0 1 0 4l-17.1 17-9.9 3.4 3.3-10 17-17a2.8 2.8 0 0 1 4 0zM5.8 25 7 26.2l3.7-1.3L7 21.3zm2.4-5.2 4 4 10.3-10.4-4-4zM19.9 8.1l4 4 1.3-1.3-4-4zm8 0c.4-.4.4-1 0-1.4L25.3 4a.9.9 0 0 0-1.4 0l-1.3 1.3 4 4z',
            'pencil-alt' => 'M31 3.5a2.8 2.8 0 0 1 0 4l-14 14L7 25l3.3-9.9L24.4.8a2.9 2.9 0 0 1 4 0zM10.6 20.3l1.2 1.1 3.6-1.2-3.6-3.6zm2.4-5.2 3.9 3.9 7.5-7.5-4-4zm8.8-9 4 4L27 8.9l-4-4zm8 0c.2-.2.3-.4.3-.7s-.1-.4-.3-.6l-2.6-2.6a1 1 0 0 0-1.4 0l-1.3 1.3 4 4zm-1.4 8v16H1.9V5.6H14V3.8H0V32h30.1V14.1h-1.9z',
            'paint-roller' => 'M28.25 3.75h1.88v1.88h-1.88v5.68H3.75V5.62h-.94c-.5 0-.94.44-.94 1v5.63c0 .5.44.94.94.94h11.32a2.8 2.8 0 0 1 2.8 2.81v2.81h1.88v13.2H13.2V18.8h1.87V16c0-.5-.44-.95-.94-.95H2.82A2.8 2.8 0 0 1 0 12.25V6.62a2.85 2.85 0 0 1 2.8-2.87h.94V0h24.5v3.75zM16.94 30.13v-9.44h-1.88v9.43h1.88zm9.43-20.7V1.89H5.63v7.56h20.75z',
            'paint-bucket' => 'M31.44 18.5h-6.75l-10.5 10.44a3.01 3.01 0 0 1-4.25 0L.88 19.8a2.98 2.98 0 0 1 0-4.25l4.18-4.19A6.62 6.62 0 0 1 3.13 6.7c0-1.82.68-3.44 1.93-4.75A6.66 6.66 0 0 1 9.81 0c1.75 0 3.44.69 4.7 1.94l.24-.25zM5 6.69c0 1.25.5 2.44 1.38 3.37l6.8-6.81a4.94 4.94 0 0 0-3.37-1.38A4.77 4.77 0 0 0 5 6.7zm7.88 20.93 6.87-6.93H4.44l6.81 6.93c.25.2.5.32.81.32s.57-.13.82-.32zm8.74-8.8 2.25-2.2h3.07L14.75 4.38 2.19 16.88c-.2.2-.32.5-.32.82s.13.56.32.81l.37.31h19.06zm7.88 3.68c.63.88 2.5 3.81 2.5 5.25 0 1.81-1.5 3.31-3.31 3.31s-3.25-1.5-3.25-3.31c0-1.44 1.93-4.38 2.56-5.25l.75-1.13zm-.81 6.69c.81 0 1.44-.63 1.44-1.44 0-.44-.63-1.75-1.38-3-.81 1.31-1.44 2.56-1.44 3 0 .81.63 1.44 1.38 1.44z',
            'na' => 'M16 .94a15.07 15.07 0 1 1-.02 30.14A15.07 15.07 0 0 1 16 .94zm0 1.87a13.14 13.14 0 0 0-9.94 21.81L24.63 6.07c-2.32-2-5.32-3.25-8.63-3.25zm0 26.38a13.14 13.14 0 0 0 9.94-21.81L7.37 25.93c2.32 2 5.32 3.25 8.63 3.25z',
            'mobile' => 'M23.5 0a2.85 2.85 0 0 1 2.88 2.81V29.2A2.85 2.85 0 0 1 23.5 32h-15a2.85 2.85 0 0 1-2.88-2.81V2.8A2.85 2.85 0 0 1 8.5 0h15zm-15 1.88c-.56 0-1 .43-1 .93v2.82h17V2.8c0-.5-.44-.93-1-.93h-15zm16 5.62h-17v15.06h17V7.5zm-1 22.63c.56 0 1-.44 1-.94v-4.7h-17v4.7c0 .5.44.93 1 .93h15zm-6.56-2.82c0-.56-.44-.93-.94-.93s-.94.37-.94.93c0 .5.44.94.94.94s.94-.44.94-.94z',
            'minus' => 'M28.25 15.06H3.75v1.88h24.5v-1.88z',
            'medall' => 'M16 0a9.47 9.47 0 0 1 9.44 9.44c0 2.56-1.06 5-2.94 6.75-.19.19-.37.31-.56.44l-.2.18c-.3.25-.68.44-1.05.7v13.55l-4.75-3.56-4.63 3.56V17.5c-.37-.25-.75-.44-1.06-.69l-.19-.18a3.41 3.41 0 0 1-.56-.44 9.22 9.22 0 0 1-2.94-6.75A9.47 9.47 0 0 1 16 0zm2.81 27.25v-7.94c-.87.32-1.87.44-2.81.44s-1.94-.13-2.81-.44v7.94l2.75-2.13zm2.38-12.38a7.54 7.54 0 0 0-5.19-13 7.54 7.54 0 0 0-5.19 13c.13.07.25.2.38.26l.25.18a7.42 7.42 0 0 0 9.19 0l.18-.18c.13-.07.25-.2.38-.26zm-.57-8.24-3.68.68V3.75h-1.88v3.56l-3.56-.68-.31 1.8 3.3.7-2.12 3.62 1.57.94L16 10.25l2.06 3.44 1.63-.94-2.19-3.62 3.44-.7z',
            'medall-alt' => 'M16 0a9.47 9.47 0 0 1 9.44 9.44c0 2.56-1.06 5-2.94 6.75-.19.19-.37.31-.56.44l-.2.18c-.3.25-.68.44-1.05.7v13.55l-4.75-3.56-4.63 3.56V17.5c-.37-.25-.75-.44-1.06-.69l-.19-.18a3.41 3.41 0 0 1-.56-.44 9.22 9.22 0 0 1-2.94-6.75A9.47 9.47 0 0 1 16 0zm2.81 27.25v-7.94c-.87.32-1.87.44-2.81.44s-1.94-.13-2.81-.44v7.94l2.75-2.13zm2.38-12.38a7.54 7.54 0 0 0-5.19-13 7.54 7.54 0 0 0-5.19 13c.13.07.25.2.38.26l.25.18a7.42 7.42 0 0 0 9.19 0l.18-.18c.13-.07.25-.2.38-.26zM19.3 9.45c0-1.88-1.5-3.32-3.31-3.32s-3.31 1.44-3.31 3.32c0 1.81 1.5 3.25 3.31 3.25s3.31-1.44 3.31-3.25z',
            'marker' => 'M20.06 1.88c1.5 0 2.5 1.3 2.5 3.12v8H20.7V5c0-.25 0-1.25-.63-1.25h-1.25v21.31l-3.5 4.38h-.25v1.25L13.2 32v-2.56h-.32l-3.43-4.38V2.88c0-.94-.07-1.75.56-2.38.31-.31.75-.5 1.31-.5h4.7c1.12 0 2.18.75 2.62 1.88h1.43zm-8.75 0v7.56h5.63V3.13c0-.7-.44-1.25-.94-1.25h-4.69zm3.13 25.62 2.5-3.13V11.31H11.3v13.06l2.5 3.13h.63z',
            'marker-alt' => 'M29.5 10.69c.56.56.81 1.31.63 2.12a3.2 3.2 0 0 1-1.07 1.88l-5.62 5.69-1.38-1.32 5.69-5.68c.31-.32.5-.63.56-.88 0-.19 0-.31-.18-.5l-.82-.81-16.37 16.37-5.57.63-.18-.2-.94.88L2 28.5l1.81-1.88-.19-.18.63-5.57 17-17c.69-.62 1.25-1.25 2.12-1.25.44 0 .88.2 1.25.57l3.32 3.3c.56.57.8 1.32.8 2.13-.05.38-.12.7-.3 1.07zM10.06 25.75l10.57-10.56-4-4L6.06 21.75l-.44 4 .44.44zM22 13.81l4.44-4.43c.25-.26.37-.57.44-.88 0-.13-.07-.44-.25-.69L23.3 4.56c-.06 0-.43.38-.68.63L18 9.8z',
            'arrow-up' => 'm28.5 16.69 1.31-1.38L16 1.5 2.19 15.31 3.5 16.7 15.06 5.12v25h1.88v-25z',
            'arrow-right' => 'M29.56 15.94 15.75 2.13l-1.38 1.3L25.95 15H1.87v1.88h24.07L14.37 28.44l1.38 1.37z',
            'arrow-left' => 'M30.13 16.88V15H6.05L17.63 3.44l-1.38-1.32L2.44 15.94 16.25 29.8l1.38-1.37L6.05 16.87h24.07z',
            'arrow-down' => 'M29.81 16.69 28.5 15.3 16.94 26.88v-25h-1.88v25L3.5 15.3l-1.31 1.4 13.8 13.81z',
            'lock' => 'M17.88 20.63c0-1-.82-1.88-1.88-1.88s-1.88.88-1.88 1.88c0 .75.38 1.3.94 1.62v4.06h1.88v-4.06c.56-.31.94-.94.94-1.63zm10.3-4.7a2.79 2.79 0 0 0-2.74-2.8V9.36c0-5.18-4.25-9.43-9.44-9.43S6.56 4.19 6.56 9.37v3.75a2.8 2.8 0 0 0-2.81 2.82v13.31a2.8 2.8 0 0 0 2.81 2.81h18.81c1.5 0 2.82-1.25 2.82-2.8V15.93zM8.5 13.14V9.37c0-4.18 3.38-7.56 7.5-7.56s7.5 3.38 7.5 7.56v3.76h-15zm17.81 2.8v13.32c0 .5-.43.94-.93.94H6.55a.92.92 0 0 1-.94-.94V15.94a.9.9 0 0 1 .94-.94h18.88c.43.06.87.44.87.94z',
            'location-arrow' => 'm3.69 3.69 26.56 9.94-14.31 2.3-2.25 14.32zM14.3 14.3l8.63-1.37-16-6 6 16z',
            'link' => 'M24.44 13.06c2.56-2.56 2.56-6.75 0-9.31s-6.75-2.56-9.32 0L9.5 9.38a6.6 6.6 0 0 0 4.69 11.25c1.69 0 3.31-.63 4.62-1.94l-1.31-1.32a4.8 4.8 0 0 1-6.69 0 4.8 4.8 0 0 1 0-6.68l5.63-5.63a4.8 4.8 0 0 1 6.68 0 4.8 4.8 0 0 1 0 6.69l-1.8 1.75 1.37 1.31zm-13.07 2.06a6.6 6.6 0 0 1 9.31 9.31L15 30.14a6.57 6.57 0 1 1-9.31-9.32l2-2L9 20.13l-2 2a4.8 4.8 0 0 0 0 6.68 4.8 4.8 0 0 0 6.69 0l5.69-5.68a4.8 4.8 0 0 0 0-6.7 4.8 4.8 0 0 0-6.7 0l-.24.26-1.32-1.31z',
            'layout' => 'M0 0h32v32H0V0zm1.88 11.31v18.82H18.8V11.3H1.88zm28.25 18.82V11.3h-9.44v18.81h9.43zM1.88 9.43h28.25V1.89H1.88v7.56z',
            'layers' => 'M24.5 1.9v20.7H0V1.9h24.5zm-2 18.8v-17H2v17h20.7zM32 9.4h-5.7v2h3.8v16.9H9.4v-3.8H7.5V30H32V9.4',
            'layers-alt' => 'M20.69 1.88V18.8H0V1.88h20.69zM18.8 16.94V3.75H1.88v13.19H18.8zm7.57 7.56v-17h-3.75v1.94h1.87v13.12h-17v-1.81H5.62v3.75h20.75zM32 13.19h-3.75v1.87h1.88v13.2H13.18v-1.88H11.3v3.75H32V13.19z',
            'key' => 'm27.88 11.88-3.25-3.32-1.32 1.31 3.25 3.32-1.31 1.31-3.31-3.25-9.88 9.81a5.7 5.7 0 0 1-4.56 9 5.66 5.66 0 0 1 0-11.31c1.19 0 2.31.38 3.19 1L26.06 4.5l1.32 1.38-1.44 1.37 3.25 3.25zM7.5 28.18a3.78 3.78 0 0 0 0-7.56 3.78 3.78 0 0 0 0 7.57z',
            'import' => 'm16 25.8 9.1-9.2-1.3-1.3-6.9 6.8V1.8h-1.8v20.3l-7-6.8L7 16.6zM30.1 17H32v12.2a2.8 2.8 0 0 1-2.8 2.8H2.8A2.8 2.8 0 0 1 0 29.2V17h1.9v12.2c0 .5.4 1 1 1h26.3c.5 0 1-.5 1-1V17z',
            'image' => 'M1.88 1.88h28.25v28.25H1.88V1.88zm26.37 26.37V24.5H3.75v3.75h24.5zm-24.5-5.69h24.5V3.75H3.75v18.81zm23-3.44-5.94-5.75-2.5 2.7-4.87-8.7L5.3 19.2l1.57 1.06 6.37-9.31 4.69 8.25 2.94-3.13 4.56 4.44z',
            'heart' => 'M23.5 1.25a8.5 8.5 0 0 1 8.25 10.5l-.25.69C29.62 20 17.12 30.13 16.56 30.56L16 31l-.56-.44C14.94 30.13 3.19 20.7.5 12.5l-.19-.69A6.74 6.74 0 0 1 0 9.7a8.5 8.5 0 0 1 8.5-8.44A8.54 8.54 0 0 1 16 5.81a8.54 8.54 0 0 1 7.5-4.56zm6.44 10a6.58 6.58 0 0 0-6.44-8.13 6.56 6.56 0 0 0-6.56 6.57v.5h-1.88v-.5A6.56 6.56 0 0 0 8.5 3.12 6.58 6.58 0 0 0 1.87 9.7c0 .5.07 1 .25 1.62l.2.56C4.5 18.57 13.55 26.57 16 28.64c2.5-2.13 12.19-10.57 13.69-16.7z',
            'heart-broken' => 'm.31 11.81.2.7c.18.62.5 1.3.93 2.18l1.69-.88c-.38-.75-.7-1.37-.82-1.93l-.18-.57a5.4 5.4 0 0 1-.25-1.62A6.58 6.58 0 0 1 8.5 3.13a6.56 6.56 0 0 1 6.56 6.56h1.88a6.56 6.56 0 0 1 6.56-6.56 6.58 6.58 0 0 1 6.44 8.12l-.25.69a11 11 0 0 1-.75 2l1.75.75c.37-.88.69-1.63.81-2.25l.25-.69a8.5 8.5 0 0 0-8.25-10.5A8.54 8.54 0 0 0 16 5.81a8.54 8.54 0 0 0-7.5-4.56A8.5 8.5 0 0 0 0 9.69c0 .69.06 1.31.31 2.12zM16 28.62c1.56-1.18 6-4.87 9.5-9.43L27 20.3c-4.44 5.81-10.19 10.06-10.44 10.25L16 31l-.56-.44A52.27 52.27 0 0 1 5.12 20.31l1.5-1.12A56.13 56.13 0 0 0 16 28.62zm10.69-14.68 5.87 4.19-1.12 1.5-4.75-3.38L21.38 20 16 16.25 10.69 20 5.3 16.25.56 19.63l-1.12-1.5 5.87-4.2 5.38 3.82L16 13.94l5.38 3.81z',
            'hand-stop' => 'M26.38 8.31a2.8 2.8 0 0 0-3.82-2.62v-.5a2.74 2.74 0 0 0-3.75-2.63C18.75 1.12 17.5 0 16 0s-2.69 1.13-2.82 2.56a2.51 2.51 0 0 0-.93-.18 2.85 2.85 0 0 0-2.88 2.8v8.26l-.44-.5c-1.06-1.25-2.5-1.56-3.75-.88a2.7 2.7 0 0 0-1.3 1.7c-.2.74-.13 1.5.24 2.05l6.19 13.2c.25.43.62.8 1.06 1v1.06c0 .5.38.93.94.93.5 0 .94-.43.94-.93v-1.7a.88.88 0 0 0-.75-.87 1.28 1.28 0 0 1-.57-.37l-6.18-13.2c-.13-.18-.13-.43-.07-.68s.2-.44.44-.56c.19-.07.69-.38 1.38.5l2.12 2.37c.25.25.69.38 1.07.25s.56-.5.56-.87V5.19c0-.5.44-.94 1-.94a1 1 0 0 1 .94.81v8.63c0 .56.43 1 .93 1s.94-.44.94-1V2.8c0-.56.38-.93.94-.93.5 0 .94.43.94.93v10.82c0 .5.44.93.94.93s.93-.43.93-.93V5.19l.07-.07c0-.43.5-.87 1-.87.56 0 .81.5.81.94v10.37c0 .5.44.94.94.94.56 0 .94-.44.94-.94V8.25c.06-.5.5-.88 1-.88s.93.38.93.94v13.63c0 1.31-.62 3.12-1.12 4.62-.44 1.32-.81 2.32-.81 3.07v1.43c0 .5.43.94.93.94.57 0 1-.44 1-.94v-1.43c0-.44.32-1.5.7-2.5.5-1.7 1.18-3.57 1.18-5.2V8.32z',
            'hand-open' => 'M28.69 10.19c.25-1.69-.63-3-2.13-3.19a2.2 2.2 0 0 0-1.87.44c-.07.06-.13.06-.19.12l.13-1.81c.12-1.56-1-2.88-2.57-3.06a2.7 2.7 0 0 0-2 .68c-.31.2-.5.5-.69.82V2.75a2.79 2.79 0 0 0-5.56 0v1.44c-.19-.32-.37-.63-.69-.82-.56-.5-1.25-.75-2-.68s-1.37.44-1.87 1-.69 1.31-.63 2L9.32 16l-.95-1.19a2.96 2.96 0 0 0-4.06-1.06 2.88 2.88 0 0 0-1.38 1.81c-.25.75-.12 1.56.32 2.25l6.62 11.44c.25.5.7.88 1.13 1.13v.68c0 .5.44.94.94.94.56 0 1-.44 1-.94v-1.31a.88.88 0 0 0-.75-.88 1.26 1.26 0 0 1-.7-.56L4.88 16.87a.95.95 0 0 1-.12-.8.97.97 0 0 1 .5-.7c.5-.31 1.19-.12 1.56.5l2.94 3.7c.25.3.69.43 1.06.3a.99.99 0 0 0 .63-.93L10.5 5.56c-.06-.25.06-.5.19-.69.12-.12.37-.25.62-.31a.9.9 0 0 1 .63.25c.19.13.31.38.31.63l1 10c0 .3.19.62.5.75.25.12.63.12.88 0 .12-.07.25-.13.3-.2.38-.18.57-.5.57-.8l.25-12.44c0-.5.38-.88.88-.88a.9.9 0 0 1 .87.94l.19 11.5c0 .5.44.87.94.94h.44c.56 0 1-.38 1-.88l.87-9c.06-.19.13-.44.31-.56a.94.94 0 0 1 .7-.25c.5.06.8.5.8 1l-.56 10c0 .31.13.62.44.81.19.13.31.19.44.13.25.18.56.25.87.12s.5-.44.56-.75l.94-6.25c.07-.31.2-.56.38-.69.12-.12.31-.12.5-.12.62.12.56.87.5 1.12l-2.19 15.13c-.13.56-.31.75-.63 1-.62.62-1.12 1.31-1.12 3.12v1.88c0 .5.44.94.94.94s.94-.44.94-.94v-1.88c0-1.18.25-1.43.62-1.75.38-.37.88-.87 1.06-2.06z',
            'hand-drag' => 'M26.31 10.56a3.04 3.04 0 0 0-2.94-3.06c-.3 0-.68.06-1 .13a2.89 2.89 0 0 0-2.75-2.07c-.37 0-.75.13-1.06.25a2.74 2.74 0 0 0-2.62-2 2.7 2.7 0 0 0-2.7 2c-.37-.12-.68-.25-1.05-.25a2.94 2.94 0 0 0-2.88 3V12c0 .06-.06.06-.06.06v1.38a3.82 3.82 0 0 0-1.44-.06c-.75.18-1.5.74-1.88 1.5-.43.87-.5 1.93-.06 2.87l3.19 6.88a2.85 2.85 0 0 0 2.06 2.12v2.44c0 .5.44.94.94.94s.94-.44.94-.94v-3.32c0-.25-.13-.5-.31-.68s-.44-.25-.75-.25c-.5.06-1-.25-1.07-.82-.06-.06-.06-.12-.06-.18l-3.25-7c-.19-.57-.06-1 .06-1.2.13-.24.38-.5.57-.5.25-.05.75 0 1.06.13v1.57c0 .56.44.93 1 .93.5 0 .94-.37.94-.93V8.56c0-.62.44-1.06 1-1.06.5 0 .75.31.87.69v5.06c0 .5.38.94.94.94.5 0 .94-.44.94-.94V6.87c0-.43.12-1.18 1-1.18s.87 1.06.87 1.18v5.32c0 .5.44.93.94.93.56 0 .94-.43.94-.93V8.37c.06-.5.44-.87.94-.87.56 0 1 .44 1 1v4c0 .5.37.94.93.94.5-.07.94-.44.94-.94v-1.2c0-.75 0-1.62.13-1.81 0 0 .12-.13.75-.13.5 0 1 .57 1 1.2v11c0 .74-.32 1.18-.82 1.74-.43.63-1.06 1.31-1.06 2.5v3.38c0 .5.38.93.94.93.5 0 .94-.43.94-.93V25.8c0-.44.25-.75.69-1.31.5-.63 1.25-1.5 1.25-2.94v-11z',
            'folder' => 'M15.06 7.5H32V32H0V3.75h11.38zm-4.5-1.88H1.87v7.57l28.25.06V9.44H14.26zm-8.69 24.5h28.25v-15l-28.25-.06v15.06z',
            'flag' => 'M24.5 18.81 2.12 10.13l22.38-8.7v17.38zm-1.94-2.75V4.2L7.31 10.13zM28.25 0h-1.88v32h1.88V0z',
            'flag-alt' => 'M28.25 0h-1.88v32h1.88V0zM2.87 1.81l5.44 7.63-5.5 7.44h21.7V1.8H2.87zm19.7 1.94V15h-16l4.06-5.5-4.07-5.75h16z',
            'flag-alt-2' => 'M28.25 0h-1.88v32h1.88V0zM9.37 1.88v3.75h-7.5v15.06h13.2v-3.75h9.37V1.87H9.37zm3.82 15.06v1.87H3.75V7.5h5.69v9.44h3.75zM11.25 3.75h11.31v11.31H11.31V5.62h-.06V3.75z',
            'eye' => 'M32 16.6v.7c-2.5 6.1-8.9 10.3-16 10.3S2.5 23.4 0 17.3a1.3 1.3 0 0 1 0-.7C2.6 10.4 9 6.3 16 6.3s13.5 4.1 16 10.3zm-16 9a15 15 0 0 0 14-8.7c-2.2-5.2-7.8-8.7-14-8.7S4.2 11.7 2 16.9a15 15 0 0 0 14 8.8zm0-15.5a6.9 6.9 0 0 1 6.9 6.8c0 3.9-3 7-6.9 7s-6.9-3.1-6.9-7a6.9 6.9 0 0 1 6.9-6.8zm0 11.8c2.8 0 5-2.2 5-5s-2.3-5-5-5-5 2.3-5 5 2.3 5 5 5zm0-7.5a2.6 2.6 0 0 1 2.6 2.5c0 1.5-1.2 2.6-2.6 2.6s-2.6-1.1-2.6-2.6a2.6 2.6 0 0 1 2.6-2.5zm0 3.2a.7.7 0 1 0-.7-.7c0 .4.3.7.7.7z',
            'export' => 'm8.2 11.2 6.9-7v20.2h1.8V4.1l7 7.1L25 9.9 16 .5 6.9 9.9zm22 5.8H32v12.2a2.8 2.8 0 0 1-2.8 2.8H2.8A2.8 2.8 0 0 1 0 29.2V17h1.9v12.2c0 .5.4 1 1 1h26.3c.5 0 1-.5 1-1V17z',
            'exchange-vertical' => 'm11.31 28.31 6.88-6.87 1.31 1.37-9.12 9.13-9.2-9.13 1.38-1.37 6.88 6.87V15.06h1.87v13.25zm-1 .94zm19.13-18.69L30.8 9.2 21.63.06 12.5 9.2l1.31 1.37L20.7 3.7v13.37h1.87V3.7z',
            'desktop' => 'M3.75 20.69V5.62h24.5V20.7H3.75zM5.63 7.5v11.31h20.75V7.5H5.63zm23.56-5.63A2.74 2.74 0 0 1 32 4.58V23.7a2.78 2.78 0 0 1-2.81 2.69H2.8A2.78 2.78 0 0 1 0 23.68V4.57c0-1.5 1.25-2.69 2.81-2.69H29.2zm.93 21.82V4.56c0-.44-.43-.81-.93-.81H2.8c-.5 0-.94.37-.94.81V23.7c0 .44.44.81.94.81h26.4c.5 0 .93-.37.93-.81zM9.45 28.25v1.88h13.12v-1.88H9.44z',
            'cup' => 'M32 1.88v.93c0 2.07-.13 4.13-.38 6.25-.62 5.5-2.37 11.94-5.25 13.32-.37.18-.75.3-1.12.3-.44 0-.88-.12-1.31-.37l-.44-.3c-1.69 2.62-3.88 4.05-6.56 4.37v3.75h5.75V32H9.49v-1.87h5.57V26.3c-2.87-.25-5-1.87-6.56-4.31l-.44.25a2.2 2.2 0 0 1-1.31.44c-.38 0-.75-.13-1.13-.32C2.75 21 1 14.57.37 9.07A53.21 53.21 0 0 1 0 2.8v-.94h4.25V0h23.5v1.87H32zM7.5 20.38l.19.25C5.25 15.93 4.44 9.24 4.3 3.75H1.88c.06 1.69.18 3.38.37 5.06C3.06 15.7 5 20.01 6.44 20.7c.25.12.44.12.62 0zm8.5 4.18c8.31 0 9.81-13.81 9.88-22.68H6.13c.06 7.5 1.3 22.68 9.87 22.68zM29.75 8.81c.19-1.69.31-3.37.38-5.06h-2.38c-.25 7.44-1.44 13.13-3.5 17l.25-.38.44.32c.19.12.37.12.62 0 1.44-.69 3.38-5 4.2-11.88z',
            'crown' => 'm23.75 12.69 8.56-7.19-3.25 24.63H2.94L-.31 5.5l8.44 7.19L16.06.13zM4.62 28.25h22.75l.25-1.88H4.38zm23.25-3.75 1.94-14.44-6.5 5.5L16.06 3.7l-7.5 11.87-6.37-5.44L4.13 24.5h23.75z',
            'comments' => 'M32 2.8A2.8 2.8 0 0 0 29.2 0H2.8A2.8 2.8 0 0 0 0 2.8v15a2.8 2.8 0 0 0 2.8 2.8h1v7.8l6.5-5.7L9 21.3l-3.4 2.9v-5.4H2.8a1 1 0 0 1-1-1v-15c0-.5.5-1 1-1h26.4c.5 0 1 .5 1 1v15c0 .5-.5 1-1 1h-1v1.8h1a2.8 2.8 0 0 0 2.8-2.8v-15zM26.4 18a2.8 2.8 0 0 0-2.8-2.8H14a2.8 2.8 0 0 0-2.8 2.8v5.8a2.8 2.8 0 0 0 2.8 2.8h1.7l6.8 5.8v-5.8h1a2.8 2.8 0 0 0 2.8-2.8V18zm-1.9 0v5.8c0 .5-.4 1-1 1h-2.8v3.6l-4.3-3.7h-2.3a1 1 0 0 1-1-1V18c0-.5.5-.9 1-.9h9.5c.5 0 .9.4.9 1z',
            'comment' => 'M29.2 0A2.8 2.8 0 0 1 32 2.8v18.8a2.9 2.9 0 0 1-2.8 2.9H12.6l-8.9 7.7v-7.7h-.9A2.9 2.9 0 0 1 0 21.6V2.8A2.8 2.8 0 0 1 2.8 0h26.4zm1 21.6V2.8c0-.5-.5-1-1-1H2.8a1 1 0 0 0-1 1v18.8c0 .6.5 1 1 1h2.8V28l6.3-5.4h17.3c.5 0 1-.4 1-1z',
            'comment-alt' => 'M29.2 0A2.8 2.8 0 0 1 32 2.8v18.8a2.9 2.9 0 0 1-2.8 2.9H12.6l-8.9 7.7v-7.7h-.9A2.9 2.9 0 0 1 0 21.6V2.8A2.8 2.8 0 0 1 2.8 0h26.4zm1 21.6V2.8c0-.5-.5-1-1-1H2.8a1 1 0 0 0-1 1v18.8c0 .6.5 1 1 1h2.8V28l6.3-5.4h17.3c.5 0 1-.4 1-1zM5.5 5.6v1.9h20.8V5.6H5.6zm0 3.8v2h20.8v-2H5.6zm0 3.8V15H17v-1.9H5.6z',
            'close' => 'm17.31 16 12.5-12.5-1.31-1.31L16 14.69 3.5 2.19 2.19 3.5 14.69 16 2.19 28.5l1.31 1.31L16 17.31l12.5 12.5 1.31-1.31z',
            'clip' => 'M22.63 8c0-3.06-2.32-6.19-6.7-6.19-4.5 0-6.5 3.19-6.5 6.19v18c0 2.19 2.13 4.13 4.57 4.13 2.56 0 4.81-2 4.81-4.2V23.2l.07-12.13c0-2.87-1.5-3.5-2.82-3.5-2.87 0-2.87 2.57-2.87 3.44v9.69h1.87V11c0-1.5.32-1.56 1-1.56.44 0 .88 0 .88 1.62v14.88c0 1.06-1.32 2.31-2.94 2.31-1.38 0-2.69-1.06-2.69-2.25V8c0-1.63 1-4.31 4.63-4.31 3.31 0 4.81 2.25 4.81 4.31v15.94h1.87V8z',
            'angle-up' => 'M30.8 22.4 16 7.6 1.2 22.4l1.4 1.4L16 10.2l13.4 13.6z',
            'angle-right' => 'M24.9 16 10 1.1 8.8 2.5l13.4 13.4L8.8 29.4l1.3 1.4z',
            'angle-left' => 'M9.8 16 23.2 2.4 22 1.2 7.1 15.9 22 30.7l1.4-1.3z',
            'angle-down' => 'm30.8 9.6-1.4-1.3L16 21.6 2.6 8.3 1.2 9.6 16 24.3z',
            'check' => 'm29 3.31-1.56-1L12 25.88l-7.63-6.82-1.25 1.38 9.25 8.31z',
            'check-box' => 'M26.38 10.88v17.37H3.75V5.62h13.94V3.75H1.87v26.38h26.38V10.88h-1.88zM9.13 15.3l4.8 4.88L27 .44l1.56 1-14.3 21.69-6.45-6.44z',
            'camera' => 'M11.19 5.63H32v22.62H0V5.62h5.75V3.75h5.44v1.88zm18.94 20.75v-13.2h-2.94a7.69 7.69 0 0 1 1.06 3.76 7.59 7.59 0 0 1-7.56 7.56 7.58 7.58 0 0 1-7.5-7.56c0-1.38.37-2.63 1.06-3.75H1.87v13.18h28.25zm-3.75-9.44a5.66 5.66 0 0 0-11.32 0c0 3.12 2.5 5.62 5.63 5.62s5.68-2.5 5.68-5.62zm-.75-5.63h4.5V7.5H1.88v3.81h13.87a7.46 7.46 0 0 1 9.88 0z',
            'announcement' => 'M31 4.19c.56 0 1 .44 1 1v21.56c0 .5-.44.94-1 .94h-3.63c-.56 0-1-.44-1-.94V25.5l-5.93-1.06a6.4 6.4 0 0 1-6.32 5A6.5 6.5 0 0 1 7.56 23c0-.31 0-.63.06-.94L5.7 21.7v.62c0 .82-.7 1.5-1.5 1.5H1.5c-.8 0-1.5-.69-1.5-1.5V13.5c0-.81.7-1.5 1.5-1.5h2.7c.8 0 1.5.69 1.5 1.5v.5l20.68-7.56V5.19c0-.57.44-1 1-1H31zM14.12 27.56c2.2 0 4-1.43 4.5-3.5L9.5 22.38c0 .18-.06.43-.06.62 0 2.5 2.06 4.56 4.68 4.56zm16-1.75V6.06h-1.87v1.7L3.81 16.68v-2.75H1.87v8h1.94v-2.5l24.44 4.5v1.87h1.88z',
            'brush' => 'M29.94 3.38 28.37 2.3 16.2 20.2l1.5 1.06zm-13 22.93a3.76 3.76 0 0 0-3.75-3.75c-1.13 0-2.44.94-2.75 1.13l-8.57 6.44H13.2a3.77 3.77 0 0 0 3.75-3.82zm-1.88 0c0 1.07-.87 1.94-1.87 1.94H7.5l4.06-3.06c.5-.38 1.32-.75 1.63-.75 1 0 1.87.87 1.87 1.87z',
            'briefcase' => 'M13.19 24.5h5.62v-2.88h-1.87v.94h-1.88v-.93H13.2v2.87zM32 20.69V5.62h-6.81C23.44 2.2 19.94 0 15.99 0S8.57 2.19 6.82 5.63H0v15.06h1.87V32h28.25V20.7H32zM9 5.62c1.5-2.3 4.13-3.75 7-3.75s5.5 1.44 7 3.75H9zM28.25 20.7v9.44H3.75V20.7h24.5zm1.88-13.2v11.31H1.88V7.5h28.25z',
            'bolt' => 'm26.94 3.81-6.13 9.44h5.5L8.44 28.38 12.25 17H9.06L13.5 3.81h13.44zm-5.75 11.31h-3.82L23.5 5.7h-8.69l-3.12 9.44h3.12l-2.44 7.5z',
            'bolt-alt' => 'M22.25 15.06h-9.19l7.25-10.75-1.56-1.06L9.5 16.94h9.62L13.37 27.8l1.7.88z',
            'blackboard' => 'M16.94 3.75h13.19v18.81H1.88V3.75h13.18V0h1.88v3.75zm11.31 16.94V5.62H3.75V20.7h24.5zM6.56 24.5v1.88h4.94l-2.87 4.37 1.56 1 3.5-5.38h1.37V32h1.88v-5.63h1.37l3.5 5.38 1.57-1-2.82-4.38h4.88V24.5H6.56z',
            'bag' => 'M24.5 7.5h5.63V32H1.88V7.5h5.68V3c0-1.63 1.38-3 3.07-3h10.75a3.11 3.11 0 0 1 3.12 3v4.5zM9.44 3v4.5h13.12V3c0-.63-.5-1.13-1.18-1.13H10.63c-.63 0-1.2.5-1.2 1.13zm18.81 27.13V15.05H3.75v15.06h24.5zm0-16.94V9.44H24.5v1.19h-1.94v-1.2H9.44v1.2H7.56v-1.2H3.75v3.76h24.5z',
            'move' => 'M25.6 21.4 31 16l-5.4-5.4-1.4 1.4 3.2 3H16.9V4.7L20 7.8l1.4-1.4L16 1l-5.4 5.4L12 7.7l3-3V15H4.7l3.1-3-1.4-1.4L1 16l5.4 5.4L7.7 20l-3-3H15v10.4l-3-3.1-1.4 1.3L16 31l5.4-5.4-1.4-1.4-3 3.2V16.9h10.4L24.3 20z',
            'arrows-vertical' => 'm22 22.7-5 5.1V4.2l5 5.1L23.2 8 16 .6 8.7 8l1.4 1.3 5-5.1v23.6l-5-5.1L8.8 24l7.2 7.4 7.3-7.4z',
            'arrows-horizontal' => 'M31.44 16 24 8.75l-1.31 1.31 5.12 5H4.2l5.12-5L8 8.75.56 16 8 23.25l1.31-1.31-5.12-5H27.8l-5.12 5L24 23.25z',
            'fullscreen' => 'M30.13 21.38h-1.88v5.5L17.31 16 28.25 5.12v5.5h1.88V1.88h-8.75v1.87h5.5L16 14.69 5.12 3.75h5.5V1.87H1.88v8.75h1.87v-5.5L14.69 16 3.75 26.88v-5.5H1.87v8.75h8.75v-1.88h-5.5L16 17.31l10.88 10.94h-5.5v1.88h8.75v-8.75z',
            'arrow-top-right' => 'M30.13 1.88h-17v1.87h13.74L7.5 23.13l1.31 1.37L28.25 5.06v13.75h1.88V1.87z',
            'arrow-top-left' => 'm23.13 24.5 1.3-1.38L5.07 3.75h13.75V1.87h-17v16.94H3.7V5.06z',
            'arrow-circle-up' => 'm16 10.88-8.19 8.24 1.31 1.32L16 13.56l6.88 6.88 1.3-1.31zM32 16c0-8.81-7.19-16-16-16S0 7.19 0 16s7.19 16 16 16 16-7.19 16-16zm-1.88 0a14.12 14.12 0 1 1-28.28.02A14.12 14.12 0 0 1 30.13 16z',
            'arrow-circle-right' => 'm12.88 7.81-1.32 1.32L18.44 16l-6.88 6.88 1.31 1.3L21.13 16zM32 16c0-8.81-7.19-16-16-16S0 7.19 0 16s7.19 16 16 16 16-7.19 16-16zm-1.88 0a14.12 14.12 0 1 1-28.28.02A14.12 14.12 0 0 1 30.13 16z',
            'arrow-circle-left' => 'M20.44 9.13 19.12 7.8 10.88 16l8.26 8.19 1.3-1.31L13.57 16zM32 16c0-8.81-7.19-16-16-16S0 7.19 0 16s7.19 16 16 16 16-7.19 16-16zm-1.88 0a14.12 14.12 0 1 1-28.28.02A14.12 14.12 0 0 1 30.13 16z',
            'arrow-circle-down' => 'M22.88 11.56 16 18.44l-6.88-6.88-1.3 1.32L16 21.13l8.19-8.25zM32 16c0-8.81-7.19-16-16-16S0 7.19 0 16s7.19 16 16 16 16-7.19 16-16zm-1.88 0a14.12 14.12 0 1 1-28.28.02A14.12 14.12 0 0 1 30.13 16z',
            'angle-double-up' => 'M16 11.44 3.12 24.3l1.32 1.38L16 14.06 27.56 25.7l1.32-1.38zM16 5 4.44 16.56 3.12 15.2 16 2.3l12.87 12.9-1.3 1.37z',
            'angle-double-right' => 'M18.13 16 5.24 3.12l-1.3 1.33L15.5 16 3.94 27.56l1.31 1.32zM14.38 3.12 27.24 16 14.37 28.88l-1.3-1.32L24.61 16 13.06 4.44z',
            'angle-double-left' => 'M15.06 16 26.63 4.44l-1.38-1.32L12.38 16l12.87 12.87 1.38-1.3zM17.5 4.44 5.94 16 17.5 27.56l-1.31 1.32L3.25 16 16.19 3.13z',
            'angle-double-down' => 'M16 20.06 28.88 7.13 27.55 5.8 16 17.38 4.44 5.8 3.12 7.13zm0 6.44 11.56-11.56 1.32 1.31L16 29.13 3.13 16.24l1.3-1.31z',
            'zip' => 'm18.19 0 10.06 10v22H3.75V0H18.2zm.62 3.25v6.19h6.2zM5.63 30.13h20.75V11.3h-9.44V1.87h-3.75v1.88H11.3V1.87H5.62v28.25zm3.8-15.07v1.88h1.88v-1.88H9.44zm1.88 0h1.88V13.2H11.3v1.87zm0-3.75h1.88V9.44H11.3v1.87zm-1.87 0v1.88h1.87V11.3H9.44zm0-3.81v1.94h1.87V7.5H9.44zm1.87 0h1.88V5.62H11.3V7.5zM9.44 3.75v1.88h1.87V3.75H9.44zm1.87 13.94a3.76 3.76 0 0 1 3.75 3.75c0 .62-.18 1.25-.5 1.81a3.67 3.67 0 0 1-2.87 1.94h-.38c-2.12 0-3.81-1.69-3.81-3.75s1.69-3.75 3.81-3.75zm1.63 4.62c.19-.25.25-.56.25-.87a1.9 1.9 0 0 0-1.88-1.88c-1.06 0-1.87.82-1.87 1.88s.81 1.87 1.87 1.87h.2a1.85 1.85 0 0 0 1.43-1z',
            'world' => 'M16 0a16 16 0 1 1 0 32 16 16 0 0 1 0-32zM2 17c0 2 .6 3.9 1.6 5.6h4.8a21.2 21.2 0 0 1-.9-5.7H1.9zm5.5-2c0-1.9.4-3.7 1-5.6h-5A13.3 13.3 0 0 0 2 15.1h5.6zm3-5.6a19.1 19.1 0 0 0-1.1 5.7h13.2a21.3 21.3 0 0 0-1-5.7H10.4zM9.3 17c0 2 .4 3.9 1 5.7h11.2c.6-1.8.9-3.7 1-5.7H9.4zm15.1 0a19 19 0 0 1-1 5.7h5A14.3 14.3 0 0 0 30 17h-5.6zm0-1.8H30c-.2-2-.7-4-1.6-5.7h-5c.6 1.9 1 3.7 1 5.7zm2.8-7.6a14.3 14.3 0 0 0-7.4-5 26 26 0 0 1 3 5h4.4zM17.1 1.9h-2.2a23.3 23.3 0 0 0-3.7 5.6h9.6a22 22 0 0 0-3.7-5.6zm-5.1.6a13.8 13.8 0 0 0-7.3 5h4.4a23.6 23.6 0 0 1 2.9-5zm-7.3 22a14.4 14.4 0 0 0 7.4 5 26 26 0 0 1-3-5H4.8zM15 30.1h2a21.8 21.8 0 0 0 3.8-5.6h-9.6c1 2 2.2 3.9 3.8 5.6zm5-.5c3-1 5.6-2.7 7.4-5.1H23a24.3 24.3 0 0 1-3 5z',
            'wheelchair' => 'M20.5 24.19a7.43 7.43 0 0 1-7.31 5.94 7.54 7.54 0 0 1-1.94-14.81l-.5-1.82a9.36 9.36 0 0 0-7 9.06A9.47 9.47 0 0 0 13.19 32a9.36 9.36 0 0 0 9.19-7.44zm9.63 4.25h-2l-1.82-7.75H15l-.31-3.82 7.18-1.8-.43-1.82-6.88 1.69-.5-7.5a3.88 3.88 0 0 0 2.88-3.7c0-2.05-1.7-3.74-3.75-3.74S9.44 1.69 9.44 3.75a3.77 3.77 0 0 0 2.75 3.62l1 15.25H24.8l1.81 7.75h3.5v-1.93zM13.18 5.62a1.84 1.84 0 0 1-1.88-1.87c0-1 .82-1.88 1.88-1.88 1 0 1.87.88 1.87 1.88 0 1.06-.87 1.88-1.87 1.88z',
            'view-list' => 'M0 0h32v7.5H0V0zm30.13 5.63V1.88H1.88v3.75h28.25zM0 18.8v-7.5h32v7.5H0zm1.88-5.62v3.75h28.25v-3.75H1.88zM0 30.13v-7.57h32v7.57H0zm1.88-5.63v3.75h28.25V24.5H1.88z',
            'view-list-alt' => 'M9.44 0H32v7.5H9.44V0zm20.69 5.63V1.88H11.3v3.75h18.81zM9.43 18.8v-7.5H32v7.5H9.44zm1.88-5.62v3.75h18.82v-3.75H11.3zM9.44 30.13v-7.57H32v7.57H9.44zm1.87-5.63v3.75h18.82V24.5H11.3zM0 7.5V0h7.5v7.5H0zm1.88-5.63v3.75h3.75V1.88H1.88zM0 18.82v-7.5h7.5v7.5H0zm1.88-5.62v3.75h3.75V13.2H1.88zM0 30.13v-7.57h7.5v7.57H0zm1.88-5.63v3.75h3.75V24.5H1.88z',
            'view-grid' => 'M0 13.19V0h13.19v13.19H0zM1.88 1.88v9.43h9.43V1.87H1.87zM18.8 0H32v13.19H18.8V0zm11.31 11.31V1.87H20.7v9.44h9.43zM0 32V18.81h13.19V32H0zm1.88-11.31v9.44h9.43v-9.44H1.87zM18.8 32V18.81H32V32H18.8zm1.88-11.31v9.44h9.44v-9.44h-9.44z',
            'uppercase' => 'M13.19 7.5H1.88v3.81h1.87V9.44H7.5V24.5H5.62v1.88h5.7V24.5H9.43V9.44h3.75v1.87h1.87V7.5H13.2zm15.06 0h1.88v3.81h-1.88V9.44H24.5V24.5h1.88v1.88h-5.7V24.5h1.88V9.44h-3.75v1.87h-1.87V7.5h11.31z',
            'upload' => 'M32 30.13H0V32h32v-1.88zM15.06 3.18 8.2 10.06 6.88 8.75 16-.38l9.13 9.13-1.32 1.31-6.87-6.87V24.5h-1.88V3.2z',
            'underline' => 'M28.25 1.88h-5.69v1.87h1.94v12.19a8.5 8.5 0 0 1-17 0V3.75h1.94V1.87H3.75v1.88h1.88v12.19a10.38 10.38 0 0 0 20.75 0V3.75h1.87V1.87zM3.75 30.13v-1.88h24.5v1.88H3.75z',
            'truck' => 'M32 5.63v22.56h-3.75v.06a3.78 3.78 0 0 1-7.56 0v-.06H11.3v.06a3.77 3.77 0 0 1-7.56 0v-.06H0V18.8h3.62l2.25-7.5h5.44V5.62H32zM7.31 13.18 5.62 18.8h5.7v-5.6h-4zm.19 16.93c1.06 0 1.94-.87 1.94-1.87a1.9 1.9 0 0 0-1.94-1.88c-1 0-1.87.82-1.87 1.88 0 1 .87 1.88 1.87 1.88zm17 0c1 0 1.88-.87 1.88-1.87a1.9 1.9 0 0 0-1.88-1.88 1.9 1.9 0 0 0-1.94 1.88c0 1 .88 1.88 1.94 1.88zm5.63-3.8V7.5H13.18v13.19H1.87v5.62h2.44a3.75 3.75 0 0 1 6.44 0h10.5a3.75 3.75 0 0 1 6.44 0h2.44z',
            'timer' => 'M16.94 3.81A14.11 14.11 0 0 1 16 32a14.11 14.11 0 0 1-.94-28.19V1.87h-2.8V0h7.5v1.88h-2.82V3.8zM16 30.13c6.75 0 12.25-5.5 12.25-12.25S22.75 5.63 16 5.63 3.75 11.13 3.75 17.88 9.25 30.13 16 30.13zm.94-13.2v-5.62h-1.88v7.5h9.44v-1.87h-7.56z',
            'ticket' => 'M17.88 1.88h6.62v28.25h-6.63v-.94c0-1.07-.8-1.88-1.87-1.88s-1.88.82-1.88 1.88v.93H7.5V1.88h6.63v.94c0 1.07.8 1.88 1.87 1.88s1.88-.82 1.88-1.88v-.94zm-5.5 1.87H9.44v11.31h13.12V3.75h-2.94c-.37 1.63-1.87 2.81-3.62 2.81s-3.25-1.18-3.63-2.81zm7.24 24.5h2.94V16.94H9.44v11.31h2.94c.37-1.63 1.87-2.81 3.62-2.81s3.25 1.18 3.63 2.81z',
            'thumb-up' => 'M28.94 18.31A2.93 2.93 0 0 0 30.13 16a2.85 2.85 0 0 0-2.88-2.81H20l.75-4c.25-1.25.5-2.82-.19-3.94a2.55 2.55 0 0 0-2.25-1.31c-.62 0-1.75.25-2.69 1.75l-5.8 9.37H5.5c-.5 0-.94.44-.94.94 0 .56.44 1 .94 1h4.87a.8.8 0 0 0 .75-.5l6.13-9.81c.31-.57.69-.88 1.06-.88.31 0 .56.19.63.38.43.62.06 2.12-.07 2.62l-.93 5.13c-.07.3 0 .56.18.8a1 1 0 0 0 .7.32h8.43c.56 0 1 .44 1 .94 0 .56-.5 1-1 1h-3.13c-.5 0-.93.37-.93.94 0 .5.43.94.93.94h2.38c.81 0 .81 0 .81.93 0 .44-.25.94-.87.94h-2.69c-.5 0-.94.38-.94.94 0 .5.44.94.94.94h1.44c.5 0 1.31.12 1.31.94 0 .56-.44.93-1 .93h-2.37c-.5 0-.94.38-.94.94 0 .5.44.94.94.94h.18c1.82 0 1.94.12 1.94 1 0 .31-.06.5-.19.69-.12.12-.43.19-.8.19H13.62c-.75 0-1.32-.44-1.94-.88-.63-.5-1.32-1.06-2.25-1.06H5.5c-.5 0-.94.44-.94.94 0 .56.44.93.94.93h3.94c.31 0 .69.32 1.12.63a4.8 4.8 0 0 0 3.07 1.31h10.62a3.1 3.1 0 0 0 2.19-.75c.5-.5.75-1.19.75-2.06a7.1 7.1 0 0 0-.25-1.31 2.7 2.7 0 0 0 1.44-2.44c0-.5-.13-1-.38-1.44a2.68 2.68 0 0 0 1.19-2.31c0-.63-.13-1.13-.25-1.5z',
            'thumb-down' => 'M27.44 17.88c0-.5-.44-.94-.94-.94h-4.88c-.3 0-.62.18-.8.43l-6.07 9.88c-.31.5-.69.81-1.06.81-.32 0-.57-.18-.63-.31-.44-.69-.06-2.13.06-2.63l.94-5.18a.82.82 0 0 0-.19-.75c-.18-.25-.43-.32-.75-.32H4.75c-.56 0-1-.43-1-1 0-.5.44-.93 1-.93h3.12c.5 0 .94-.44.94-.94s-.44-.94-.94-.94H6c-.63-.12-1.31-.69-1.31-1 0-.44.25-.87.87-.87h2.69c.5 0 .94-.44.94-.94a.92.92 0 0 0-.94-.94H6.8c-.5 0-1.31-.13-1.31-1 0-.5.44-.88 1-.88h2.37c.5 0 .94-.43.94-.93s-.44-.94-.94-.94h-.25c-1.87 0-1.87-.69-1.87-1 0-.63.12-.94 1-.94h10.62c.75 0 1.32.44 1.94.94s1.31 1 2.25 1h3.94c.5 0 .94-.38.94-.94 0-.5-.44-.94-.94-.94h-3.94c-.31 0-.69-.31-1.12-.62a4.8 4.8 0 0 0-3.07-1.32H7.75c-1.81 0-2.94 1.07-2.94 2.82 0 .31.06.81.31 1.31a2.75 2.75 0 0 0-1.5 2.44c0 .5.13 1 .38 1.44a2.76 2.76 0 0 0-1.19 2.3c0 .57.19 1 .5 1.38a2.84 2.84 0 0 0-1.44 2.44 2.9 2.9 0 0 0 2.88 2.88H12l-.75 4c-.25 1.19-.5 2.81.18 3.94a2.63 2.63 0 0 0 2.26 1.25c.62 0 1.75-.2 2.68-1.75l5.82-9.38h4.3c.5 0 .95-.44.95-.94z',
            'text' => 'M26.38 3.75H5.63v5.69H7.5V5.63h7.56v22.62h-3.12v1.88h8.12v-1.88h-3.12V5.62h7.56v3.82h1.88V3.75z',
            'stats-up' => 'M32 30.13H0V32h32v-1.88zM9.81 15 2.7 21.44l-1.25-1.38 8.25-7.43 7.75 5.56L27 7.5h-4.5V5.62h7.63v7.63h-1.88V8.94L17.7 20.69z',
            'stats-down' => 'M9.75 16.56 17.5 11l9.56 10.63h-4.5v1.87h7.63v-7.56H28.3v4.31L17.75 8.44l-7.88 5.68-7.12-6.37L1.5 9.13zM0 30.13h32V32H0v-1.88z',
            'split-v' => 'm20.06 24.75-3.12 3.13v-7.13h-1.88v7.13l-3.12-3.13-1.32 1.31L16 31.44l5.38-5.38zm-5-20.63-3.12 3.13-1.31-1.31L16 .56l5.38 5.38-1.32 1.31-3.12-3.13v7.13h-1.88V4.12zM0 15.06h32v1.88H0v-1.88z',
            'split-h' => 'm4.13 15.06 3.12-3.12-1.31-1.31L.56 16l5.38 5.38 1.31-1.32-3.13-3.12h7.13v-1.88H4.12zm21.93-4.43L31.44 16l-5.38 5.38-1.31-1.32 3.13-3.12h-7.13v-1.88h7.13l-3.13-3.12zM15.06 32V0h1.88v32h-1.88z',
            'smallcap' => 'M11.31 11.13H0v3.8h1.88v-1.87h3.75v15.07H3.75V30h5.69v-1.87H7.5V13.06h3.81v1.88h1.88v-3.81H11.3zm18.81-7.38H32v4.88h-1.88v-3h-7.56v22.62h1.94v1.88h-5.69v-1.88h1.88V5.62h-7.5v3H11.3V3.75h18.81z',
            'shine' => 'M16 9.44a6.56 6.56 0 1 1 0 13.12 6.56 6.56 0 0 1 0-13.12zm0 11.25c2.63 0 4.69-2.06 4.69-4.69s-2.07-4.69-4.69-4.69-4.69 2.06-4.69 4.69 2.06 4.69 4.69 4.69zm.94-13.19V1.87h-1.88V7.5h1.88zm-1.88 17v5.63h1.88V24.5h-1.88zm15.06-9.44H24.5v1.88h5.63v-1.88zM7.5 16.94v-1.88H1.87v1.88H7.5zm15.13-6.25 4-4-1.32-1.32-4 4zM9.38 21.3l-4 4 1.3 1.32 4-4zm13.24 0-1.3 1.32 4 4 1.3-1.32zM9.38 10.7l1.32-1.31-4-4-1.31 1.3z',
            'shift-right' => 'm15.75 6.88-1.38 1.3 6.88 6.88H0v1.88h21.25l-6.88 6.87 1.38 1.32L24.88 16zM30.13 0H32v32h-1.88V0z',
            'shift-left' => 'M32 16.94v-1.88H10.75l6.88-6.87-1.38-1.32L7.12 16l9.13 9.13 1.38-1.32-6.88-6.87H32zM0 32V0h1.88v32H0z',
            'shield' => 'M28.25 1.94h1.88v12.81c0 10.44-13.32 15.13-13.88 15.31l-.31.13-.32-.13C15.06 29.88 1.87 25 1.87 14.81V1.94h1.88a5.7 5.7 0 0 0 5.69 5.62 5.68 5.68 0 0 0 5.62-5.62h1.88a5.68 5.68 0 0 0 5.62 5.62 5.7 5.7 0 0 0 5.69-5.62zM3.75 14.8c0 7.2 8.19 11.57 11.31 13V6.88C13.7 8.44 11.7 9.44 9.44 9.44s-4.31-1-5.69-2.56v7.93zm24.5-.06V6.87c-1.38 1.57-3.44 2.57-5.69 2.57s-4.25-1-5.62-2.56v20.87c3.19-1.38 11.31-5.69 11.31-13z',
            'notepad' => 'M1.9 0H30v32H2V0zm26.4 30.1V2h-3.8v2a2.8 2.8 0 0 1 1.9 2.7 2.9 2.9 0 0 1-2.9 2.8 2.9 2.9 0 0 1-2.8-2.8A3 3 0 0 1 22.6 4V2h-5.7v2a2.8 2.8 0 0 1 2 2.7c0 1.5-1.3 2.8-2.9 2.8s-2.8-1.3-2.8-2.8c0-1.2.7-2.3 1.9-2.7V2H9.4v2a2.8 2.8 0 0 1 2 2.7 2.9 2.9 0 0 1-2.9 2.8 2.9 2.9 0 0 1-2.9-2.8A3 3 0 0 1 7.5 4V2H3.7v28h24.6zM9.4 6.5c0-.4-.4-.9-.9-.9-.6 0-1 .5-1 1s.4.9 1 .9c.5 0 1-.4 1-1zm7.5 0c0-.4-.4-.9-.9-.9s-1 .5-1 1 .5.9 1 .9 1-.4 1-1zm7.6 0c0-.4-.4-.9-1-.9a1 1 0 0 0-1 1c0 .5.5.9 1 .9.6 0 1-.4 1-1z',
            'server' => 'M32 6.56c0 .32-.06.63-.13.94H32v17.94C32 29.69 23.75 32 16 32S0 29.7 0 25.44V7.5h.13A4.8 4.8 0 0 1 0 6.56C0 2.31 8.25 0 16 0s16 2.31 16 6.56zM16 1.88c-8.06 0-14.13 2.5-14.13 4.68 0 .75.75 1.63 2.07 2.32 2.69 1.5 7.19 2.43 12.06 2.43s9.38-.93 12.06-2.43c1.32-.7 2.07-1.57 2.07-2.32 0-2.19-6.07-4.69-14.13-4.69zm0 28.25c8.06 0 14.13-2.5 14.13-4.7v-3.12c-.32.25-.7.57-1.13.82-2.63 1.43-6.63 2.37-11.06 2.56-.63 0-1.32.06-1.94.06-5.19 0-10.06-1-13-2.62-.44-.25-.81-.57-1.13-.82v3.13c0 2.19 6.07 4.69 14.13 4.69zm12.06-8.7c1.32-.74 2.07-1.55 2.07-2.3v-3.07c-.32.25-.7.5-1.13.75-2.94 1.63-7.81 2.63-13 2.63s-10.06-1-13-2.63a8.7 8.7 0 0 1-1.12-.75v3.07c0 .75.75 1.56 2.06 2.3 2.31 1.32 6.06 2.2 10.25 2.38.62 0 1.19.07 1.81.07 4.88 0 9.38-.94 12.07-2.44zm0-6.24c1.32-.75 2.07-1.56 2.07-2.31V9.8c-.32.25-.7.5-1.13.75-2.94 1.63-7.81 2.63-13 2.63s-10.06-1-13-2.63a8.7 8.7 0 0 1-1.12-.75v3.06c0 .76.75 1.57 2.06 2.32 2.69 1.5 7.19 2.37 12.06 2.37s9.38-.87 12.07-2.37z',
            'quote-right' => 'M13.75 12.94v.12C12.94 26.31 3.37 27.63 3.31 27.63l-.25-1.88c.25-.06 5.44-.81 7.75-7.31A6.63 6.63 0 0 1 .5 12.94a6.64 6.64 0 0 1 6.62-6.69c3.63 0 6.63 3 6.63 6.69zm-6.63 4.75a4.75 4.75 0 1 0 0-9.5 4.75 4.75 0 0 0 0 9.5zm24.38-4.63c-.81 13.25-10.38 14.57-10.44 14.57l-.25-1.88c.25-.06 5.5-.81 7.81-7.31a6.96 6.96 0 0 1-3.75 1.12c-3.68 0-6.62-3-6.62-6.62 0-3.69 2.94-6.69 6.62-6.69s6.63 3 6.63 6.69v.12zm-6.63 4.63a4.75 4.75 0 1 0 0-9.5 4.75 4.75 0 0 0 0 9.5z',
            'quote-left' => 'M24.81 14.31A6.67 6.67 0 1 1 18.12 21c0-.06.07-.12.07-.19h-.07c.82-13.18 10.38-14.5 10.5-14.56l.2 1.88c-.26.06-5.45.8-7.76 7.37a6.52 6.52 0 0 1 3.75-1.19zm0 11.44c2.63 0 4.75-2.13 4.75-4.75s-2.12-4.81-4.75-4.81S20 18.37 20 21s2.19 4.75 4.81 4.75zM7 14.31c3.69 0 6.69 3 6.69 6.7A6.67 6.67 0 0 1 .38 21v-.2c.8-13.18 10.37-14.5 10.5-14.56l.18 1.88c-.25.06-5.43.8-7.75 7.37a6.33 6.33 0 0 1 3.7-1.19zm0 11.44c2.63 0 4.81-2.13 4.81-4.75S9.62 16.19 7 16.19 2.25 18.37 2.25 21 4.38 25.75 7 25.75z',
            'pulse' => 'M27 15.06h5v1.88h-6.25L23.62 12l-6.75 19.25L9.45 7 6.3 16.94H0v-1.88h4.94L9.44.56 17 25.26 23.44 6.8z',
            'printer' => 'M32 11.31v15.07h-5.63v5.8H5.63v-5.8H0V11.3h5.63V0h12.25l8.43 7.88v3.43h5.7zM18.81 3.44V7.5h4.38zM7.5 1.88v9.43h16.94V9.44h-7.5V1.88H7.5zm17 28.43v-9.44h-17v9.44h17zm5.63-5.81V13.19H1.88V24.5h3.75V19h20.75v5.5h3.75zm-9.44 0v-1.94H9.44v1.94h11.25zm-3.75 3.75v-1.88h-7.5v1.88h7.5zM5.62 16.94v-1.88H3.75v1.88h1.88zm3.82 0v-1.88H7.5v1.88h1.94z',
            'power-off' => 'M30.13 17.88c0-6.57-4.7-12.38-11.07-13.75l-.44 1.8a12.35 12.35 0 0 1 9.63 11.95c0 6.75-5.5 12.25-12.25 12.25S3.75 24.63 3.75 17.88a12.3 12.3 0 0 1 9.62-11.94l-.43-1.88A14.3 14.3 0 0 0 1.87 17.88a14.13 14.13 0 0 0 28.25 0zM16.93 0v18.81h-1.87V0h1.88z',
            'plug' => 'M5.63 7.5h20.75v9.44c0 5.19-4.7 9.44-10.38 9.44S5.62 22.13 5.62 16.94V7.5zm18.87 9.44v-7.5h-17v7.5c0 4.19 3.81 7.56 8.5 7.56s8.5-3.37 8.5-7.56zM13.19 5.62V0H11.3v5.63h1.88zm7.5 0V0H18.8v5.63h1.88zm-5.63 20.75V32h1.88v-5.63h-1.88zm5.63-11.3v-1.88H11.3v1.87h9.38zm0 3.74v-1.87H11.3v1.87h9.38z',
            'pie-chart' => 'M28.19 16.81a12.23 12.23 0 1 1-13.13-13l-.12-1.87A14.12 14.12 0 0 0 16 30.13c7.38 0 13.56-5.82 14.06-13.2zM32 14.13C32 6.37 25.69 0 17.94 0H17v15.06h15v-.93zm-1.94-.94H18.88V1.94c6 .44 10.8 5.31 11.18 11.25z',
            'paragraph' => 'M30.13 1.94V3.8h-7.5v26.32h-1.88V3.8h-3.81v26.32h-1.88V16.8H9.37a7.45 7.45 0 0 1 0-14.87h20.75zm-15.07 13V3.8H9.37a5.58 5.58 0 0 0 0 11.13h5.7z',
            'panel' => 'M0 0h32v32H0V0zm30.13 30.13V1.88H1.88v28.25h28.25zM7.5 19.24c-1.38-.38-2.38-1.69-2.38-3.19s1-2.81 2.38-3.19V7.5h1.94v5.37c1.37.38 2.37 1.7 2.37 3.2s-1 2.8-2.37 3.18v5.25H7.5v-5.25zm1-4.69c-.81 0-1.5.7-1.5 1.5s.69 1.44 1.5 1.44 1.44-.62 1.44-1.44-.63-1.5-1.44-1.5zm6.56.69c-1.37-.38-2.44-1.69-2.44-3.19s1.07-2.81 2.44-3.19V7.5h1.88v1.37c1.37.38 2.44 1.7 2.44 3.2s-1.07 2.8-2.44 3.18v9.25h-1.88v-9.25zm.94-4.69c-.81 0-1.5.7-1.5 1.5s.69 1.44 1.5 1.44 1.5-.62 1.5-1.44-.69-1.5-1.5-1.5zm7.5 14.69a3.35 3.35 0 0 1-.94-6.56V7.49h1.94v11.2a3.36 3.36 0 0 1-1 6.56zm0-4.81c-.81 0-1.44.62-1.44 1.44s.69 1.5 1.44 1.5c.81 0 1.5-.7 1.5-1.5s-.69-1.44-1.5-1.44z',
            'package' => 'M16.06-.06 32 6v20.13l-16 6-16-6V6zm12.31 6.68L16 1.95 11.19 3.8 23.5 8.44zM16 11.32l4.88-1.88L8.5 4.8 3.62 6.63zM1.87 8v16.81l13.2 4.94V12.94zm15.07 21.75 13.19-4.94V8l-13.2 4.94v16.81z',
            'music' => 'm27.81 8.38-10.87-5V22.8c0 .13.06.2.06.32 0 3-2.5 5.5-5.5 5.5a5.5 5.5 0 0 1 0-11c1.38 0 2.63.56 3.56 1.37V.44l13.5 6.25zM11.5 26.75c2 0 3.56-1.63 3.56-3.63S13.5 19.5 11.5 19.5a3.63 3.63 0 0 0 0 7.25z',
            'music-alt' => 'm11.31.5 20.7 4.06v22.07a5.5 5.5 0 0 1-11-.13c0-3 2.5-5.5 5.5-5.5a5.5 5.5 0 0 1 3.62 1.44v-8.81L13.19 10.3v11.9A5.46 5.46 0 0 1 2.25 22a5.46 5.46 0 0 1 9.06-4.13V.5zM7.7 25.56c1.94 0 3.5-1.5 3.62-3.37v-.38c-.12-1.93-1.69-3.44-3.62-3.44S4.12 20 4.12 22a3.6 3.6 0 0 0 3.57 3.56zm5.5-17.18 16.94 3.3V6.14L13.19 2.8v5.56zm13.3 21.73c2 0 3.63-1.62 3.63-3.62s-1.63-3.56-3.63-3.56-3.56 1.56-3.56 3.56 1.56 3.63 3.56 3.63z',
            'mouse' => 'M16 0a10.4 10.4 0 0 1 10.38 10.38v11.24C26.38 27.38 21.68 32 16 32S5.62 27.37 5.62 21.62V10.38A10.4 10.4 0 0 1 16 0zm8.5 21.63V10.38a8.5 8.5 0 0 0-17 0v11.24a8.5 8.5 0 0 0 17 0zM16 6.55a2.85 2.85 0 0 1 2.81 2.88v3.75c0 1.56-1.25 2.81-2.81 2.81s-2.81-1.25-2.81-2.81V9.44A2.85 2.85 0 0 1 16 6.56zm.94 6.63V9.44c0-.57-.44-.94-.94-.94s-.94.37-.94.94v3.75c0 .5.44.94.94.94s.94-.44.94-.94z',
            'mouse-alt' => 'M16 0a10.4 10.4 0 0 1 10.38 10.38v11.24C26.38 27.38 21.68 32 16 32S5.62 27.37 5.62 21.62V10.38A10.4 10.4 0 0 1 16 0zm8.5 10.38A8.41 8.41 0 0 0 16.94 2v9.31h7.56v-.93zM15.06 2c-4.25.44-7.56 4-7.56 8.38v.93h7.56V2zM16 30.13a8.5 8.5 0 0 0 8.5-8.5v-8.44h-17v8.44a8.5 8.5 0 0 0 8.5 8.5z',
            'money' => 'M20.19 18c1.5 1.25 2.37 3 2.37 4.88a6.33 6.33 0 0 1-5.62 6.18V32h-1.88v-2.94a6.33 6.33 0 0 1-5.62-6.18h1.87a4.47 4.47 0 0 0 3.75 4.3V16.45l-3.44-2.63h-.06v-.06a6.1 6.1 0 0 1-2.12-4.63 6.33 6.33 0 0 1 5.62-6.18V0h1.88v2.94c3.18.44 5.62 3 5.62 6.19l-.94.12-.93-.13a4.47 4.47 0 0 0-3.75-4.3v10.74l3.12 2.38c.06 0 .06.06.13.06zm-7.38-5.63 2.25 1.7V4.8a4.47 4.47 0 0 0-3.75 4.32c0 1.25.57 2.43 1.5 3.25zm4.13 14.82a4.47 4.47 0 0 0 3.75-4.31c0-1.32-.63-2.5-1.69-3.38l-2.06-1.56v9.25z',
            'microphone' => 'M16 22.56a8.46 8.46 0 0 1-8.5-8.44V8.5A8.41 8.41 0 0 1 15.06.12V0h1.88v.13A8.4 8.4 0 0 1 24.5 8.5v5.63a8.46 8.46 0 0 1-8.5 8.43zM11.31 3.88A6.47 6.47 0 0 0 9.44 8.5v.94h13.12V8.5c0-1.81-.68-3.44-1.87-4.63V7.5H18.8V2.56A4.7 4.7 0 0 0 16.94 2v5.5h-1.88V2c-.68.06-1.31.25-1.87.56V7.5H11.3V3.87zM9.44 11.3v2.82a6.56 6.56 0 1 0 13.12 0V11.3H9.44zm18.81 1.88h-1.88v6.12c0 2.82-3 5.2-6.62 5.2h-7.5c-3.63 0-6.63-2.38-6.63-5.2v-6.1H3.75v6.12c0 3.88 3.81 7.07 8.5 7.07h2.81V32h1.88v-5.62h2.81c4.69 0 8.5-3.2 8.5-7.07V13.2z',
            'menu' => 'M30.13 5.63H1.88v3.8h28.25v-3.8zM1.88 18.8v-3.75h28.25v3.75H1.88zm0 9.44V24.5h28.25v3.75H1.88z',
            'menu-alt' => 'M30.13 3.75H9.43V7.5h20.7V3.75zM9.43 16.94v-3.75h20.7v3.75H9.43zm0 9.43v-3.8h20.7v3.8H9.43zM3.76 3.75a1.9 1.9 0 0 1 1.88 1.88c0 1.06-.82 1.87-1.88 1.87-1 0-1.88-.81-1.88-1.88 0-1 .88-1.87 1.88-1.87zm0 9.44c1.06 0 1.88.81 1.88 1.87s-.82 1.88-1.88 1.88a1.88 1.88 0 1 1 0-3.75zm0 9.37a1.9 1.9 0 0 1 1.88 1.94c0 1-.82 1.88-1.88 1.88-1 0-1.88-.88-1.88-1.88 0-1.06.88-1.94 1.88-1.94z',
            'map' => 'M19.75 8.38 30.13 5.3v20.81l-10.25 3-9.82-2.75H0V5.63l10.56.07zm-8.44-.5v16.87l7.5 2.13V10.05zM1.87 7.5v17h7.57v-17H1.88zm26.38 17.19V7.8l-7.56 2.25v16.88z',
            'map-alt' => 'M28.25 7.5h1.88V28l-10.25 3-9.82-2.75H0V7.5h11.3v.06l1.94.44a6.55 6.55 0 0 1 13.06-.06l1.88-.38.06.13V7.5zm-8.5-3.75a4.74 4.74 0 0 0-4.69 4.75c0 3.38 3.25 7.88 4.69 9.75 1.5-1.88 4.75-6.38 4.75-9.75a4.75 4.75 0 0 0-4.75-4.75zM11.31 9.5v17.13l7.5 2.12v-8.63c-.93-1.18-4.68-5.93-5.5-10.18zm-9.44-.06v16.94h7.57V9.44H1.88zM20.7 28.8l7.56-2.25V9.5l-2.06.44c-.75 4.25-4.5 9-5.5 10.19v8.68zm1.6-20.17a2.53 2.53 0 0 1-2.56 2.56 2.57 2.57 0 0 1 0-5.13 2.53 2.53 0 0 1 2.56 2.57zm-3.25 0c0 .37.32.68.7.68s.68-.31.68-.68-.31-.7-.69-.7-.69.32-.69.7z',
            'loop' => 'M1.88 16.94c0-4.13 3.25-7.5 7.18-7.5H17l-3.06 3.06 1.31 1.31 5.38-5.3-5.38-5.38-1.31 1.3L17 7.5H9.06c-5 0-9.06 4.25-9.06 9.44s4.06 9.44 9.06 9.44V24.5c-3.94 0-7.18-3.44-7.18-7.56zM22.93 7.5c5 0 9.06 4.25 9.06 9.44s-4.06 9.44-9.06 9.44H15l3.06 3.06-1.31 1.37-5.38-5.37 5.38-5.38 1.31 1.32L15 24.5h7.94c3.94 0 7.19-3.44 7.19-7.56s-3.25-7.5-7.2-7.5V7.5z',
            'location-pin' => 'M16 .94c5.69 0 10.38 4.62 10.38 10.37 0 8.2-9.25 18.94-9.7 19.44l-.68.81-.69-.8c-.44-.5-9.69-11.26-9.69-19.45A10.4 10.4 0 0 1 16 .94zm0 27.69c2.19-2.7 8.5-11.07 8.5-17.32a8.5 8.5 0 0 0-17 0c0 6.25 6.31 14.63 8.5 17.31zm0-22.7c3.13 0 5.63 2.5 5.63 5.63S19.13 17.2 16 17.2s-5.63-2.5-5.63-5.63 2.5-5.62 5.63-5.62zm0 9.38c2.06 0 3.75-1.69 3.75-3.75S18.06 7.81 16 7.81s-3.75 1.7-3.75 3.75 1.69 3.75 3.75 3.75z',
            'list' => 'M32 7.5H9.44v1.94H32V7.5zm-26.38 1c0-1.56-1.25-2.88-2.8-2.88S0 6.95 0 8.5c0 1.5 1.25 2.81 2.81 2.81S5.62 10 5.62 8.5zm-1.87 0c0 .5-.44.94-.94.94S1.87 9 1.87 8.5c0-.56.44-1 .94-1s.94.44.94 1zm5.69 8.44v-1.88H32v1.88H9.44zM5.63 16c0-1.56-1.25-2.81-2.82-2.81S0 14.44 0 16s1.25 2.81 2.81 2.81S5.62 17.56 5.62 16zm-1.88 0c0 .5-.44.94-.94.94s-.94-.44-.94-.94.44-.94.94-.94.94.44.94.94zm5.69 8.5v-1.94H32v1.94H9.44zm-3.82-1c0-1.5-1.25-2.81-2.8-2.81a2.85 2.85 0 0 0 0 5.68 2.85 2.85 0 0 0 2.8-2.87zm-1.87 0c0 .56-.44 1-.94 1s-.94-.44-.94-1c0-.5.44-.94.94-.94s.94.44.94.94z',
            'light-bulb' => 'M16 0c5.69 0 10.38 4.94 10.38 11 0 4.56-1.94 7.06-3.44 9.13-1.25 1.68-2.25 2.93-2.25 4.93v4A2.87 2.87 0 0 1 17.87 32h-3.75a2.87 2.87 0 0 1-2.8-2.94v-3.94c0-2-1.07-3.43-2.26-5.06-1.62-2.19-3.44-4.62-3.44-9.06 0-6.06 4.7-11 10.38-11zm1.88 30.13c.5 0 .93-.5.93-1.07V26H13.2v3.06c0 .57.44 1.07.94 1.07h3.75zM21.38 19c1.56-2 3.12-4.13 3.12-8 0-5.06-3.81-9.13-8.5-9.13S7.5 5.95 7.5 11c0 3.81 1.56 5.94 3.06 7.94 1.13 1.5 2.25 3.06 2.57 5.19h5.75c.3-2.13 1.43-3.63 2.5-5.13z',
            'Italic' => 'M22.38 3.81h2.12V1.94h-5.69V3.8h1.5L9.62 28.25H7.5v1.88h5.69v-1.88h-1.5z',
            'info' => 'M20.3 26.9H17V11h-5.2v1.9h3.4v14h-3.4v1.9h8.6v-2zM15.1 7.6a3 3 0 0 1-3-2.9 3 3 0 0 1 3-2.9 2.9 2.9 0 0 1 0 5.8z',
            'infinite' => 'M32 15.06a7.58 7.58 0 0 0-7.5-7.56 7.6 7.6 0 0 0-5.69 2.56l-1.75 2.25 1.44 1.2 1.81-2.26a5.53 5.53 0 0 1 4.2-1.81c3.05 0 5.62 2.5 5.62 5.62a5.65 5.65 0 0 1-10 3.57l-6.94-8.57-.13-.12V10A7.58 7.58 0 0 0 7.5 7.5a7.53 7.53 0 0 0 0 15.06c2.31 0 4.44-1 5.88-2.75h.06l1.5-1.93-1.44-1.2-1.56 1.95v-.07a5.64 5.64 0 0 1-10.06-3.5 5.64 5.64 0 0 1 9.87-3.75l6.81 8.44c.06 0 .06.06.06.06l.07.07A7.55 7.55 0 0 0 32 15.06z',
            'id-badge' => 'M0 5.63h32v22.62H0V5.62zm30.13 20.75V7.5H1.88v18.88h28.25zM4.8 25.43c.07-1.94 2.38-3.63 5.44-4l.81-.07V18.2l-.43-.32c-.2-.12-.57-.62-.82-1.5v-.43l-.25-.07-.12-1.06c-.07-.31-.07-.56-.07-.81v-.38c0-.37 0-1 .07-1.06 0 0 .06-.06.25-.06.75-.07 1.06-.7 1.19-.94.12-.19.12-.25.68-.25.5 0 1.75 0 2.2.75l-.07.06c-.13.38-.38 1-.25 1.94v.5l-.19 1.19-.25.68a3.54 3.54 0 0 1-.75 1.44l-.37.25v3.25l.8.07c3.07.37 5.26 2.06 5.32 4l1.88-.07c-.07-2.69-2.57-4.94-6.13-5.62V19c.38-.44.69-1.07.94-1.57.31-.25.63-.62.81-1.12a2.1 2.1 0 0 0-.18-1.88v-.56c-.07-.5.06-.81.18-1.06.07-.31.25-.75.07-1.25-.5-1.44-2-2.19-4.13-2.13-1.31 0-1.81.57-2.19 1.2-1.81.3-1.75 2-1.75 3v.74c-.37.5-.43 1.25-.12 2 .19.44.44.75.75 1 .25.56.56 1.25 1.06 1.75v.56c-3.62.7-6.19 3-6.25 5.7zm23.44-10.38V13.2H18.8v1.87h9.44zm-1.88 3.75v-1.87H18.8v1.87h7.57z',
            'hummer' => 'M16.94 7.5v7.06h2.12V32h-6.12V14.56h2.12V7.5H7.5V0h13.25l6.75 7.5H16.94zm-7.5-5.63v3.75H23.3l-3.44-3.75H9.45zm7.75 28.25V16.45H14.8v13.69h2.38z',
            'home' => 'M26.38 30.13V13.18h1.87V32H3.75V13.19h1.88v16.93h5.68v-11.3h9.38v11.3h5.69zm-13.2 0h5.63v-9.44H13.2v9.43zm18.45-17.94L16 .69.37 12.19l1.13 1.5L16 3.06 30.5 13.7z',
            'help' => 'M19.4 28a3 3 0 0 0-3-3.1 3 3 0 0 0 0 6.1 3 3 0 0 0 3-3zM22 4.3a7 7 0 0 1 1.6 5.1c-.7 2.9-2.4 4.4-4 5.8-1.6 1.5-2.9 2.7-2.9 5.3h-1.9c0-3.5 1.9-5.1 3.6-6.7 1.4-1.3 2.8-2.5 3.4-4.8a5 5 0 0 0-1.2-3.5 5.1 5.1 0 0 0-4.1-2A5.5 5.5 0 0 0 10.3 9h-2c0-.1.3-7.2 8-7.2A6.9 6.9 0 0 1 22 4.4z',
            'headphone' => 'M30.06 15.25A2.76 2.76 0 0 1 32 17.88v7.56c0 1.5-1.25 2.81-2.81 2.81h-2.82v-1.87H24.5v-9.44h1.88v-1.88h1.8C27.76 7.7 22.5 1.87 16 1.87S4.25 7.7 3.81 15.07h1.81v1.87H7.5v9.44H5.62v1.87h-2.8A2.84 2.84 0 0 1 0 25.44v-7.56c0-1.25.81-2.25 1.94-2.63C2.25 6.75 8.44 0 16 0s13.75 6.75 14.06 15.25zM3.75 26.38v-9.44h-.94c-.5 0-.94.43-.94.93v7.57c0 .5.44.94.94.94h.94zm26.38-.94v-7.57c0-.5-.44-.93-.94-.93h-.94v9.44h.94c.5 0 .93-.44.93-.94z',
            'harddrives' => 'M25.44 23.5c1.5 0 2.81 1.31 2.81 2.88s-1.31 2.8-2.81 2.8c-1.57 0-2.88-1.24-2.88-2.8s1.32-2.88 2.88-2.88zm0 3.81c.5 0 .94-.43.94-.93a.92.92 0 0 0-.94-.94c-.57 0-.94.37-.94.93 0 .5.38.94.94.94zM32 5.94v12h-2l2 2.25V32H0V20.13l1.75-2.2H0V5.82L5.5 0h21zM6.31 1.87 2.75 5.63h26.44l-3.5-3.75H6.3zM1.87 30.13h28.25v-7.56H1.88v7.57zm28.07-9.43-2.38-2.75H4.2L1.95 20.7h28zM1.87 16.06h28.25V7.5H1.88v8.56zm23.57-6.62c1.5 0 2.81 1.25 2.81 2.81a2.84 2.84 0 0 1-5.69 0 2.85 2.85 0 0 1 2.88-2.81zm0 3.75c.5 0 .94-.44.94-.94a.92.92 0 0 0-.94-.94c-.57 0-.94.38-.94.94 0 .5.38.94.94.94z',
            'harddrive' => 'M26.63 5.63 32 14v12.38H0v-12.5l5.38-8.26h21.25zM6.43 7.5 2.7 13.19h26.56l-3.7-5.69H6.44zm-4.56 17h28.25v-9.44H1.88v9.44zm23.57-7.56c1.5 0 2.81 1.25 2.81 2.81s-1.31 2.88-2.81 2.88c-1.57 0-2.88-1.32-2.88-2.88s1.32-2.81 2.88-2.81zm0 3.75c.5 0 .94-.38.94-.94 0-.5-.44-.94-.94-.94a.92.92 0 0 0-.94.94c0 .56.38.94.94.94z',
            'gift' => 'M14.75 10.56C12.69 10.2 8.56 9.2 6.12 7.2a3.94 3.94 0 0 1-1.43-3c0-1.19.5-2.25 1.43-3a5.27 5.27 0 0 1 6.63 0 11.82 11.82 0 0 1 3.19 4.87c.69-1.68 1.69-3.62 3.25-4.93a5.35 5.35 0 0 1 6.56 0 3.97 3.97 0 0 1 1.44 3.06c0 1.12-.5 2.19-1.44 3-2.37 2-6.56 3-8.56 3.37v.38l-1.19-.2h-.06l-1.25.19zm5.63-8C18.55 4.2 17.55 7 17.05 8.7c1.94-.38 5.57-1.31 7.5-2.94a2.08 2.08 0 0 0 0-3.19 3.41 3.41 0 0 0-2.06-.69c-.81 0-1.56.25-2.13.7zm-13 0c-.5.44-.82 1-.82 1.63 0 .56.32 1.12.82 1.56 1.93 1.63 5.5 2.5 7.43 2.88-.44-1.63-1.44-4.5-3.31-6.07-.56-.43-1.25-.68-2.06-.68s-1.5.25-2.07.68zM32 11.31v7.5h-1.88v13.2H1.88V18.8H0v-7.5h32zM13.12 13.2l2.13 11.94 2.44-2.25 3.12 1.3-2-11h-5.68zm-11.24 0v3.75h10l-.63-3.75H1.87zm26.37 16.93v-11.3h-6.5l1.5 8.43-5.19-2.19L14 28.88 12.19 18.8H3.75v11.31h24.5zm1.88-13.18V13.2h-9.44l.68 3.75h8.75z',
            'game' => 'M16.94 7.5C23.63 7.69 32 9.94 32 12.19v13.25a2.8 2.8 0 0 1-2.81 2.81h-3.5l-3.57-7.37c-1.12.18-3.43.5-6.18.5s-4.94-.32-6-.5l-3.75 7.37H2.8A2.8 2.8 0 0 1 0 25.44V12.19c0-2.25 8.37-4.5 15.06-4.69V1.87h1.88V7.5zm13.18 17.94v-13c-.93-.82-6.37-2.88-13.18-3.07v.07h-1.88v-.07c-6.81.2-12.25 2.25-13.19 3.07v13c0 .5.44.94.94.94h2.25l3.88-7.7.68.2c.07 0 2.63.62 6.32.62 3.62 0 6.5-.62 6.5-.62l.75-.13 3.69 7.63h2.3c.5 0 .95-.44.95-.94zM9.45 13.19V11.3H7.5v1.88H5.62v1.94H7.5V17h1.94v-1.87h1.87v-1.94H9.44zM23.5 17a2.9 2.9 0 0 1-2.81-2.88c0-1.5 1.31-2.8 2.81-2.8a2.9 2.9 0 0 1 2.88 2.8A2.9 2.9 0 0 1 23.5 17zm0-3.81c-.5 0-.94.44-.94.94 0 .56.44 1 .94 1 .56 0 1-.44 1-1 0-.5-.44-.94-1-.94z',
            'filter' => 'M1 0h30L18.81 17.38V32H13.2V17.37zm15.94 16.75L27.38 1.87H4.63l10.43 14.88v13.38h1.88V16.74z',
            'files' => 'M23.5 0 32 7.9v18.5h-9.4v-1.9H30v-15h-7.5V1.8h-9.4v2h-1.9V0h12.2zm1 3.4v4.1h4.4zM0 5.6h12.3l8.4 7.9V32H0V5.6zm13.2 3.5v4h4.4zm-11.3 21h16.9v-15h-7.5V7.5H1.9v22.6z',
            'file' => 'm18.19 0 10.06 10v22H3.75V0H18.2zm.62 3.25v6.19h6.2zM5.63 30.13h20.75V11.3h-9.44V1.87H5.62v28.25z',
            'eraser' => 'M25.3 8a2.8 2.8 0 0 1 1 3.8L15.7 30H7.4l-6-3.4a2.8 2.8 0 0 1-1-3.8L11.7 3.3a2.8 2.8 0 0 1 3.8-1zM14.5 28.2l4-7-11.3-6.5-5.2 9a.9.9 0 0 0 .4 1.3l5.5 3.2h6.6zm10.2-17.5c.3-.4.1-1-.3-1.2l-9.8-5.7a.9.9 0 0 0-.5-.2 1 1 0 0 0-.8.5l-5.2 9 11.4 6.5zM32 28.2H18.8v2H32v-2z',
            'envelope' => 'M3.75 0h24.5v32H3.75V0zm5.06 7.5H23.2l2.62-5.63H6.2zM7.62 9.44l-2-4.25V28.5l1.88-2.12h7.56V9.44H7.62zm.75 18.81-1.62 1.88h18.5l-1.63-1.88H8.38zm16.13-1.88 1.88 2.13V5.12l-2 4.32h-7.44v16.94h7.56z',
            'download' => 'M32 30.1H0V32h32v-1.9zm-6.9-13.4L16 25.8l-9.1-9.1 1.3-1.4 6.9 6.9V0H17v22.2l6.8-6.9z',
            'direction' => 'm31.31 10.19-5.25 6.75h-9.12V32h-1.88V16.94H1.87V3.75h13.2V0h1.87v3.75h9.12zm-14.37 4.87h8.19l3.8-4.87-3.8-4.56H3.75v9.43h13.19z',
            'direction-alt' => 'M16.94 11.31v3.75h11.31v9.44H16.94V32h-1.88v-7.5H6.25l-3.69-4.87 3.69-4.57h8.81v-3.75H3.75V1.87h11.31V0h1.88v1.88h8.81l3.69 4.62-3.69 4.81h-8.81zM5.62 3.75v5.69h19.2l2.24-2.94-2.19-2.75H5.63zm20.75 18.81v-5.62H7.13l-2.18 2.75 2.25 2.87h19.18z',
            'dashboard' => 'M32 21.63c0-8.82-7.19-16-16-16s-16 7.18-16 16v.93h11.63V20.7h-9.7a13.65 13.65 0 0 1 3.44-8.32l1.5 1.5 1.32-1.3-1.44-1.5c2.25-2 5.13-3.26 8.31-3.5v5.62h1.88V7.56a14.4 14.4 0 0 1 8.37 3.5l-1.56 1.5 1.38 1.32 1.5-1.5c2 2.25 3.25 5.12 3.43 8.3h-9.68v1.88H32v-.93zm-12.25 0A3.76 3.76 0 0 0 16 17.88c-.19 0-.38.06-.56.06l-4-7-1.63.94 3.88 6.8A3.78 3.78 0 0 0 16 25.44a3.78 3.78 0 0 0 3.75-3.8zm-1.88 0c0 1.06-.8 1.87-1.87 1.87s-1.88-.81-1.88-1.88a1.88 1.88 0 0 1 3.75 0z',
            'control-stop' => 'M5.63 5.63h20.75v20.75H5.63V5.63zM24.5 24.5v-17h-17v17h17z',
            'control-shuffle' => 'm16.81 12.94 1.5 1.19 2-2.57a6.63 6.63 0 0 1 4.88-2.12h3.62L25.7 12.5l1.3 1.31 5.38-5.3L27 3.12l-1.31 1.3L28.8 7.5h-3.6a8.45 8.45 0 0 0-6.32 2.88v.06zM11 20.13l1.75-2.2 1.5 1.2-1.81 2.18c-1.63 2-4 3.2-6.57 3.2H0v-1.95h5.87c2 0 3.88-.87 5.13-2.44zm14.69-.63L27 18.12l5.38 5.38L27 28.88l-1.31-1.32 3.12-3.06H25.2a8.6 8.6 0 0 1-6.63-3.19l.07-.06-7.88-9.63a6.36 6.36 0 0 0-4.87-2.18H0V7.5h5.88a8.35 8.35 0 0 1 6.18 2.81l.07-.06 8 9.94a6.63 6.63 0 0 0 5.06 2.37h3.63z',
            'control-play' => 'm5.6 5 21.9 11L5.6 27V5zm1.9 3.1V24l15.8-8z',
            'control-pause' => 'M5.63 28.25V3.75h7.56v24.5H5.63zM7.5 5.62v20.75h3.81V5.63H7.5zm11.31-1.87h7.57v24.5H18.8V3.75zm5.69 22.63V5.63h-3.81v20.75h3.81z',
            'control-forward' => 'm5.63 4.56 13.75 11.38-13.75 11.5V4.56zm1.87 4v14.82l8.94-7.44zm21.25 7.38L16.62 5.88 15.38 7.3l10.44 8.63-10.43 8.75 1.25 1.44z',
            'control-backward' => 'M12.63 15.94 26.37 4.56v22.88zm11.87 7.44V8.55l-8.94 7.38zM6.19 15.93 16.63 7.3l-1.25-1.43L3.25 15.94l12.13 10.19 1.25-1.44z',
            'cloud' => 'M24 8.5a8.01 8.01 0 0 1 0 16H6.12A6.13 6.13 0 0 1 0 18.37a6.18 6.18 0 0 1 6.31-6.12 8.8 8.8 0 0 1 14.5-3.06c1-.5 2.13-.7 3.2-.7zm0 14.06a6.08 6.08 0 1 0 0-12.18c-1 0-2 .25-2.94.75l-.69.37-.5-.56a6.9 6.9 0 0 0-5.3-2.44 6.9 6.9 0 0 0-6.7 5l-.25.81-.81-.12c-.25-.07-.44-.07-.69-.07a4.25 4.25 0 0 0-4.25 4.25 4.24 4.24 0 0 0 4.25 4.2H24z',
            'cloud-up' => 'M32 12.69c0-4.38-3.56-8-8-8-1.06 0-2.13.25-3.19.69a8.95 8.95 0 0 0-6.25-2.57 8.8 8.8 0 0 0-8.25 5.7A6.05 6.05 0 0 0 0 14.55a6.13 6.13 0 0 0 6.12 6.13h6.94V18.8H6.12a4.25 4.25 0 0 1-4.25-4.25 4.24 4.24 0 0 1 4.94-4.12l.81.12.25-.8a6.92 6.92 0 0 1 12-2.57l.5.56.7-.37A6.3 6.3 0 0 1 24 6.56a6.13 6.13 0 0 1 0 12.25h-5.19v1.88h5.2c4.43 0 8-3.56 8-8zm-11.94 4-3.12-3.13v14.7h-1.88v-14.7l-3.12 3.13-1.31-1.38L16 9.94l5.38 5.37z',
            'cloud-down' => 'M32 12.69c0-4.38-3.56-8-8-8-1.06 0-2.13.25-3.19.69a8.95 8.95 0 0 0-6.25-2.57 8.8 8.8 0 0 0-8.25 5.7A6.05 6.05 0 0 0 0 14.55a6.13 6.13 0 0 0 6.12 6.13h6.94V18.8H6.12a4.25 4.25 0 0 1-4.25-4.25 4.24 4.24 0 0 1 4.94-4.12l.81.12.25-.8a6.92 6.92 0 0 1 12-2.57l.5.56.7-.37A6.3 6.3 0 0 1 24 6.56a6.13 6.13 0 0 1 0 12.25h-5.19v1.88h5.2c4.43 0 8-3.56 8-8zM16.94 25.88l3.12-3.13 1.32 1.31L16 29.44l-5.37-5.38 1.3-1.31 3.13 3.13V11.3h1.88v14.56z',
            'clipboard' => 'M30.13 3.75H25.8v1.88h2.44v24.5H3.75V5.63h2.38V3.75H1.88V32h28.25V3.75zM24.5 9.44V1.88h-5.81C18.25.8 17.25 0 15.99 0s-2.24.81-2.68 1.88H7.5v7.56h17zm-1.94-5.69V7.5H9.44V3.75h5.62v-.94c0-.5.44-.94.94-.94s.94.44.94.94v.94h5.62z',
            'car' => 'M32 18.81v9.38h-3.75v.06a3.78 3.78 0 0 1-7.56 0v-.06H11.3v.06a3.77 3.77 0 0 1-7.56 0v-.06H0V18.8h3.87l5.63-7.5h14.94l3.87 7.5H32zm-5.81 0L23.3 13.2h-4.43v5.62h7.3zM10.44 13.2l-4.19 5.6H17v-5.6h-6.56zM7.5 30.13c1.06 0 1.94-.88 1.94-1.88a1.9 1.9 0 0 0-1.94-1.88c-1 0-1.87.82-1.87 1.88 0 1 .87 1.88 1.87 1.88zm17 0c1 0 1.88-.88 1.88-1.88a1.9 1.9 0 0 0-1.88-1.88 1.9 1.9 0 0 0-1.94 1.88c0 1 .88 1.88 1.94 1.88zm5.63-3.82V20.7H1.88v5.62H4.3a3.75 3.75 0 0 1 6.44 0h10.5a3.75 3.75 0 0 1 6.44 0h2.44z',
            'calendar' => 'M26.38 3.75H32V32H0V3.75h5.63V1.87h5.68v1.88h9.38V1.87h5.69v1.88zm-3.82 0V7.5h1.94V3.75h-1.94zm-15.06 0V7.5h1.94V3.75H7.5zm22.63 26.38V13.3H1.88v16.81h28.25zM1.88 11.43h28.25v-5.8h-3.75v3.8h-5.7v-3.8h-9.37v3.8H5.62v-3.8H1.87v5.8z',
            'book' => 'm31.25 2.19.75.12v26.13l-1.13-.19s-2.3-.44-5.25-.44c-2.12 0-4.87.25-7.25 1.19v1.56h-4.75V29a21.3 21.3 0 0 0-7.43-1.31c-2.88 0-5 .56-5 .56l-1.2.31V2.38l.7-.2c.12 0 2.31-.62 5.5-.62 3.62 0 6.93.75 9.81 2.19 2.44-1.38 5.69-2.06 9.63-2.06 3.12 0 5.5.43 5.62.5zm-29.38 24c1-.19 2.5-.38 4.32-.38 3.25 0 6.25.63 8.87 1.82V5.43A19.31 19.31 0 0 0 6.2 3.5c-1.88 0-3.44.19-4.32.38v22.3zm28.25.06V3.87a35.3 35.3 0 0 0-4.5-.3c-2.5 0-6 .37-8.68 1.8v22.2c2.31-1.07 5.18-1.63 8.68-1.63 1.88 0 3.5.19 4.5.31z',
            'bell' => 'm28.81 26.56 1.7 1.63H1.55l1.63-1.57c0-.06 2.44-2.56 2.44-6.06v-6.19C5.63 8.5 10.3 3.75 16 3.75S26.38 8.5 26.38 14.37v6.2c0 3.56 2.43 6 2.43 6zm-23.06-.25h20.5a10.29 10.29 0 0 1-1.75-5.75v-6.18c0-4.82-3.81-8.76-8.5-8.76s-8.5 3.94-8.5 8.75v6.2a11 11 0 0 1-1.75 5.74zM16.94 3.75V1.87h-1.88v1.88h1.88zm0 24.5c0 .5-.44.94-.94.94s-.94-.44-.94-.94H13.2c0 1.56 1.25 2.81 2.81 2.81s2.81-1.25 2.81-2.81h-1.87z',
            'basketball' => 'M16 0a16 16 0 1 1 .02 31.98A16 16 0 0 1 16 0zm8.44 15.06h5.69a14.04 14.04 0 0 0-2.88-7.56 14.36 14.36 0 0 0-2.81 7.56zm5.69 1.88h-5.7a14.36 14.36 0 0 0 2.82 7.56 14.03 14.03 0 0 0 2.88-7.56zM26 6.06a13.93 13.93 0 0 0-9.06-4.12v13.12h5.62a15.7 15.7 0 0 1 3.44-9zM15.06 1.94c-3.5.25-6.68 1.75-9 4.12 2 2.57 3.25 5.7 3.44 9h5.56V1.94zM1.94 15.06h5.69A14.36 14.36 0 0 0 4.8 7.5a14.03 14.03 0 0 0-2.87 7.56zm5.69 1.88h-5.7a14.04 14.04 0 0 0 2.88 7.56 14.36 14.36 0 0 0 2.82-7.56zm-1.57 9a13.92 13.92 0 0 0 9 4.12V16.94H9.5a15.7 15.7 0 0 1-3.44 9zm10.88 4.12A13.93 13.93 0 0 0 26 25.94a15.7 15.7 0 0 1-3.44-9h-5.62v13.12z',
            'bar-chart' => 'M32 30.13H0V32h32v-1.88zM3.75 18.8v9.44H1.87v-11.3h7.57v11.31H7.5v-9.44H3.75zm9.44-5.62v15.06H11.3V11.31h7.5v16.94h-1.87V13.2h-3.75zm9.37-7.57v22.63H20.7V3.75h7.56v24.5h-1.87V5.62h-3.82z',
            'bar-chart-alt' => 'M32 30.13H0V32h32v-1.88zM22.56 18.8v9.44H20.7v-11.3h7.56v11.31h-1.87v-9.44h-3.82zm-9.36-5.6v15.06h-1.9V11.31h7.5v16.94h-1.87V13.2h-3.75zM3.75 5.63v22.62H1.87V3.75h7.57v24.5H7.5V5.62H3.75z',
            'back-right' => 'M27.4 28.3H14.1a8.5 8.5 0 0 1-8.5-8.6 8.5 8.5 0 0 1 8.5-8.4h5.5l-5 5 1.3 1.3 7.3-7.2L15.9 3l-1.3 1.3 5 5h-5.5A10.4 10.4 0 0 0 3.7 19.7a10.4 10.4 0 0 0 10.4 10.4h13.3v-1.8z',
            'back-left' => 'M28.3 14.1c0-5.7-4.7-10.3-10.4-10.3H4.6v1.8h13.3a8.5 8.5 0 1 1 0 17h-5.5l5-5-1.3-1.4-7.3 7.3 7.3 7.3 1.3-1.4-5-4.9h5.5c5.7 0 10.3-4.7 10.3-10.4z',
            'arrows-corner' => 'M28.25 17.88h-1.88V25L7 5.62h7.13V3.75H3.74v10.38h1.88v-7.2l19.43 19.45h-7.18v1.87h10.37V17.87z',
            'archive' => 'M32 3.75v7.56h-1.88v20.7H1.88V11.3H0V3.75h32zm-3.75 26.38V11.3H3.75v18.81h24.5zm1.88-20.7v-3.8H1.88v3.8h28.25zM11.3 20.7c-2.1-.01-3.8-1.7-3.8-3.76s1.69-3.75 3.81-3.75h9.44c2.06 0 3.75 1.69 3.75 3.75s-1.69 3.75-3.75 3.75h-9.44zm0-5.63c-1.06 0-1.87.82-1.87 1.88s.81 1.87 1.87 1.87h9.44c1 0 1.88-.81 1.88-1.87s-.88-1.88-1.88-1.88H11.3z',
            'anchor' => 'm28.81 23.69-1.68.87-1.25-2.44c-1.32 4.2-5.25 7.32-9.88 7.32s-8.56-3.13-9.88-7.32l-1.25 2.44-1.68-.87 2.94-5.88 5.93 2.94-.87 1.69-3.5-1.75a8.5 8.5 0 0 0 7.37 6.75V13.19h-2.81V11.3h2.81v-2A4.7 4.7 0 0 1 16 .01a4.7 4.7 0 0 1 .94 9.31v2h2.81v1.87h-2.81v14.25a8.5 8.5 0 0 0 7.37-6.75l-3.5 1.75-.87-1.69 5.87-2.94zm-15.62-19c0 1.56 1.25 2.81 2.81 2.81s2.81-1.25 2.81-2.81a2.8 2.8 0 1 0-5.62 0z',
            'align-right' => 'M32 3.75H0v1.88h32V3.75zM5.62 13.19V11.3H32v1.88H5.62zM0 20.69V18.8h32v1.88H0zm13.19 7.56v-1.88H32v1.88H13.2z',
            'align-left' => 'M32 3.75H0v1.88h32V3.75zm-5.63 7.56v1.88H0V11.3h26.38zM0 20.7v-1.9h32v1.88H0zm0 7.56v-1.88h18.81v1.88H0z',
            'align-justify' => 'M32 3.75H0v1.88h32V3.75zM0 13.19V11.3h32v1.88H0zm0 7.5V18.8h32v1.88H0zm0 7.56v-1.87h32v1.87H0z',
            'align-center' => 'M32 3.75H0v1.88h32V3.75zM2.81 11.31H29.2v1.88H2.8V11.3zM0 20.7v-1.9h32v1.88H0zm6.56 7.56v-1.88h18.88v1.88H6.56z',
            'alert' => 'm15.94 2.81 15.69 27.32H.38zm0 3.81L3.63 28.25h24.75zm1 13.94V13.2h-1.88v7.37h1.88zm.94 3.94a1.88 1.88 0 0 0-3.75 0c0 1.06.8 1.94 1.87 1.94s1.88-.88 1.88-1.94z',
            'alarm-clock' => 'M27.69 12.81a12.94 12.94 0 0 1-1.57 14.44l2.38 3.25-1.5 1.13-2.25-3C22.44 30.69 19.37 32 16 32s-6.44-1.31-8.75-3.37l-2.25 3-1.5-1.13 2.38-3.25a12.93 12.93 0 0 1-1.56-14.44c-.95-1-1.5-2.25-1.5-3.62a5.13 5.13 0 0 1 9.31-2.94c.93-.31 1.93-.5 2.93-.56V3.75H13.2V1.87h5.62v1.88h-1.87v1.94c1 .06 2 .25 2.94.56a5.13 5.13 0 0 1 9.3 2.94c0 1.37-.55 2.62-1.5 3.62zm-3.63-6.87c-.93 0-1.75.37-2.37 1.06 2 .94 3.69 2.38 5 4.13.37-.57.62-1.25.62-1.94a3.3 3.3 0 0 0-3.25-3.25zM4.7 9.19c0 .69.25 1.37.62 1.94 1.32-1.75 3-3.2 5-4.2a3.3 3.3 0 0 0-2.37-1A3.3 3.3 0 0 0 4.69 9.2zM16 30.12A11.31 11.31 0 1 0 16 7.5a11.31 11.31 0 0 0 0 22.63zm.94-11.3v-5.63h-1.88v7.5h9.44V18.8h-7.56z',
            'agenda' => 'M26.38 3.75h3.75v24.5h-3.75V32H1.88V0h24.5v3.75zM3.75 30.13H7.5V1.88H3.75v28.25zm20.75 0V1.88H9.44v28.25H24.5zm3.75-3.75v-5.7h-1.88v5.7h1.88zm0-7.57V13.2h-1.88v5.62h1.88zm-1.88-7.5h1.88V5.62h-1.88v5.7zM11.31 7.5v1.94h9.38V7.5H11.3zm0 3.81v1.88h7.5V11.3h-7.5z',
            'write' => 'M21.94 0 32 10v22H8.5v-1.88h21.63v-18.8h-9.44V1.86H7.56v1.88h.88a2.8 2.8 0 0 1 2.81 2.81V22.7l-4.62 9.37-4.75-9.31V6.56a2.8 2.8 0 0 1 2.8-2.81h1V0h16.26zM7.37 26.38l2-4.13v-11H7.5v11.38H5.62V11.24H3.75v11l2.06 4.13h1.57zm2-19.82c0-.5-.43-.94-.93-.94H4.69c-.5 0-.94.44-.94.94v2.82h5.62V6.56zm13.2-3.31v6.19h6.18z',
            'window' => 'M0 1.88h32v28.25H0V1.88zm30.13 1.87H1.88v5.69h28.25V3.75zM1.88 28.25h28.25V11.31H1.88v16.94zM13.18 7.5V5.62h-1.87V7.5h1.88zm-3.74 0V5.62H7.5V7.5h1.94zm-3.81 0V5.62H3.75V7.5h1.88z',
            'widgetized' => 'M3.75 0v1.88h1.88V0H3.75zM7.5 1.88V0h1.94v1.88H7.5zm3.81 0V0h1.88v1.88H11.3zm3.75 0V0h1.88v1.88h-1.88zm3.75 0V0h1.88v1.88H18.8zm3.75 0V0h1.94v1.88h-1.94zm3.82 0V0h1.87v1.88h-1.87zM3.75 16.94v-1.88h1.88v1.88H3.75zm3.75 0v-1.88h1.94v1.88H7.5zm3.81 0v-1.88h1.88v1.88H11.3zm7.5 0v-1.88h1.88v1.88H18.8zm3.75 0v-1.88h1.94v1.88h-1.94zm3.82 0v-1.88h1.87v1.88h-1.87zM3.75 32v-1.88h1.88V32H3.75zm3.75 0v-1.88h1.94V32H7.5zm3.81 0v-1.88h1.88V32H11.3zm3.75 0v-1.88h1.88V32h-1.88zm3.75 0v-1.88h1.88V32H18.8zm3.75 0v-1.88h1.94V32h-1.94zm3.82 0v-1.88h1.87V32h-1.87zm3.75-32H32v1.88h-1.88V0zm0 5.63V3.75H32v1.88h-1.88zm0 3.8V7.5H32v1.94h-1.88zm0 3.76V11.3H32v1.88h-1.88zm0 3.75v-1.88H32v1.88h-1.88zm0 3.75V18.8H32v1.88h-1.88zm0 3.81v-1.94H32v1.94h-1.88zm0 3.75v-1.87H32v1.87h-1.88zM15.06 5.62V3.75h1.88v1.88h-1.88zm0 3.82V7.5h1.88v1.94h-1.88zm0 3.75V11.3h1.88v1.88h-1.88zm0 3.75v-1.88h1.88v1.88h-1.88zm0 3.75V18.8h1.88v1.88h-1.88zm0 3.81v-1.94h1.88v1.94h-1.88zm0 3.75v-1.87h1.88v1.87h-1.88zM30.12 32v-1.88H32V32h-1.88zM0 1.87V0h1.88v1.88H0zm0 3.75V3.75h1.88v1.88H0zm0 3.82V7.5h1.88v1.94H0zm0 3.75V11.3h1.88v1.88H0zm0 3.75v-1.88h1.88v1.88H0zm0 3.75V18.8h1.88v1.88H0zm0 3.81v-1.94h1.88v1.94H0zm0 3.75v-1.88h1.88v1.88H0zM0 32v-1.88h1.88V32H0z',
            'widget' => 'M3.75 0v1.88h1.88V0H3.75zm5.69 0v1.88H7.5V0h1.94zm3.75 0v1.88H11.3V0h1.88zm3.75 0v1.88h-1.88V0h1.88zm3.75 0v1.88H18.8V0h1.88zm3.81 0v1.88h-1.94V0h1.94zm1.88 1.88V0h1.87v1.88h-1.88zM3.75 32v-1.88h1.88V32H3.75zm3.75 0v-1.88h1.94V32H7.5zm3.81 0v-1.88h1.88V32H11.3zm3.75 0v-1.88h1.88V32h-1.88zm3.75 0v-1.88h1.88V32H18.8zm3.75 0v-1.88h1.94V32h-1.94zm3.82 0v-1.88h1.87V32h-1.87zm3.75-32H32v1.88h-1.88V0zm0 5.63V3.75H32v1.88h-1.88zm0 3.8V7.5H32v1.94h-1.88zm0 3.76V11.3H32v1.88h-1.88zm0 3.75v-1.88H32v1.88h-1.88zm0 3.75V18.8H32v1.88h-1.88zm0 3.81v-1.94H32v1.94h-1.88zm0 3.75v-1.87H32v1.87h-1.88zm0 3.75v-1.88H32V32h-1.88zM0 1.87V0h1.88v1.88H0zm0 3.75V3.75h1.88v1.88H0zm0 3.82V7.5h1.88v1.94H0zm0 3.75V11.3h1.88v1.88H0zm0 3.75v-1.88h1.88v1.88H0zm0 3.75V18.8h1.88v1.88H0zm0 3.81v-1.94h1.88v1.94H0zm0 3.75v-1.88h1.88v1.88H0zM0 32v-1.88h1.88V32H0zm25.38-17.06-.13-.63-2.69-.81c-.06-.13-.06-.25-.12-.38l1.31-2.5-.38-.5a8.52 8.52 0 0 0-1.5-1.5l-.5-.37-2.5 1.31c-.12-.06-.25-.06-.37-.12l-.81-2.69-.63-.13a12.5 12.5 0 0 0-2.12 0l-.63.13-.81 2.69c-.13.06-.25.06-.38.12l-2.5-1.31-.5.37c-.56.44-1.06 1-1.5 1.57l-.37.44 1.31 2.5c-.06.12-.06.25-.12.37l-2.7.81-.12.63c0 .31-.06.69-.06 1.06s.06.75.06 1.06l.13.63 2.69.81c.06.13.06.25.12.38l-1.31 2.5.37.44c.44.62.94 1.12 1.5 1.56l.5.37 2.5-1.3c.13.05.25.05.38.12l.81 2.68.63.13c.31 0 .69.06 1.06.06s.75-.06 1.06-.06l.63-.13.81-2.68c.13-.07.25-.07.38-.13l2.5 1.31.43-.37a7.5 7.5 0 0 0 1.57-1.56l.37-.44-1.31-2.5c.06-.13.06-.25.12-.38l2.7-.81.12-.63c0-.3.06-.68.06-1.06s-.06-.75-.06-1.06zM23.5 16v.25l-2.44.75-.12.5c-.13.31-.25.63-.44.94l-.19.44 1.19 2.25-.38.37-2.25-1.19-.43.25-.94.38-.5.12-.75 2.44a.68.68 0 0 1-.5 0L15 21.06l-.5-.12a6.27 6.27 0 0 1-.94-.44l-.44-.19-2.25 1.19-.37-.38 1.19-2.25-.2-.43a6.27 6.27 0 0 1-.43-.94l-.13-.5-2.43-.75v-.5l2.43-.75.13-.5c.12-.31.25-.63.44-.94l.19-.44-1.2-2.25.38-.37 2.25 1.19.44-.2c.31-.18.63-.3.94-.43l.5-.13.75-2.43a.68.68 0 0 1 .5 0l.75 2.44.5.12c.31.13.62.25.94.44l.43.19 2.25-1.2.38.38-1.19 2.25.19.44c.19.31.31.63.44.94l.12.5 2.44.75V16z',
            'widget-alt' => 'M3.75 0v1.88h1.88V0H3.75zm5.69 0v1.88H7.5V0h1.94zm3.75 0v1.88H11.3V0h1.88zm3.75 0v1.88h-1.88V0h1.88zm3.75 0v1.88H18.8V0h1.88zm3.81 0v1.88h-1.94V0h1.94zm1.88 1.88V0h1.87v1.88h-1.88zM3.75 32v-1.88h1.88V32H3.75zm3.75 0v-1.88h1.94V32H7.5zm3.81 0v-1.88h1.88V32H11.3zm3.75 0v-1.88h1.88V32h-1.88zm3.75 0v-1.88h1.88V32H18.8zm3.75 0v-1.88h1.94V32h-1.94zm3.82 0v-1.88h1.87V32h-1.87zm3.75-32H32v1.88h-1.88V0zm0 5.63V3.75H32v1.88h-1.88zm0 3.8V7.5H32v1.94h-1.88zm0 3.76V11.3H32v1.88h-1.88zm0 3.75v-1.88H32v1.88h-1.88zm0 3.75V18.8H32v1.88h-1.88zm0 3.81v-1.94H32v1.94h-1.88zm0 3.75v-1.87H32v1.87h-1.88zm0 3.75v-1.88H32V32h-1.88zM0 1.87V0h1.88v1.88H0zm0 3.75V3.75h1.88v1.88H0zm0 3.82V7.5h1.88v1.94H0zm0 3.75V11.3h1.88v1.88H0zm0 3.75v-1.88h1.88v1.88H0zm0 3.75V18.8h1.88v1.88H0zm0 3.81v-1.94h1.88v1.94H0zm0 3.75v-1.88h1.88v1.88H0zM0 32v-1.88h1.88V32H0zm16-13.13 7.81-7.75 1.32 1.32L16 21.56l-9.12-9.12 1.3-1.31z',
            'wallet' => 'M2.94 3.75H32V27h-3.69v3.13H2.94A2.88 2.88 0 0 1 0 27.25V6.69a2.93 2.93 0 0 1 2.94-2.94zm0 24.5h23.5v-5.63h-5.38a2.87 2.87 0 0 1-2.94-2.8v-1.88a2.92 2.92 0 0 1 2.94-2.88h5.38V9.37H2.87c-.3 0-.56-.06-.87-.12 0 0-.06 0-.13-.06v18.06c0 .56.5 1 1.07 1zm18.12-7.5h9.07v-3.81h-9.07c-.62 0-1.06.43-1.06 1v1.87c0 .5.44.94 1.06.94zm9.06 4.38v-2.5h-1.8v2.5h1.8zm-1.8-10.07h1.8V5.62H2.95c-.57 0-1 .5-1 1.07s.5.81 1 .81H28.3v7.56z',
            'video-clapper' => 'M0 1.88h32v28.25H0V1.88zM30.13 7.5V3.75h-4.94l4.43 3.75h.5zm-13.7 5.69h5.5l4.45-3.75h-5.5zM12.82 7.5h5.5l-4.43-3.75h-5.5zM18 9.44h-5.5l-4.44 3.75h5.5zm3.19-1.94h5.5l-4.44-3.75h-5.5zM1.87 3.75V7.5h8L5.45 3.75H1.87zm0 5.69v3.75h3.25l4.44-3.75H1.87zm28.25 18.81V15.06H1.88v13.19h28.25zm0-15.06V9.44h-.8l-4.45 3.75h5.25z',
            'video-camera' => 'M24.44 12.69 32 7.44v19l-7.56-5.25v4.25c0 1.5-1.25 2.81-2.82 2.81h-15a2.84 2.84 0 0 1-2.8-2.81V15.06h-.95A2.82 2.82 0 0 1 0 12.25V8.5a2.87 2.87 0 0 1 2.87-2.88h2.75V4.7A2.85 2.85 0 0 1 8.5 1.87h10.37v1.88H8.5c-.56 0-1 .44-1 .94v.93h14.12a2.85 2.85 0 0 1 2.82 2.88v4.19zm5.68 10.12V11.06l-7.56 5.25V8.5c0-.56-.44-1-.94-1H2.87c-.56 0-1 .44-1 1v3.75c0 .5.44.94 1 .94H5.7v12.25c0 .5.43.94.93.94h15c.5 0 .94-.44.94-.94v-7.88z',
            'vector' => 'M28.13 11.31H32v5.63h-5.63v-4.5a10.47 10.47 0 0 0-10.62.75c.13.25.19.56.19.94a2.8 2.8 0 0 1-2.81 2.8c-.26 0-.44 0-.63-.05a9.74 9.74 0 0 0-1.19 4.75c0 1.5.44 3.18 1.25 4.75h4.38V32H11.3v-4a11.83 11.83 0 0 1-1.13-10.56L5.3 22.25a2.85 2.85 0 0 1-2.5 4.13 2.84 2.84 0 0 1 0-5.69c.44 0 .81.12 1.19.25l6.37-6.38c-.06-.12-.06-.31-.06-.43a2.8 2.8 0 0 1 2.81-2.82h.5L20.94 4a3.56 3.56 0 0 1-.25-1.19 2.84 2.84 0 0 1 5.69 0 2.85 2.85 0 0 1-4.13 2.5l-4.81 4.88c1.31-.5 2.75-.75 4.19-.75 2.3 0 4.56.62 6.5 1.87zM23.5 1.87c-.5 0-.94.44-.94.94s.44.94.94.94c.56 0 1-.44 1-.94s-.44-.94-1-.94zM2.81 24.5c.5 0 .94-.44.94-1 0-.5-.44-.94-.94-.94s-.94.44-.94.94c0 .56.44 1 .94 1zm10.38 3.75v1.88h1.87v-1.88H13.2zm-.07-13.19c.5 0 .94-.43.94-.93s-.44-.94-.94-.94-.93.43-.93.93.43.94.93.94zm17 0V13.2h-1.87v1.87h1.88z',
            'themify-logo' => 'M4.94 12.81a8 8 0 0 1 1.25.13c.12-.19.19-.44.19-.63 0-.56-.5-1-1.2-1s-1.43.2-2.06.32c-.56.06-1.5.25-1.93.25-.2 0-.88 0-.94-.44-.13.19-.31.56-.25.87.12.88 1.19.82 1.5.82h.44s.31-.07.43-.07h.13v.13c-.25.69-1.94 4.69-1.94 5.12 0 .7.69.7 1.19.75.25-.62 1.81-4.75 2.56-6.18h.07c.18-.07.37-.07.56-.07zm7.31 5.25a7.9 7.9 0 0 0 2.06-1C13.5 18.31 12.5 19 11.37 19c-.43 0-1.3-.12-1.37-1.19-.31.44-1 1.38-1.69 1.32-.75 0-.87-.5-.87-1 0-.94 1-3.07 1-3.07-.88 0-2.13 2.13-2.7 4.13-.55 0-1.12-.56-1.12-1.13s.7-2 1.32-3.37c.31-.75 1.12-2.06 1.37-3.69.19-.06.56-.19.69-.19.5 0 .69.25.69.69 0 .31-1.25 2.88-1.32 3.25 0 0 1.25-.81 1.94-.81.5 0 .82.25.82.69 0 .37-.32.87-.63 1.37s-.56 1.06-.69 1.44c-.06.25-.06.37 0 .37.07.07.7.07 1.25-.5.32-1.5 1.88-3.62 3.25-3.62.75 0 1.2.5 1.25 1.12.25 1.88-2.44 3.25-2.94 2.38-.12-.25 1.38.06 1.7-1.63.06-.31-.2-.37-.32-.37-.5 0-1.63 1.12-1.63 2.12 0 .82.5.82.88.75zm7.94-.62c-.13.37.06.37.25.37s.44 0 .69-.18c-.2.75-.75 1.5-1.57 1.5-.56 0-.81-.25-.81-.82 0-.94.69-2.19.81-2.44l.13-.18h-.19c-.56 0-1.94 2.06-2.19 3.25h-.25c-.37 0-.75-.2-.75-.63 0-.5.25-1 .5-1.5.19-.31.32-.62.44-.94l.06-.12h-.12c-.75 0-1.75 1.94-2.19 3.25h-.06c-.5 0-.88-.31-.88-.81 0-.2.31-.88.63-1.57a19.1 19.1 0 0 0 1-2.81c.18-.06.31-.06.43-.06.25 0 .7.06.7.56 0 .19-.13.94-.13.94.69-.82 1.44-1.32 1.87-1.32.38 0 .57.32.57.94v.25l.12-.19c.56-.62 1.19-1.06 1.63-1.06.37 0 .5.19.5.5 0 .5-.44 1.44-.82 2.06-.25.5-.37.82-.37 1zm3.37.56c-.25.81-.56 1.13-1.25 1.13-.62 0-1.06-.63-1.06-1.2 0-.5.44-1.37.88-2.3.25-.57.5-1.13.68-1.63h.13c.37 0 .94.31 1 .75 0 .31-.38.69-.69 1.31a4.35 4.35 0 0 0-.63 1.69c0 .31.57.63.94.25zm.25-4.62c-.5 0-.75-.2-.75-.44 0-.32-.06-.57.32-.94 1.06.06 1.43.19 1.43.44 0 .19-.12.5-.43.87-.2.07-.44.07-.57.07zm7.07.18c.5 0 1.06.2 1.12.63 0 .12-.06.37-.25.75l-.19.44c-.06.25-.37.93-.44 1.25-.62 1.93-1.43 3.93-3.25 4.12l-.06.06c-.5 0-.94-.12-1.19-.43-.68-.63-.5-1.25-.5-1.25s.38.62 1.38.56c.75 0 1.44-.88 1.87-2.13l-.06-.06c-.37.5-1.62 1.44-2.12.88-.2-.13-.2-.32-.25-.63 0-.5.3-1.56.5-2.19.12-.31.25-.68.3-.93 0-.07-.05-.13-.12-.2h-.06c-.12 0-.31 0-.5.13-.25.13-.44.32-.5.44 0 0-2.5 5.56-2.62 6.5-.38-.06-1.2-.56-1.13-1.12 0-.38.88-2.32 1.44-3.5.31-.7.81-1.94.81-1.94-.12-.2-.37-.32-.31-.57 0-.12.06-.37.31-.5h.06c.2-.06.44-.12.57-.18v-.07c.5-1.12 1.5-3.18 2.87-3.06.75 0 1.25.38 1.32 1 .06.25 0 .31-.13.56-.13-.62-.81-.56-1.25-.25-.25.13-.94.94-1.19 1.82h.75s.5 0 .75.06c.07 0 .13.06.19.06.13.07.13.13.19.19 0 .06 0 .13.06.19 0 .31-.25.87-.44 1.37-.18.44-.43.94-.37 1.13.37.87 2.25-2.19 2.37-3.06v-.07h.07z',
            'themify-favicon' => 'M17.7 2.4c11.1 0 15.4 11.3 14 18.3-.8 4.6-9.9 5.8-18 6.6-6.8.7-12 2.3-12 2.3s6.2-4.7 2.1-6.8C1.4 21.6-6.6 9.1 11.5 3.5a19.5 19.5 0 0 1 6.2-1zm12.2 18a15.7 15.7 0 0 0-3.2-12 11.1 11.1 0 0 0-9-4c-1.8 0-3.6.2-5.6.9-4.3 1.3-9.6 3.9-10.2 8.6A9 9 0 0 0 4.7 21a4 4 0 0 1 2.4 3.3 4 4 0 0 1-.4 2 75 75 0 0 1 6.8-1c5.1-.5 15.8-1.6 16.4-5zM7.5 12.3a2 2 0 0 0 2 1.8 2 2 0 0 0 1.8-1.9c0-1-.9-1.8-1.9-1.8a1.9 1.9 0 0 0-1.9 1.9zm9.4-1a2 2 0 0 0 2 1.9c1 0 1.8-.9 1.8-1.9 0-1-.8-1.9-1.9-1.9-1 0-1.9.9-1.9 2zm8.2 4.7S13 23.2 6.9 17.8c0 0 7.7 9.8 18.2-1.8z',
            'themify-favicon-alt' => 'M11.5 3.5c15.8-5 21.8 9 20.3 17.3-.9 4.5-10 5.7-18 6.5-6.9.7-12.1 2.3-12.1 2.3s6.2-4.7 2.1-6.8C1.4 21.6-6.6 9.1 11.5 3.5zm7.3 6c-1 0-1.9.8-1.9 1.8a2 2 0 0 0 2 1.9c1 0 1.8-.9 1.8-1.9 0-1-.8-1.9-1.9-1.9zm-9.4.9a1.9 1.9 0 0 0-1.9 1.9 2 2 0 0 0 2 1.8 2 2 0 0 0 1.8-1.8c0-1.1-.9-2-1.9-2zM7 17.8s7.7 9.8 18.2-1.8c0 0-12.1 7.2-18.2 1.8z',
            'support' => 'M25.19 5.63H32v24.5H0V5.63h6.81C8.56 2.19 12.06 0 16.01 0s7.43 2.19 9.18 5.63zM16 1.88a8.33 8.33 0 0 0-7 3.75h14a8.32 8.32 0 0 0-7-3.75zm14.13 26.37V7.5H1.88v20.75h28.25zm-15.07-9.44v3.75h1.88v-3.75h3.75v-1.87h-3.75v-3.75h-1.88v3.75h-3.75v1.87h3.75z',
            'stamp' => 'M32 22.44v7.69h-1.88V32H1.88v-1.87H0v-7.7c0-2 1.63-3.56 3.56-3.56h8.25l-2.37-8.8V3.74A3.76 3.76 0 0 1 13.19 0h5.62c2 0 3.75 1.69 3.75 3.75l-.06 6.62-2.37 8.5h8.3A3.56 3.56 0 0 1 32 22.44zm-1.88 5.81v-5.81c0-.94-.75-1.7-1.68-1.7H17.69l3-10.74V3.75c0-1-.88-1.88-1.88-1.88H13.2c-1 0-1.88.88-1.88 1.88v6.19l3 10.81H3.56c-.94 0-1.69.75-1.69 1.69v5.81h28.25z',
            'split-v-alt' => 'M10.06 11 8.75 9.69 2.44 16l6.31 6.31L10.06 21l-4.93-5zm13.19-1.31L29.56 16l-6.31 6.31-1.31-1.3 4.93-5-4.93-5zM15.06 32V0h1.88v32h-1.88z',
            'slice' => 'M31.19 7.25c.5.5.81 1.25.81 2s-.31 1.44-.81 2L16.75 25.69l-1.56-1.5-4.13 4.12H.87l23.7-23.75a2.9 2.9 0 0 1 4 0zM12.75 19.06l4 3.94 1.5-1.56-3.94-3.94zm-2.44 7.38 3.57-3.63-2.44-2.44-6.06 6.07h4.93zm19.5-16.57a.9.9 0 0 0 0-1.3L27.2 5.93c-.19-.2-.38-.32-.63-.32s-.5.13-.68.32L15.63 16.19l4 3.93z',
            'shortcode' => 'M.06 1.88v28.25H5.7v-1.88H1.94V3.75h3.75V1.87H.06zm26.32 0h5.68v28.25h-5.68v-1.88h3.8V3.75h-3.8V1.87zM16.74 15c2.63 1 3.94 2.25 3.88 4.44 0 2.37-1.7 4.44-5.32 4.44a7.7 7.7 0 0 1-3.87-1l.5-1.63c.87.5 2.19 1 3.5 1 2.06 0 3.19-1.12 3.19-2.62 0-1.44-.82-2.25-2.88-3-2.44-.94-4-2.2-4-4.32 0-2.37 2-4.19 4.94-4.19 1.56 0 2.69.38 3.37.76l-.56 1.62c-.5-.25-1.5-.75-2.88-.75-2.06 0-2.87 1.25-2.87 2.31 0 1.44.94 2.13 3 2.94z',
            'shift-right-alt' => 'M28.63 16 22.3 9.69 21 11l4.94 5L21 21l1.31 1.31zM13.19 32V0h1.87v32H13.2z',
            'shift-left-alt' => 'M11 11 9.69 9.69 3.37 16l6.32 6.31L11 21l-4.94-5zm5.94-11h1.87v32h-1.87V0z',
            'ruler-alt-2' => 'M0 .56 31.44 32H0V.56zm1.88 4.57v25h25l-4.75-4.82-1.25 1.25-1.32-1.31L20.75 24l-1.31-1.31-1.25 1.18-1.32-1.3 1.25-1.26L16.75 20l-1.19 1.25-1.37-1.38 1.25-1.18-1.32-1.38-1.25 1.25-1.31-1.31L12.75 16l-1.31-1.32-1.25 1.2-1.32-1.32 1.25-1.25L8.75 12l-1.2 1.25-1.37-1.38 1.25-1.19zm1.87 23.12v-14.5l14.5 14.5H3.75zm1.88-10v8.13h8.12z',
            'receipt' => 'M3.75 0h24.5v31.81l-3.75-4.68-2.81 3.56-2.82-3.57-2.8 3.57-2.82-3.57-2.81 3.57-2.88-3.57-3.81 4.7V0zm22.63 26.44V1.87H5.63v24.7l2-2.45 2.8 3.57 2.82-3.57 2.81 3.57 2.82-3.57 2.81 3.57 2.81-3.57zM20.68 7.5V5.62H9.39V7.5h11.3zm-3.74 7.56V13.2H9.37v1.87h7.57zm5.62-3.75V9.44H9.38v1.87h13.18zm-13.12 7.5v1.88h13.12V18.8H9.44z',
            'pin2' => 'M15.06 21.63V32h1.88V21.62h-1.88zm11.31-5.07-2.06-.93L22.2 3.74l.8-1.43L24.31 0H7.7L9 2.3l.81 1.44L7.7 15.63l-2.06.93v4.13h20.75v-4.13zm-1.87 1.25v1h-17v-1l1.88-.87 2.24-12.88.13-.62-.88-1.57h10.26l-.57 1-.31.57L22.44 16l.18.94z',
            'pin-alt' => 'M10.19 20.5.25 30.38l1.38 1.37 9.87-9.94zM32 11.69 20.31 0l-.75 2.5-.5 1.63-9.87 6.93-2.07-.81-2.93 2.94L18.8 27.8l2.94-2.94-.81-2.06 6.93-9.87zm-3.56-.88-1.07.32-.68.18-7.25 10.38-.63.81.38.94.37 1-.75.69L6.87 13.19l.7-.75 1.93.75 11.19-7.88.19-.68.3-1.07z',
            'pencil-alt2' => 'M17.88 0a2.8 2.8 0 0 1 2.8 2.81v20.07l-4.62 9.3-4.75-9.3V2.8A2.8 2.8 0 0 1 14.13 0h3.75zm-3.75 1.88c-.5 0-.94.43-.94.93v1.94h5.62V2.81c0-.5-.44-.93-.94-.93h-3.75zm1.06 24.5h1.62l1.75-3.44h-5.12zm-2-5.32h5.62V10.44H13.2v10.62zm0-12.5h5.62V6.62H13.2v1.94z',
            'palette' => 'M16 .94a15.07 15.07 0 0 1 8.25 27.69l-.62.37-7-7a2.9 2.9 0 0 0-4 0 2.7 2.7 0 0 0 0 4l5.12 5.13-2.44-.13A14.96 14.96 0 0 1 .94 16C.94 7.7 7.69.94 16 .94zm7.81 25.62A13.03 13.03 0 0 0 29.2 16c0-7.25-5.94-13.19-13.19-13.19S2.81 8.75 2.81 16a13.2 13.2 0 0 0 9.88 12.75l-1.44-1.44a4.68 4.68 0 0 1 0-6.62 4.92 4.92 0 0 1 6.69 0zm-2.18-14.31c2.12 0 3.8 1.69 3.8 3.75a3.78 3.78 0 0 1-7.55 0 3.76 3.76 0 0 1 3.75-3.75zm0 5.63c1.06 0 1.87-.82 1.87-1.88s-.81-1.88-1.88-1.88a1.88 1.88 0 0 0 0 3.75zM16 11.3a2.84 2.84 0 0 0 0-5.69 2.84 2.84 0 0 0 0 5.69zm-5.19-.25a1.87 1.87 0 0 0-3.75 0c0 1.07.82 1.94 1.88 1.94s1.87-.87 1.87-1.94z',
            'more' => 'M3.75 11.31c2.06 0 3.75 1.7 3.75 3.75s-1.69 3.75-3.75 3.75a3.76 3.76 0 0 1 0-7.5zm0 5.63c1.06 0 1.88-.81 1.88-1.88S4.8 13.2 3.75 13.2c-1 0-1.88.81-1.88 1.87s.88 1.88 1.88 1.88zM16 11.3c2.06 0 3.75 1.7 3.75 3.75S18.06 18.8 16 18.8a3.76 3.76 0 0 1 0-7.5zm0 5.63c1.06 0 1.88-.81 1.88-1.88S17.05 13.2 16 13.2s-1.88.81-1.88 1.87.82 1.88 1.88 1.88zm12.25-5.63c2.06 0 3.75 1.7 3.75 3.75s-1.69 3.75-3.75 3.75a3.76 3.76 0 0 1 0-7.5zm0 5.63a1.88 1.88 0 1 0 0-3.75c-1.06 0-1.88.81-1.88 1.87s.82 1.88 1.88 1.88z',
            'more-alt' => 'M7.5 15.06c0-2.06-1.69-3.75-3.75-3.75S0 13.01 0 15.06s1.69 3.75 3.75 3.75 3.75-1.68 3.75-3.75zm8.5-3.75c2.06 0 3.75 1.7 3.75 3.75s-1.69 3.75-3.75 3.75a3.76 3.76 0 0 1 0-7.5zm12.25 0c2.06 0 3.75 1.7 3.75 3.75s-1.69 3.75-3.75 3.75a3.76 3.76 0 0 1 0-7.5z',
            'microphone-alt' => 'm21.88 13.19-2.13 15.06h-2.81V32h-1.88v-3.75h-2.81L10.12 13.2A7.68 7.68 0 0 1 8 7.88a8.01 8.01 0 0 1 16 0c0 2.06-.81 3.93-2.13 5.3zM11.3 4.06a5.7 5.7 0 0 0-1.37 3.82 6.07 6.07 0 0 0 12.12 0c0-1.5-.5-2.82-1.37-3.82V7.5H18.8v-5a6.02 6.02 0 0 0-1.87-.62v7.56h-1.88V1.88c-.68.12-1.3.3-1.87.62v5H11.3V4.06zm2.63 22.32h4.12l1.7-11.5c-1.13.56-2.38.93-3.76.93s-2.62-.37-3.75-.93z',
            'magnet' => 'M20.69 0h9.44v19.63C30.13 27.69 22.88 32 16 32S1.88 27.69 1.88 19.62V0h9.43v19.06c0 2.5 2.07 4.5 4.7 4.5s4.68-2 4.68-4.5V0zm7.56 1.88h-5.69V7.5h5.69V1.87zm-18.81 0H3.75V7.5h5.69V1.87zM16 30.13c4.94 0 12.25-2.82 12.25-10.5V9.43h-5.69v9.63c0 3.5-2.94 6.44-6.56 6.44s-6.56-2.94-6.56-6.44V9.44h-5.7v10.19c0 7.68 7.32 10.5 12.26 10.5z',
            'line-double' => 'M32 11.31H0v1.88h32V11.3zm-32 7.5v-1.87h32v1.87H0z',
            'line-dotted' => 'M0 15.06v1.88h.94v-1.88H0zm4.5 1.88v-1.88h1.75v1.88H4.5zm5.31 0v-1.88h1.75v1.88H9.81zm10.63 0v-1.88h1.75v1.88h-1.75zm-5.32 0v-1.88h1.76v1.88h-1.75zm10.63 0v-1.88h1.75v1.88h-1.75zm5.31-1.88H32v1.88h-.94v-1.88z',
            'line-dashed' => 'M0 15.06v1.88h7.5v-1.88H0zm12.25 1.88v-1.88h7.5v1.88h-7.5zm12.25-1.88H32v1.88h-7.5v-1.88z',
            'layout-width-full' => 'M0 0h32v32H0V0zm30.13 30.13V1.88H1.88v28.25h28.25z',
            'layout-width-default' => 'M0 0h32v32H0V0zm30.13 30.13V1.88H1.88v28.25h28.25zM5.63 15.05v1.88H7.5v-1.88H5.62zm0-7.56v1.94H7.5V7.5H5.62zm0 11.31v1.88H7.5V18.8H5.62zm0-7.5v1.88H7.5V11.3H5.62zm0-7.56v1.88H7.5V3.75H5.62zm0 22.63v1.87H7.5v-1.87H5.62zm0-3.82v1.94H7.5v-1.94H5.62zM24.5 3.75v1.88h1.88V3.75H24.5zm0 7.56v1.88h1.88V11.3H24.5zm0-3.81v1.94h1.88V7.5H24.5zm0 7.56v1.88h1.88v-1.88H24.5zm0 3.75v1.88h1.88V18.8H24.5zm0 3.75v1.94h1.88v-1.94H24.5zm0 3.81v1.88h1.88v-1.88H24.5z',
            'layout-width-default-alt' => 'M3.75 30.13V32h1.88v-1.88H3.75zM18.81 32v-1.88h1.88V32H18.8zm3.75 0v-1.88h1.94V32h-1.94zM7.5 32v-1.88h1.94V32H7.5zm3.81 0v-1.88h1.88V32H11.3zm3.75 0v-1.88h1.88V32h-1.88zm11.31 0v-1.88h1.88V32h-1.88zm0-26.38V3.75h1.88v1.88h-1.88zm0 3.82V7.5h1.88v1.94h-1.88zm0 15.06v-1.94h1.88v1.94h-1.88zm0-11.31V11.3h1.88v1.88h-1.88zm0 3.75v-1.88h1.88v1.88h-1.88zm0 11.31v-1.88h1.88v1.88h-1.88zm0-7.56V18.8h1.88v1.88h-1.88zm0-20.69h1.88v1.88h-1.88V0zm-3.8 1.88V0h1.93v1.88h-1.94zm-11.26 0V0h1.88v1.88H11.3zm3.75 0V0h1.88v1.88h-1.88zm3.75 0V0h1.88v1.88H18.8zm-11.31 0V0h1.94v1.88H7.5zm-3.75 0V0h1.87v1.88H3.75zm0 22.62v-1.94h1.87v1.94H3.75zm0 3.75v-1.88h1.87v1.88H3.75zm0-7.56V18.8h1.87v1.88H3.75zm0-15.07V3.75h1.87v1.88H3.75zm0 3.82V7.5h1.87v1.94H3.75zm0 3.75V11.3h1.87v1.88H3.75zm0 3.75v-1.88h1.87v1.88H3.75z',
            'layout-tab' => 'M13.19 5.63H32v24.5H0V3.75h13.2v1.88zm7.5 1.87h-7.5v1.94h7.5V7.5zm9.44 20.75V11.31H11.3V5.62H1.87v22.63h28.25zM22.55 9.44h7.57V7.5h-7.57v1.94z',
            'layout-tab-window' => 'M22.56 3.75H32v26.38H0V3.75h22.56zm7.57 1.88h-7.57v3.8h7.57v-3.8zm-9.44 0H11.3v3.8h9.38v-3.8zm-18.81 0v3.8h7.56v-3.8H1.88zm28.25 22.62V11.31H1.88v16.94h28.25z',
            'layout-tab-v' => 'M11.31 1.88h20.7v28.25H11.3V18.8H1.87v-7.5H0V3.75h11.31V1.87zM3.75 11.3v1.88h7.56V11.3H3.75zm0 5.63h7.56v-1.88H3.75v1.88zm26.38 11.31V3.75H13.18v1.88H1.87v3.8H13.2v18.82h16.94z',
            'layout-tab-min' => 'M13.19 3.75H32v5.69H11.31V3.75H1.87v5.63H0v-7.5h13.19v1.87zm0 1.88V7.5h7.5V5.62h-7.5zm9.37 1.87h7.57V5.62h-7.57V7.5z',
            'layout-slider' => 'M0 1.88h32v26.37H0V1.87zm30.13 24.5V3.75H1.88v22.63h28.25zM8.75 19.5l1.31-1.31L7 15.06l3.06-3.12-1.31-1.32-4.44 4.44zm13.19-1.31 1.31 1.31 4.44-4.44-4.44-4.44-1.31 1.32L25 15.06z',
            'layout-slider-alt' => 'M3.75 26.38V5.63h24.5v20.75H3.75zM5.63 7.5v17h20.75v-17H5.63zm24.5 1v15H32v-15h-1.88zM0 8.5v15h1.88v-15H0z',
            'layout-sidebar-right' => 'M32 0h-9.44v32H32V0zM16.94 32v-1.88h1.87V32h-1.87zm-3.32 0v-1.88h1.63V32h-1.63zM3.56 32v-1.88h1.7V32h-1.7zm3.32 0v-1.88h1.68V32H6.87zm3.37 0v-1.88h1.69V32h-1.69zM0 32v-1.88h1.88V32H0zm0-15.06v-1.88h1.88v1.88H0zM0 5.62V3.75h1.88v1.88H0zM0 20.7v-1.9h1.88v1.88H0zm0-7.5v-1.9h1.88v1.88H0zm0 11.3v-1.94h1.88v1.94H0zm0 3.75v-1.88h1.88v1.88H0zM0 9.44V7.5h1.88v1.94H0zm0-7.56V0h1.88v1.88H0zM15.25 0v1.88h-1.63V0h1.63zm-3.31 0v1.88h-1.69V0h1.69zM5.25 0v1.88H3.56V0h1.69zm3.31 0v1.88H6.87V0h1.7zm8.38 1.88V0h1.87v1.88h-1.87zm0 26.37v-1.88h1.87v1.88h-1.87zm0-3.75v-1.94h1.87v1.94h-1.87zm0-7.56v-1.88h1.87v1.88h-1.87zm0 3.75V18.8h1.87v1.88h-1.87zm0-11.25V7.5h1.87v1.94h-1.87zm0 3.75V11.3h1.87v1.88h-1.87zm0-7.57V3.75h1.87v1.88h-1.87z',
            'layout-sidebar-none' => 'M0 30.13V32h1.88v-1.88H0zM26.38 32v-1.88h1.87V32h-1.88zm-3.82 0v-1.88h1.94V32h-1.94zm-3.75 0v-1.88h1.88V32H18.8zm-3.75 0v-1.88h1.88V32h-1.88zm-3.75 0v-1.88h1.88V32H11.3zm-7.56 0v-1.88h1.88V32H3.75zm3.75 0v-1.88h1.94V32H7.5zm22.63 0v-1.88H32V32h-1.88zm0-11.31V18.8H32v1.88h-1.88zm0 3.81v-1.94H32v1.94h-1.88zm0-15.06V7.5H32v1.94h-1.88zm0 7.5v-1.88H32v1.88h-1.88zm0-3.75V11.3H32v1.88h-1.88zm0-7.56V3.75H32v1.88h-1.88zm0 22.62v-1.87H32v1.87h-1.88zm0-28.25H32v1.88h-1.88V0zM7.5 1.88V0h1.94v1.88H7.5zm-3.75 0V0h1.88v1.88H3.75zm18.81 0V0h1.94v1.88h-1.94zm-3.75 0V0h1.88v1.88H18.8zm-7.5 0V0h1.88v1.88H11.3zm15.06 0V0h1.88v1.88h-1.88zm-11.3 0V0h1.87v1.88h-1.88zM0 1.88V0h1.88v1.88H0zM0 24.5v-1.94h1.88v1.94H0zm0 3.75v-1.88h1.88v1.88H0zm0-7.56V18.8h1.88v1.88H0zM0 9.44V7.5h1.88v1.94H0zm0 7.5v-1.88h1.88v1.88H0zM0 5.62V3.75h1.88v1.88H0zm0 7.57V11.3h1.88v1.88H0z',
            'layout-sidebar-left' => 'M0 0v32h9.44V0H0zm13.19 32v-1.88h1.87V32H13.2zm13.56 0v-1.88h1.69V32h-1.69zm-3.31 0v-1.88h1.69V32h-1.7zm-6.69 0v-1.88h1.63V32h-1.63zm3.31 0v-1.88h1.7V32h-1.7zm10.06 0v-1.88H32V32h-1.88zm0-26.38V3.75H32v1.88h-1.88zm0 22.63v-1.88H32v1.88h-1.88zm0-15.06V11.3H32v1.88h-1.88zm0-3.75V7.5H32v1.94h-1.88zm0 7.5v-1.88H32v1.88h-1.88zm0 3.75V18.8H32v1.88h-1.88zm0 3.81v-1.94H32v1.94h-1.88zm0-24.5H32v1.88h-1.88V0zm-3.37 1.88V0h1.69v1.88h-1.69zm-3.31 0V0h1.69v1.88h-1.7zm-3.38 0V0h1.7v1.88h-1.7zm-3.31 0V0h1.63v1.88h-1.63zm-3.56 0V0h1.87v1.88H13.2zm0 26.37v-1.88h1.87v1.88H13.2zm0-3.75v-1.94h1.87v1.94H13.2zm0-11.31V11.3h1.87v1.88H13.2zm0 7.5V18.8h1.87v1.88H13.2zm0-11.25V7.5h1.87v1.94H13.2zm0-3.81V3.75h1.87v1.88H13.2zm0 11.3v-1.87h1.87v1.88H13.2z',
            'layout-placeholder' => 'M.06 1.88h32v28.25h-32V1.88zM15.31 16 1.94 4.31V27.7zM2.75 3.81l13.31 11.57L29.38 3.8H2.75zm13.31 12.81L2.7 28.26h26.6zm.69-.62 13.44 11.75V4.31z',
            'layout-menu' => 'M0 13.19h24.5v5.62H0V13.2zm15.06 1.87H9.44v1.88h5.62v-1.88zm-13.19 0v1.88H7.5v-1.88H1.87zm20.7 1.88v-1.88h-5.63v1.88h5.62z',
            'layout-menu-v' => 'M5.63 1.88h20.75V7.5H5.63V1.87zM24.5 5.63V3.75h-17v1.88h17zM5.62 15.05V9.44h20.75v5.62H5.63zM7.5 11.3v1.88h17V11.3h-17zM5.62 22.56v-5.62h20.75v5.62H5.63zm1.88-3.75v1.88h17V18.8h-17zM5.62 30.13v-5.7h20.75v5.7H5.63zm1.88-3.75v1.87h17v-1.88h-17z',
            'layout-menu-separated' => 'M0 18.81V13.2h9.44v5.62H0zm1.88-3.75v1.88H7.5v-1.88H1.87zm9.43 3.75V13.2h9.38v5.62H11.3zm1.88-3.75v1.88h5.62v-1.88H13.2zm9.37-1.87H32v5.62h-9.44V13.2zm7.57 3.75v-1.88H24.5v1.88h5.63z',
            'layout-menu-full' => 'M0 13.19h32v5.62H0V13.2zm16.94 1.87v1.88h5.62v-1.88h-5.62zm-1.88 1.88v-1.88H9.44v1.88h5.62zM1.87 15.06v1.88H7.5v-1.88H1.87zm28.25 1.88v-1.88H24.5v1.88h5.63z',
            'layout-media-right-alt' => 'M3.75 24.5v1.88H32V24.5H3.75zm9.44 5.63v-1.88H32v1.88H13.2zM32 1.88H0v20.68h32V1.88zm-1.88 1.87v16.94H1.88V3.75h28.25z',
            'layout-media-right' => 'M15.06 7.5H32v17H15.06v-17zm15.06 15.06V9.44H16.95v13.12h13.19zM2.2 7.5v1.94h11V7.5h-11zm4.43 7.56v1.88h6.57v-1.88H6.63zm6.57-1.87V11.3H0v1.88h13.19zM0 18.8v1.88h13.19V18.8H0zm2.19 3.75v1.94h11v-1.94h-11z',
            'layout-media-overlay' => 'M28.25 22.56V20.7H3.75v1.87h24.5zm-5.69 1.88v1.87H3.75v-1.87h18.81zM32 1.87H0v28.25h32V1.88zm-1.88 1.88v24.5H1.88V3.75h28.25z',
            'layout-media-overlay-alt' => 'M0 3.75h32v22.63H0V3.75zm1.88 15.06h28.25V5.63H1.88V18.8z',
            'layout-media-overlay-alt-2' => 'M22.56 16.94v-1.88H3.75v1.88h18.81zm0 1.87v1.88H3.75V18.8h18.81zM32 1.88H0v28.25h32V1.88zm-1.88 1.87v24.5H1.88V3.75h28.25z',
            'layout-media-left-alt' => 'M0 24.5v1.88h28.25V24.5H0zm0 5.63v-1.88h18.81v1.88H0zM32 1.88H0v20.68h32V1.88zm-1.88 1.87v16.94H1.88V3.75h28.25z',
            'layout-media-left' => 'M18.81 7.5v1.94h11V7.5h-11zm0 7.56v1.88h6.57v-1.88H18.8zm0-3.75v1.88h13.2V11.3H18.8zm0 7.5v1.88h13.2V18.8H18.8zm0 3.75v1.94h11v-1.94h-11zM0 24.5v-17h16.94v17H0zM1.88 9.44v13.12h13.18V9.44H1.87z',
            'layout-media-center-alt' => 'M1.88 24.5v1.88h28.25V24.5H1.88zm5.62 5.63v-1.88h17v1.88h-17zM32 1.88H0v20.68h32V1.88zm-1.88 1.87v16.94H1.88V3.75h28.25z',
            'layout-media-center' => 'M1.88 7.5h28.25v11.31H1.88V7.5zm26.37 9.44v-7.5H3.75v7.5h24.5zm-1.88 3.75H5.63v1.87h20.75V20.7zM3.75 24.5v1.88h24.5V24.5H3.75z',
            'layout-list-thumb' => 'M28.25 7.5V5.62H11.31V7.5h16.94zM11.31 9.44h20.7v1.87H11.3V9.44zM0 3.75v9.44h9.44V3.75H0zm1.88 7.56V5.62H7.5v5.7H1.87zm26.37 7.5v1.88H11.31V18.8h16.94zM11.31 24.5v-1.94h20.7v1.94H11.3zM0 16.94v9.44h9.44v-9.44H0zm1.88 7.56v-5.69H7.5v5.69H1.87z',
            'layout-list-thumb-alt' => 'M28.25 9.44V7.5H11.31v1.94h16.94zM11.31 11.3h20.7v1.88H11.3V11.3zM0 15.06V5.62h9.44v9.44H0zm28.25 5.63v1.87H11.31V20.7h16.94zm-16.94 5.69V24.5h20.7v1.88H11.3zM0 28.25v-9.44h9.44v9.44H0z',
            'layout-list-post' => 'M26.38 9.44V5.63H0v3.8h26.38zM0 11.3h32v1.88H0V11.3zm26.38 7.5v3.75H0V18.8h26.38zM0 26.38V24.5h32v1.88H0z',
            'layout-list-large-image' => 'M31.06 9.44V7.5h-4.68v1.94h4.68zm-1.87 5.62v1.88h-2.82v-1.88h2.82zm-2.82-3.75H32v1.88h-5.63V11.3zm0 9.38V18.8H32v1.88h-5.63zm0 3.81v-1.94h4.7v1.94h-4.7zM0 7.5v17h24.5v-17H0zm1.88 15.06V9.44h20.68v13.12H1.88z',
            'layout-line-solid' => 'M32 15.06H0v1.88h32v-1.88z',
            'layout-grid4' => 'M1.88 7.5V1.87H7.5V7.5H1.87zm1.87-3.75v1.88h1.88V3.75H3.75zM9.44 7.5V1.87h5.62V7.5H9.44zm1.87-3.75v1.88h1.88V3.75H11.3zm5.63 3.75V1.87h5.62V7.5h-5.62zm1.87-3.75v1.88h1.88V3.75H18.8zm5.69-1.88h5.63V7.5H24.5V1.87zm3.75 3.75V3.75h-1.88v1.88h1.88zM1.87 15.06V9.44H7.5v5.62H1.87zm1.88-3.75v1.88h1.88V11.3H3.75zm5.69 3.75V9.44h5.62v5.62H9.44zm1.87-3.75v1.88h1.88V11.3H11.3zm5.63 3.75V9.44h5.62v5.62h-5.62zm1.87-3.75v1.88h1.88V11.3H18.8zm5.69 3.75V9.44h5.63v5.62H24.5zm1.88-3.75v1.88h1.87V11.3h-1.88zM1.88 22.56v-5.62H7.5v5.62H1.87zm1.87-3.75v1.88h1.88V18.8H3.75zm5.69 3.75v-5.62h5.62v5.62H9.44zm1.87-3.75v1.88h1.88V18.8H11.3zm5.63 3.75v-5.62h5.62v5.62h-5.62zm1.87-3.75v1.88h1.88V18.8H18.8zm5.69 3.75v-5.62h5.63v5.62H24.5zm1.88-3.75v1.88h1.87V18.8h-1.88zM1.88 30.13V24.5H7.5v5.63H1.87zm1.87-3.75v1.87h1.88v-1.88H3.75zm5.69 3.75V24.5h5.62v5.63H9.44zm1.87-3.75v1.87h1.88v-1.88H11.3zm5.63 3.75V24.5h5.62v5.63h-5.62zm1.87-3.75v1.87h1.88v-1.88H18.8zm5.69 3.75V24.5h5.63v5.63H24.5zm1.88-3.75v1.87h1.87v-1.88h-1.88z',
            'layout-grid3' => 'M0 9.44V0h9.44v9.44H0zm1.88-7.56V7.5H7.5V1.87H1.87zm9.43 7.56V0h9.38v9.44H11.3zm1.88-7.56V7.5h5.62V1.87H13.2zM22.56 0H32v9.44h-9.44V0zm7.57 7.5V1.87H24.5V7.5h5.63zM0 20.69V11.3h9.44v9.38H0zm1.88-7.5v5.62H7.5V13.2H1.87zm9.43 7.5V11.3h9.38v9.38H11.3zm1.88-7.5v5.62h5.62V13.2H13.2zm9.37 7.5V11.3H32v9.38h-9.44zm1.94-7.5v5.62h5.63V13.2H24.5zM0 32v-9.44h9.44V32H0zm1.88-7.5v5.63H7.5V24.5H1.87zM11.3 32v-9.44h9.38V32H11.3zm1.88-7.5v5.63h5.62V24.5h-5.6zm9.37 7.5v-9.44H32V32h-9.44zm1.94-7.5v5.63h5.63V24.5H24.5z',
            'layout-grid2' => 'M0 13.19V0h13.19v13.19H0zM1.88 1.88v9.43h9.43V1.87H1.87zM16.94 0h13.19v13.19h-13.2V0zm11.31 11.31V1.87h-9.44v9.44h9.44zM0 30.12V16.95h13.19v13.19H0zm1.88-11.3v9.43h9.43v-9.44H1.87zm15.06 11.3V16.95h13.19v13.19h-13.2zm1.87-11.3v9.43h9.44v-9.44h-9.44z',
            'layout-grid2-thumb' => 'M0 3.75v5.69h5.63V3.75H0zm16.94 5.69V3.75h5.62v5.69h-5.62zM0 24.5v-5.69h5.63v5.69H0zm16.94 0v-5.69h5.62v5.69h-5.62zM7.5 5.62V3.75h7.56v1.88H7.5zm0 3.82V7.5h7.56v1.94H7.5zm17-5.69H32v1.88h-7.5V3.75zm0 5.69V7.5H32v1.94h-7.5zM13.19 11.3v1.88H7.5V11.3h5.69zm16.94 0v1.88H24.5V11.3h5.63zM7.5 20.7v-1.9h7.56v1.88H7.5zm0 3.81v-1.94h7.56v1.94H7.5zm17-3.81v-1.9H32v1.88h-7.5zm0 3.81v-1.94H32v1.94h-7.5zm-17 3.75v-1.88h5.69v1.88H7.5zm17 0v-1.88h5.63v1.88H24.5z',
            'layout-cta-right' => 'M0 5.63h32v20.75H0V5.63zM30.13 24.5v-17H1.88v17h28.25zm-3.75-9.44V13.2H7.5v1.87h18.88zm-9.44 1.88v3.75h9.44v-3.75h-9.44z',
            'layout-cta-left' => 'M0 5.63h32v20.75H0V5.63zM30.13 24.5v-17H1.88v17h28.25zm-5.63-9.44V13.2H5.62v1.87H24.5zm-9.44 5.63v-3.75H5.62v3.75h9.44z',
            'layout-cta-center' => 'M26.38 15.06V13.2H5.63v1.87h20.75zM32 5.62H0v20.75h32V5.63zM30.12 7.5v17H1.88v-17h28.25zM11.95 20.69v-3.75h8.12v3.75h-8.12z',
            'layout-cta-btn-right' => 'M16.94 13.19V11.3H3.75v1.88h13.19zM7.5 16.94v-1.88h9.44v1.88H7.5zM32 5.62H0V24.5h32V5.62zM30.12 7.5v15.06H1.88V7.5h28.25zm-1.87 3.81v3.75h-9.44v-3.75h9.44z',
            'layout-cta-btn-left' => 'M28.25 13.19V11.3H15.06v1.88h13.19zm-13.19 3.75v-1.88h9.44v1.88h-9.44zM32 5.62H0V24.5h32V5.62zM30.12 7.5v15.06H1.88V7.5h28.25zM13.2 11.31v3.75H3.75v-3.75h9.44z',
            'layout-column4' => 'M1.88 32V0H7.5v32H1.87zM3.75 1.87v28.25h1.88V1.88H3.75zM9.44 32V0h5.62v32H9.44zM11.3 1.87v28.25h1.88V1.88H11.3zM16.94 32V0h5.62v32h-5.62zM18.8 1.87v28.25h1.88V1.88H18.8zM24.5 0h5.63v32H24.5V0zm3.75 30.13V1.88h-1.88v28.25h1.88z',
            'layout-column3' => 'M0 32V0h9.44v32H0zM1.88 1.87v28.25H7.5V1.88H1.87zM11.3 32V0h9.38v32H11.3zm1.9-30.13v28.25h5.62V1.88H13.2zM22.56 0H32v32h-9.44V0zm7.57 30.13V1.88H24.5v28.25h5.63z',
            'layout-column2' => 'M0 32V0h15.06v32H0zM1.88 1.87v28.25h11.3V1.88H1.89zM16.94 0H32v32H16.94V0zm13.18 30.13V1.88h-11.3v28.25h11.3z',
            'layout-accordion-separated' => 'M0 0h32v5.63H0V0zm30.13 3.75V1.87H1.88v1.88h28.25zM0 24.5v-17h32v17H0zM1.88 9.44v13.12h28.25V9.44H1.88zM0 32v-5.63h32V32H0zm1.88-3.75v1.88h28.25v-1.88H1.88z',
            'layout-accordion-merged' => 'M0 0h32v32H0V0zm30.13 1.88H1.88V18.8h28.25V1.88zm0 18.8H1.88v3.82h28.25v-3.8zM1.88 30.13h28.25v-3.75H1.88v3.75z',
            'layout-accordion-list' => 'M7.5 0H32v16.94H7.5V0zm22.63 15.06V1.87H9.43v13.2h20.7zM0 5.62V0h5.63v5.63H0zm1.88-3.75v1.88h1.87V1.87H1.87zM7.5 24.5v-5.69H32v5.69H7.5zm1.94-3.81v1.87h20.69V20.7H9.43zM0 24.5v-5.69h5.63v5.69H0zm1.88-3.81v1.87h1.87V20.7H1.87zM7.5 32v-5.63H32V32H7.5zm1.94-3.75v1.88h20.69v-1.88H9.43zM0 32v-5.63h5.63V32H0zm1.88-3.75v1.88h1.87v-1.88H1.87z',
            'ink-pen' => 'M5.63 0h20.75v12.25L15.94 30.13 5.62 12.25V0zm10.3 26.38zM16 11.3c1.06 0 1.88-.87 1.88-1.87 0-1.06-.82-1.94-1.88-1.94s-1.88.88-1.88 1.94c0 1 .82 1.87 1.88 1.87zm8.5.44V1.87h-17v9.88l7.56 13.06V13.06A3.78 3.78 0 0 1 16 5.62a3.78 3.78 0 0 1 .94 7.44v11.57z',
            'info-alt' => 'M16 0c8.81 0 16 7.19 16 16s-7.19 16-16 16S0 24.81 0 16 7.19 0 16 0zm0 30.13a14.12 14.12 0 1 0 .02-28.24A14.12 14.12 0 0 0 16 30.13zm.94-6.82V13.06h-3.69v1.88h1.81v8.37H13.2v1.88h5.62V23.3h-1.87zM13.5 9.38c0 1.06.88 1.87 1.88 1.87 1.06 0 1.87-.81 1.87-1.88 0-1-.81-1.87-1.88-1.87-1 0-1.87.88-1.87 1.88z',
            'help-alt' => 'M16 0c8.81 0 16 7.19 16 16s-7.19 16-16 16S0 24.81 0 16 7.19 0 16 0zm0 30.13a14.12 14.12 0 1 0 .02-28.24A14.12 14.12 0 0 0 16 30.13zM18.19 23c0-1.06-.88-1.94-1.94-1.94s-1.94.88-1.94 1.94.88 1.94 1.94 1.94 1.94-.88 1.94-1.94zm1.87-15.06a4.68 4.68 0 0 0-3.81-1.81A5.06 5.06 0 0 0 10.81 11h1.88c.06-.31.19-3 3.56-3 1 0 1.75.38 2.31 1.13.63.74.75 1.62.7 1.87-.32 1.38-1.13 2.06-2 2.88-1.13 1-2.38 2.12-2.38 4.5h1.87c0-1.5.75-2.2 1.75-3.13 1-.88 2.13-1.88 2.63-3.81.18-1-.2-2.44-1.07-3.5z',
            'headphone-alt' => 'M29.5 11.31a2.89 2.89 0 0 1 2.5 2.82v7.5a2.85 2.85 0 0 1-2.81 2.87h-2.82v-1.94H24.5V13.2h1.87v-1.9h1.13C25.75 5.7 21.19 1.88 16 1.88S6.25 5.75 4.5 11.3h1.12v1.88H7.5v9.37H5.62v1.94h-2a4.76 4.76 0 0 0 4.63 3.75h5.12A2.7 2.7 0 0 1 16 26.38h5.62c1.57 0 2.88 1.25 2.88 2.8S23.19 32 21.62 32H16a2.78 2.78 0 0 1-2.63-1.87H8.25a6.56 6.56 0 0 1-6.5-5.88A2.9 2.9 0 0 1 0 21.63v-7.5a2.89 2.89 0 0 1 2.5-2.82C4.3 4.63 9.8.01 16 .01c6.25 0 11.69 4.62 13.5 11.3zM16 28.25c-.5 0-.94.44-.94.94s.44.94.94.94h5.63c.56 0 .93-.44.93-.94s-.37-.94-.93-.94H16zM3.75 22.56V13.2h-.94c-.5 0-.94.44-.94.94v7.5c0 .56.44.93.94.93h.94zm26.38-.93v-7.5c0-.5-.44-.94-.94-.94h-.94v9.37h.94c.5 0 .93-.37.93-.94z',
            'hand-point-up' => 'M27.31 15.5a2.9 2.9 0 0 0-3.75-2.75v-.25a2.82 2.82 0 0 0-2.81-2.88c-.38 0-.69.07-.94.13A2.85 2.85 0 0 0 17 7.12c-.38 0-.69.07-1 .13V2.87C16 1.31 14.75 0 13.19 0S10.3 1.31 10.3 2.88v9.25l-.5-.57c-.5-.5-1.87-1.94-3.69-.81a2.8 2.8 0 0 0-1.06 3.81l6.19 13.38a3 3 0 0 0 1.06 1.12V30c0 .5.44.94.94.94s.94-.44.94-.94v-1.63c0-.37-.32-.75-.7-.87-.24-.06-.5-.25-.55-.38l-6.2-13.37a1.1 1.1 0 0 1 .32-1.44c.25-.12.56-.31 1.44.56l2.06 2.32c.32.25.69.37 1.07.19.37-.13.56-.44.56-.88V2.88c0-.57.44-1 1-1 .5 0 .94.43.94 1v6.87c0 .5.37.88.87.94.5 0 .94-.38 1-.81.06-.5.5-.88 1-.88s.94.44.94 1v2.38c0 .5.37.93.87.93.57.07.94-.37 1-.87 0-.56.44-.94.94-.94s.94.44.94 1v2.94c0 .5.44.94.94.94.56.06.94-.38.94-.88s.3-1 .87-1c.5 0 1 .44 1 1v6c0 .94-.56 2.44-1.06 3.75-.44 1.31-.88 2.38-.88 3.13V30c0 .5.44.94 1 .94.5 0 .94-.44.94-.94v-1.62c0-.44.38-1.5.69-2.5.56-1.44 1.19-3.13 1.19-4.38v-6z',
            'hand-point-right' => 'M31.88 14.13a2.92 2.92 0 0 0-2.94-2.88h-9.2l.5-.44c.57-.56 1.95-1.94.88-3.75A2.88 2.88 0 0 0 17.25 6L3.87 12.19c-.43.25-.8.62-1.06 1.06h-.94c-.5 0-.93.44-.93.94s.43.94.93.94h1.57c.43 0 .8-.32.93-.7.07-.24.2-.5.38-.55l13.37-6.2A.99.99 0 0 1 19.5 8c.19.31.31.56-.5 1.44l-2.31 2.06c-.25.31-.38.69-.25 1.06s.5.57.87.57h11.63c.56 0 1.06.44 1.06 1 0 .5-.5.94-1.06.94h-6.82c-.5 0-.87.37-.93.87s.3.94.8 1 .88.5.88 1-.43.94-1 .94H19.5c-.5 0-.94.37-.94.87-.06.5.38.94.88 1 .5 0 .93.44.93.94s-.43.94-1 .94h-2.93a.92.92 0 0 0-.94.94c-.07.5.37.93.87.93s1 .32 1 .88-.5 1-1 1h-6c-.94 0-2.44-.56-3.75-1.06-1.31-.44-2.37-.82-3.12-.82H1.87c-.5 0-.94.38-.94.94 0 .5.44.94.94.94H3.5a10 10 0 0 1 2.44.75c1.5.5 3.12 1.13 4.43 1.13h6a2.9 2.9 0 0 0 2.88-2.88c0-.31-.06-.56-.13-.88h.25a2.85 2.85 0 0 0 2.88-2.8c0-.32-.06-.7-.19-.95a2.9 2.9 0 0 0 2.69-2.8c0-.38-.06-.7-.19-1h4.38a2.87 2.87 0 0 0 2.93-2.82z',
            'hand-point-left' => 'M30.94 25.44a.92.92 0 0 0-.94-.94h-1.63c-.75 0-1.8.38-3.12.81-1.31.5-2.81 1.07-3.75 1.07h-6c-.56 0-1-.44-1-1s.5-.88 1-.88.88-.44.88-.94-.44-.93-.94-.93H12.5c-.56 0-1-.44-1-.94s.37-.94.94-.94c.5-.06.87-.5.87-1s-.44-.88-.94-.88H10c-.56 0-1-.43-1-.93s.37-.94.87-1c.44-.07.82-.5.82-1-.07-.5-.44-.88-.94-.88H2.87c-.56 0-1-.44-1-.94 0-.56.44-1 1-1H14.5c.44 0 .75-.18.87-.56.2-.37.07-.75-.18-1.06l-2.25-2.07C12 8.56 12.19 8.31 12.3 8c.31-.44.94-.63 1.5-.32L27 13.81a1 1 0 0 1 .5.62c.12.38.5.7.87.7H30c.5 0 .94-.45.94-.95s-.44-.93-.94-.93h-1a3.22 3.22 0 0 0-1.13-1.13L14.62 6a2.86 2.86 0 0 0-3.87 1.06c-1.13 1.81.31 3.19.87 3.75l.5.44H2.87c-1.56 0-2.87 1.3-2.87 2.87s1.31 2.81 2.87 2.81h4.38c-.06.32-.13.63-.13 1a2.85 2.85 0 0 0 2.63 2.82 2.85 2.85 0 0 0 2.75 3.75h.25c-.06.31-.13.56-.13.87a2.9 2.9 0 0 0 2.88 2.88h6c1.25 0 2.94-.63 4.37-1.13 1-.37 2.07-.75 2.5-.75H30c.5 0 .94-.44.94-.94z',
            'hand-point-down' => 'M25.88 21.25a2.8 2.8 0 0 0 1.06-3.81L20.75 4.06c-.25-.5-.63-.81-1.06-1.12V2c0-.5-.44-.94-.94-.94s-.94.44-.94.94v1.62c0 .38.31.75.69.88.25.06.5.25.56.37l6.19 13.38c.31.5.13 1.12-.31 1.44-.25.12-.57.31-1.44-.57l-2.06-2.3c-.32-.26-.7-.38-1.07-.2-.37.13-.56.44-.56.88v11.62c0 .57-.44 1-1 1a.97.97 0 0 1-.94-1v-6.87c0-.5-.37-.88-.87-.94-.5 0-.94.38-1 .81-.07.5-.5.88-1 .88s-.94-.44-.94-1v-2.38c0-.5-.38-.93-.88-.93a.97.97 0 0 0-1 .87c0 .56-.43.94-.93.94s-.94-.44-.94-1v-2.94c0-.5-.44-.94-.94-.94-.5 0-.94.38-.94.88s-.31 1-.87 1c-.5 0-1-.44-1-1v-6c0-.94.56-2.44 1.06-3.75s.88-2.38.88-3.13V2c0-.5-.44-.94-1-.94-.5 0-.94.44-.94.94v1.62c0 .44-.38 1.5-.7 2.5-.55 1.44-1.18 3.13-1.18 4.38v6a2.9 2.9 0 0 0 3.75 2.75v.25a2.82 2.82 0 0 0 2.81 2.87c.38 0 .7-.06.94-.12A2.85 2.85 0 0 0 15 24.87c.37 0 .68 0 1-.12v4.37c0 1.56 1.25 2.88 2.8 2.88s2.88-1.32 2.88-2.88v-9.25l.5.56c.5.5 1.88 1.94 3.7.82z',
            'gallery' => 'M24.5 18.81v5.7H0V0h24.5v18.8zM1.87 1.88v15.06H3.2L9.94 5.69 14.19 13l2.12-2.31 4.88 6.25h1.37V1.87H1.88zm16.94 15.06-2.62-3.38-2.38 2.57-3.94-6.75-4.5 7.56h13.44zM1.88 22.56h20.68v-3.75H1.88v3.75zM32 5.63h-5.63V7.5h3.75v20.75H9.45v-1.88H7.5v3.75H32V5.63z',
            'face-smile' => 'M16 0c8.81 0 16 7.19 16 16s-7.19 16-16 16S0 24.81 0 16 7.19 0 16 0zm0 30.13a14.12 14.12 0 1 0 .02-28.24A14.12 14.12 0 0 0 16 30.13zm8.5-13.2c0-.5-.44-.93-1-.93-.5 0-.94.44-.94.94a6.56 6.56 0 1 1-13.12 0c0-.5-.44-.94-.94-.94-.56 0-1 .44-1 .94a8.5 8.5 0 0 0 17 0zm-16-6.55c0 1 .81 1.87 1.88 1.87 1 0 1.87-.87 1.87-1.87 0-1.07-.88-1.88-1.88-1.88-1.06 0-1.87.81-1.87 1.88zm11.25 0c0 1 .88 1.87 1.88 1.87 1.06 0 1.87-.87 1.87-1.87 0-1.07-.81-1.88-1.88-1.88-1 0-1.87.81-1.87 1.88z',
            'face-sad' => 'M16 0c8.81 0 16 7.19 16 16s-7.19 16-16 16S0 24.81 0 16 7.19 0 16 0zm0 30.13a14.12 14.12 0 1 0 .02-28.24A14.12 14.12 0 0 0 16 30.13zm8.5-5.63a8.5 8.5 0 0 0-17 0c0 .5.44.94 1 .94.5 0 .94-.44.94-.94 0-3.69 2.94-6.63 6.56-6.63s6.56 2.94 6.56 6.63c0 .5.44.94.94.94.56 0 1-.44 1-.94zm-16-14.13c0 1 .81 1.88 1.88 1.88 1 0 1.87-.88 1.87-1.88 0-1.06-.88-1.87-1.88-1.87-1.06 0-1.87.81-1.87 1.88zm11.25 0c0 1 .88 1.88 1.88 1.88 1.06 0 1.87-.88 1.87-1.88 0-1.06-.81-1.87-1.88-1.87-1 0-1.87.81-1.87 1.88z',
            'credit-card' => 'M29.19 3.75A2.84 2.84 0 0 1 32 6.56v18.88c0 1.5-1.25 2.81-2.81 2.81H2.8A2.84 2.84 0 0 1 0 25.44V6.56c0-1.5 1.25-2.81 2.81-2.81H29.2zm.93 21.69V15.06H1.88v10.38c0 .5.44.94.94.94H29.2c.5 0 .94-.44.94-.94zm-28.25-16h28.25V6.56c0-.5-.43-.93-.93-.93H2.8c-.5 0-.94.43-.94.93v2.88z',
            'control-skip-forward' => 'M5.63 27.44V4.56l13.75 11.38zM7.5 8.56v14.82l8.94-7.44zm18.88-4.81H24.5v24.5h1.88V3.75z',
            'control-skip-backward' => 'm12.63 16.06 13.74-11.5v22.88zm11.87 7.38V8.62l-8.94 7.44zM5.62 3.75v24.5H7.5V3.75H5.62z',
            'control-record' => 'M16 4.69a11.31 11.31 0 1 1 0 22.62 11.31 11.31 0 0 1 0-22.62zm0 20.75c5.19 0 9.44-4.25 9.44-9.44S21.19 6.56 16 6.56 6.56 10.81 6.56 16s4.25 9.44 9.44 9.44z',
            'control-eject' => 'm15.94 5.13 11.5 13.68H4.56zm0 2.93-7.38 8.88h14.82zM28.25 24.5H3.75v1.88h24.5V24.5z',
            'comments-smiley' => 'M24.5 15.06c0 3.63-3 6.57-6.63 6.57s-6.56-2.94-6.56-6.57H9.44c0 4.7 3.75 8.44 8.44 8.44s8.5-3.75 8.5-8.44H24.5zm-10.38-2.81a1.88 1.88 0 0 1-1.87-1.88c0-1.06.81-1.87 1.88-1.87S16 9.31 16 10.38c0 1-.81 1.87-1.88 1.87zm7.5 0c-1 0-1.87-.88-1.87-1.88 0-1.06.88-1.87 1.88-1.87 1.06 0 1.87.81 1.87 1.88 0 1-.81 1.87-1.88 1.87zM32 14.13A14.1 14.1 0 0 0 17.87 0 14.15 14.15 0 0 0 3.76 14.13c0 2.5.69 5 2 7.12L.37 31.63l10.38-5.38c2.13 1.31 4.63 2 7.13 2 7.8 0 14.12-6.38 14.12-14.13zm-1.88 0c0 6.74-5.5 12.24-12.25 12.24a12.1 12.1 0 0 1-6.62-2l-.44-.25-6.06 3.13 3.12-6.06-.25-.44c-1.3-2-2-4.31-2-6.63 0-6.75 5.5-12.25 12.25-12.25s12.25 5.5 12.25 12.25z',
            'brush-alt' => 'M32 14.19v6.56h-1.75L31.69 32H.3l1.44-11.25H0V14.2a2.8 2.8 0 0 1 2.81-2.81h9.07L11.3 9.3V2.8A2.8 2.8 0 0 1 14.13 0h3.75a2.8 2.8 0 0 1 2.81 2.81v6.82l-.56 1.75h9.06a2.8 2.8 0 0 1 2.81 2.8zm-2.44 15.94-1.18-9.38H3.63l-1.2 9.38h3.2v-3.75H7.5v3.75h9.44v-7.57h1.87v7.57h1.88V24.5h1.87v5.63h1.94v-3.75h1.88v3.75h3.18zM2 18.88h28.13v-4.7c0-.5-.44-.93-.94-.93H17.56l1.25-4.06V2.8c0-.5-.44-.94-.94-.94h-3.75c-.5 0-.93.44-.93.94v6.4l1.25 4.06H2.8c-.5 0-.94.44-.94.94v4.68H2zM15.06 3.74v1.88h1.88V3.75h-1.88z',
            'youtube' => 'M15.63 12.06c-.82 0-1.44-.25-1.88-.87-.31-.5-.5-1.19-.5-2.13V5.94c0-.94.19-1.63.5-2.07.44-.62 1.06-.93 1.88-.93s1.43.31 1.87.93c.38.44.5 1.13.5 2.07v3.12c0 .94-.13 1.7-.5 2.13-.44.62-1.06.87-1.88.87zm-.76-6.43v3.75c0 .8.26 1.24.76 1.24.56 0 .74-.43.74-1.24V5.62c0-.8-.18-1.25-.75-1.25-.5 0-.74.44-.74 1.25zm4.63 5.8c.13.45.5.63 1.06.63s1.2-.31 1.82-1.06v.94H24V3.06h-1.62v6.82c-.38.5-.7.75-1 .75-.25 0-.38-.13-.38-.38-.06-.06-.06-.25-.06-.62V3.06H19.3v7c0 .7.07 1.13.2 1.38zm6.19 10.82c0-.81-.32-1.25-.82-1.25-.56 0-.8.44-.8 1.25v.81h1.62v-.81zM8.19 3.31c.56 1.7.94 2.94 1.12 3.82v4.8h1.75v-4.8L13.26 0h-1.82l-1.25 4.7L8.94 0H7.06c.38 1.13.75 2.25 1.13 3.31zm20.56 13.25c.5 2 .5 4.13.5 6.25 0 2-.06 4.25-.5 6.25a3.25 3.25 0 0 1-2.81 2.57C22.62 32 19.3 32 16 32s-6.63 0-9.94-.37a3.25 3.25 0 0 1-2.81-2.57c-.5-2-.5-4.25-.5-6.25 0-2.12.06-4.25.5-6.25a3.25 3.25 0 0 1 2.87-2.62c3.25-.38 6.57-.38 9.88-.38s6.62 0 9.94.38a3.25 3.25 0 0 1 2.8 2.62zm-18.44 1.75V16.7H4.75v1.62h1.88v10.2h1.8V18.3h1.88zm4.81 10.19v-8.81h-1.56v6.75c-.37.5-.69.75-1 .75-.25 0-.37-.13-.37-.38-.07-.06-.07-.25-.07-.62v-6.5h-1.56v7c0 .62.06 1 .13 1.25.12.5.5.68 1.06.68s1.19-.37 1.81-1.06v.94h1.56zm6.07-2.63v-3.56c0-.81 0-1.37-.13-1.75-.18-.62-.62-1-1.25-1s-1.18.32-1.68 1V16.7h-1.57v11.8h1.57v-.88c.56.7 1.06 1 1.68 1s1.07-.3 1.25-1c.13-.37.13-.93.13-1.75zm6.06-1.5v-1.8c0-.95-.13-1.63-.5-2.07-.44-.63-1.06-.94-1.88-.94s-1.43.31-1.93.94a3.5 3.5 0 0 0-.5 2.06v3.07c0 .93.18 1.68.56 2.06a2.2 2.2 0 0 0 1.94.94c.81 0 1.5-.32 1.87-.94.25-.32.38-.63.38-1 .06-.13.06-.5.06-1v-.25h-1.62c0 .62 0 1-.07 1.12-.06.38-.31.63-.68.63-.57 0-.82-.44-.82-1.25v-1.57h3.19zm-7.63-2.18c0-.75-.25-1.19-.68-1.19-.25 0-.57.13-.82.44v5.37c.25.25.57.38.82.38.43 0 .68-.38.68-1.19v-3.81z',
            'vimeo' => 'M29.5 5.06c.75 1 1 2.25.69 3.88C29.8 11 27.56 16.75 24 21.63c-2 2.62-4 4.5-6.19 5.8-.75.45-2.12 1-3.37 1-.5 0-.94-.05-1.32-.24-2.56-1.06-3.5-4.88-4.18-7.63l-.25-1.18c-.38-1.32-.7-2.63-1.13-3.75-.12-.32-.19-.7-.31-1-.19-.7-.31-1.32-.69-1.82-.12-.31-.19-.31-.25-.31-.19 0-.5.12-.81.19-.5.19-1.2.37-1.88.31-.81-.12-1.06-.69-1.19-.94-.12-.19-.12-.19-.25-.25a1 1 0 0 1-.5-.87c0-.25.2-.75.38-.94 1-.63 1.81-1.38 2.62-2.13 1.13-1 2.2-2 3.57-2.8.37-.2 1.5-.82 2.81-.82.31 0 .69.06.94.12 1.37.44 2.31 2 2.69 3.2.3 1.05.5 2.24.68 3.24l.13.75c.12.56.19 1.06.19 1.69.19 1.75.37 3.75 1.37 4.75.19.25.38.37.5.37.5 0 1.38-1.5 1.63-2 .56-1.12 1.12-2.25 1.19-3.18.06-.7 0-1.25-.2-1.44-.24-.25-1-.31-2.06-.25a1 1 0 0 1-.8-.38.77.77 0 0 1-.2-.87 10.5 10.5 0 0 1 7.07-6.63c.43-.06.93-.06 1.43-.06 1.75 0 3.07.5 3.88 1.5zm-1.19 3.5c.2-1.06.13-1.81-.31-2.31-.56-.69-1.75-.81-2.38-.81-.43 0-.8 0-1.12.06a8.46 8.46 0 0 0-5.06 4.06c.68.07 1.56.25 2.12.94.63.63.82 1.56.69 2.88s-.75 2.56-1.31 3.68c-.75 1.38-1.75 3.2-3.38 3.2-.69 0-1.31-.32-1.87-.95-1.44-1.5-1.63-3.8-1.82-5.87l-.18-1.56-.13-.7c-.19-1-.37-2.12-.69-3.06-.25-.87-.93-1.8-1.37-1.93-.13 0-.25-.07-.44-.07-.63 0-1.38.32-1.81.57a22.28 22.28 0 0 0-3.32 2.56C5.31 9.81 4.68 10.44 4 11c0 0 .06.06.06.12.31 0 .62-.12.87-.18.44-.13.88-.32 1.38-.32.75 0 1.44.44 1.87 1.2s.7 1.55.88 2.3c.12.25.19.57.31.88.44 1.25.75 2.5 1.13 3.87l.31 1.25c.56 2.38 1.37 5.63 3.06 6.38.7.25 2.2-.19 2.94-.69 2-1.19 3.81-2.94 5.63-5.37 3.68-4.88 5.62-10.38 5.87-11.88z',
            'twitter' => 'M32 6c-.9 1.4-2 2.6-3.3 3.5v.8C28.8 19 22.1 29 10.1 29A18.5 18.5 0 0 1 0 26l1.6.1a13 13 0 0 0 8.1-2.8 6.5 6.5 0 0 1-6-4.6l1.1.2a7.9 7.9 0 0 0 1.8-.2 6.6 6.6 0 0 1-5.3-6.5c.9.4 1.9.7 3 .8a6.6 6.6 0 0 1-3-5.5c0-1.2.4-2.3 1-3.3 3.1 4 8 6.6 13.4 6.9V9.6A6.5 6.5 0 0 1 22 3a6.6 6.6 0 0 1 5 2c1.5-.2 3-.7 4.2-1.5a6.9 6.9 0 0 1-2.9 3.6c1.4-.2 2.6-.5 3.8-1zm-5.1 4.3v-.7c0-.4 0-.7.2-1-.3-.2-.5-.5-.7-1a1.2 1.2 0 0 1 0-.7 2.2 2.2 0 0 1-.8-.5A4.7 4.7 0 0 0 22 4.9a4.7 4.7 0 0 0-4.6 4.7l.1 1c0 .6 0 1.3-.4 1.7a2 2 0 0 1-1.4.6h-.1c-4.6-.2-9-2-12.4-5a4.7 4.7 0 0 0 2 3.5c.7.5 1 1.3.8 2.2a2 2 0 0 1-1.8 1.3H4a4.8 4.8 0 0 0 3 2c.8.1 1.4.9 1.4 1.7S8 20.2 7 20.5a4.7 4.7 0 0 0 2.8 1 1.9 1.9 0 0 1 1 3.3 13.6 13.6 0 0 1-3.5 2c1 .3 1.8.3 2.8.3 11.5 0 16.8-9.8 16.8-16.8z',
            'twitter-alt' => 'M28.7 9.5A13.3 13.3 0 0 0 32 6.1a12.9 12.9 0 0 1-3.8 1 6.9 6.9 0 0 0 3-3.6 12 12 0 0 1-4.3 1.6 6.6 6.6 0 0 0-11.3 4.5c0 .5 0 1 .2 1.5A18.4 18.4 0 0 1 2.2 4.2a6.8 6.8 0 0 0-.9 3.3 6.6 6.6 0 0 0 3 5.5 6.7 6.7 0 0 1-3-.9v.2a6.6 6.6 0 0 0 5.3 6.4 7.9 7.9 0 0 1-1.8.2l-1.2-.1a6.5 6.5 0 0 0 6.2 4.5 13 13 0 0 1-8.2 2.8H0A18.4 18.4 0 0 0 10 29c12.1 0 18.8-10 18.8-18.7l-.1-.8z',
            'time' => 'M16.31 0c8.82 0 16 7.19 16 16s-7.18 16-16 16-16-7.19-16-16 7.2-16 16-16zm0 30.13a14.12 14.12 0 1 0 .03-28.27 14.12 14.12 0 0 0-.04 28.27zm10.06-13.2h-9.43v-7.5h-1.88v9.38h11.31v-1.87z',
            'tumblr' => 'm24.75 23.88 1.44-.94V30l-.5.25c-1.44.69-2.63 1.13-3.69 1.38s-2.31.37-3.63.37c-1.43 0-2.75-.19-3.93-.56-1.13-.38-2.13-.94-3-1.7s-1.5-1.55-1.82-2.43a9.74 9.74 0 0 1-.5-3.44V14.2h-3.3V8.3l.62-.19c1.06-.37 2-.87 2.75-1.5a7.77 7.77 0 0 0 1.75-2.25c.43-.94.8-2.12 1-3.56L12 0h6.06v7.62h7.13v6.56h-7.13V21c0 2.06.13 2.81.25 3.06.07.25.32.5.63.69.5.31 1.06.44 1.81.44a7.4 7.4 0 0 0 4-1.32zm-.44 4.93v-2.56c-2.19 1.06-4.62 1.19-6.37.13a3.4 3.4 0 0 1-1.44-1.7c-.19-.62-.31-1.68-.31-3.68v-8.7h7.12V9.5H16.2V1.87h-2.57a11.53 11.53 0 0 1-1 3.32 8.55 8.55 0 0 1-2.25 2.87A9.62 9.62 0 0 1 7.7 9.7v2.62H11v11.56c0 1.25.13 2.2.38 2.75.2.63.63 1.2 1.25 1.75.7.57 1.5 1 2.38 1.25 1.87.63 4.62.63 6.56.13.82-.19 1.75-.5 2.75-.94z',
            'skype' => 'M30.5 18.69A8.5 8.5 0 0 1 18.69 30.5a14.73 14.73 0 0 1-17.2-17.19A8.5 8.5 0 0 1 13.3 1.5a14.73 14.73 0 0 1 17.2 17.19zm-7 11.43a6.59 6.59 0 0 0 5.25-10.62l-.25-.31.06-.44c.2-.94.32-1.88.32-2.75 0-7.06-5.82-12.88-12.88-12.88-.87 0-1.81.13-2.75.32l-.44.06-.31-.25a6.59 6.59 0 0 0-9.25 9.25l.25.31-.06.44c-.2.94-.32 1.88-.32 2.75a12.9 12.9 0 0 0 15.63 12.56l.44-.06.31.25a6.73 6.73 0 0 0 4 1.38zm.44-10.87c0-3.38-3.32-4.56-6.13-5.19l-2-.5c-1.5-.31-2.62-.56-2.62-1.75 0-1 1.12-1.5 2.81-1.5 3.13 0 3.13 2.25 5.06 2.25 1.25 0 2.07-1 2.07-2.12 0-2.25-3.75-3.7-7.5-3.7-3.38 0-7.32 1.45-7.32 5.45 0 3.31 2.2 4.44 5.07 5.12l2.87.75c1.75.44 2.81.63 2.81 1.88 0 1-1.12 1.75-2.87 1.75-3.63 0-3.81-3-5.88-3-1.37 0-2 .93-2 2.06 0 2.38 3.7 4.38 8.13 4.38 3.69 0 7.5-1.88 7.5-5.88z',
            'share' => 'm12.81 25.19 1.25-1.32a8.5 8.5 0 0 1 5.81-14.69h5.44l-4.93 5 1.3 1.32 7.26-7.25L21.69 1l-1.32 1.31 4.94 5h-5.43A10.34 10.34 0 0 0 9.5 17.63c0 2.87 1.19 5.62 3.31 7.56zM30.2 17h1.87v12.19A2.8 2.8 0 0 1 29.25 32H2.94a2.85 2.85 0 0 1-2.88-2.8V17H2v12.19c0 .5.38.94.94.94h26.31c.56 0 .94-.44.94-.94V17z',
            'share-alt' => 'm10.38 15.5 1.37-1.31-5-5h5.5a8.48 8.48 0 0 1 8.44 8.44c0 2.37-.94 4.62-2.69 6.18l1.31 1.38A10.32 10.32 0 0 0 12.25 7.3h-5.5l5-5L10.37 1 3.13 8.25zM30.11 17H32v12.19A2.8 2.8 0 0 1 29.19 32H2.8A2.8 2.8 0 0 1 0 29.2V17h1.87v12.19c0 .5.44.94.94.94H29.2c.5 0 .93-.44.93-.94V17z',
            'rocket' => 'M22.56 20.69s3.82 0 3.82 11.31c0 0-4.5-4.5-8.13-5.44 0 1.07-.62 1.94-1.31 1.94s-1.32-.87-1.32-1.94C12 27.5 7.5 32 7.5 32c0-11.31 3.81-11.31 3.81-11.31V9.44C11.31 0 16.94 0 16.94 0s5.62 0 5.62 9.44v11.25zM16.94 1.87c-.5.07-3.13.5-3.69 5.63h7.37c-.56-5.13-3.18-5.56-3.68-5.63zm0 22.63c2.37 0 5.19 1.63 7.31 3.19-.5-4-1.62-4.94-1.87-5.13h-1.7V9.44h-7.5v13.12H11.5c-.25.2-1.38 1.13-1.88 5.13 2.13-1.56 4.94-3.19 7.32-3.19z',
            'pinterest' => 'M28.31 11.69c0-5.38-4.62-10.44-11.62-10.44C8 1.25 3.62 7.5 3.62 12.69c0 3.12 1.25 5.94 3.75 7 .44.12.82 0 .94-.5.07-.31.25-1.13.38-1.44.12-.5.06-.62-.25-1a5.4 5.4 0 0 1-1.25-3.62c0-4.63 3.44-8.75 9-8.75 4.94 0 7.62 3 7.62 7 0 5.25-2.31 9.75-5.81 9.75a2.88 2.88 0 0 1-2.87-3.57c.56-2.31 1.62-4.81 1.62-6.44 0-1.5-.81-2.8-2.5-2.8-1.94 0-3.5 2.05-3.5 4.74 0 0 0 1.75.56 2.94-2 8.44-2.31 9.94-2.31 9.94a13.85 13.85 0 0 0-.31 4.18s.18 2.2 2.12.75c.69-1.06 1.5-2.5 1.88-3.87 0 0 .18-.81 1.25-5 .62 1.19 2.5 2.25 4.5 2.25 5.87 0 9.87-5.31 9.87-12.56z',
            'new-window' => 'M28.25 3.75H14.12v1.88h11.13L7.44 23.43l1.37 1.38L26.37 7.2v10.69h1.88V3.75zm-7.56 26.38V17.5h1.87V32H0V9.44h14.25v1.87H1.87v18.81H20.7z',
            'microsoft' => 'M14.56 29.63V16.88H32V32zm1.88-10.88v9.19l13.69 1.87V18.75h-13.7zM0 27.63V16.88h13.13v12.5zm1.88-8.88v7.19l9.37 1.31v-8.5H1.87zM0 15.25V4.37l13.13-1.75v12.63H0zm1.88-9.19v7.32h9.37V4.75zm12.68-3.68L32 0v15.25H14.56V2.37zm15.56 11V2.18L16.45 4.07v9.32h13.69z',
            'list-ol' => 'M32 7.5H9.44v1.94H32V7.5zM9.44 16.94v-1.88H32v1.88H9.44zm0 7.56v-1.94H32v1.94H9.44zM3.94 6.56l-.94.5-.12-.56L4 5.87h.63v5.2h-.7v-4.5zM3.06 18v.06h2.32v.57H2.13v-.44l.56-.57c1.25-1.18 1.87-1.87 1.87-2.68 0-.5-.25-1-1-1-.5 0-.87.25-1.12.43l-.19-.43c.38-.32.88-.57 1.44-.57 1.12 0 1.56.75 1.56 1.5 0 .94-.69 1.75-1.75 2.75zm1.13 5.31c.62.13 1.19.63 1.19 1.32 0 .8-.7 1.56-1.88 1.56-.56 0-1.12-.19-1.37-.38l.18-.5c.25.13.7.32 1.2.32.87 0 1.12-.57 1.12-1 0-.7-.63-1-1.32-1h-.37v-.57h.37c.5 0 1.13-.25 1.13-.87 0-.38-.25-.75-.88-.75-.43 0-.8.19-1.06.31l-.12-.5c.25-.19.75-.37 1.3-.37 1 0 1.5.62 1.5 1.25 0 .5-.37.93-1 1.18z',
            'linkedin' => 'M1.3 11v19.4h6.5V10.9H1.3zm3.3-9.4c2.2 0 3.6 1.5 3.6 3.3S6.8 8.3 4.6 8.3h-.1C2.3 8.3.9 6.8.9 5s1.5-3.3 3.7-3.3zm19 8.9c4.3 0 7.5 2.8 7.5 8.7v11.2h-6.5V20c0-2.6-1-4.4-3.3-4.4-1.7 0-2.8 1.2-3.3 2.3l-.2 1.7v10.8h-6.4V10.9h6.4v2.9a6.3 6.3 0 0 1 5.8-3.3z',
            'layout-sidebar-2' => 'M32 0h-7.5v32H32V0zM0 32V0h5.63v32H0zm20.69 0v-1.88h1.87V32H20.7zm-6.44 0v-1.88h1.63V32h-1.63zm3.25 0v-1.88h1.56V32H17.5zM11 32v-1.88h1.63V32H11zm-3.5 0v-1.88h1.94V32H7.5zm0-26.38V3.75h1.94v1.88H7.5zm0 18.88v-1.94h1.94v1.94H7.5zm0 3.75v-1.88h1.94v1.88H7.5zm0-7.56V18.8h1.94v1.88H7.5zm0-7.5V11.3h1.94v1.88H7.5zm0-3.75V7.5h1.94v1.94H7.5zm0 7.5v-1.88h1.94v1.88H7.5zm0-15.07V0h1.94v1.88H7.5zm3.5 0V0h1.63v1.88H11zm6.5 0V0h1.56v1.88H17.5zm-3.25 0V0h1.63v1.88h-1.63zm6.44 0V0h1.87v1.88H20.7zm0 7.57V7.5h1.87v1.94H20.7zm0-3.82V3.75h1.87v1.88H20.7zm0 7.57V11.3h1.87v1.88H20.7zm0 3.75v-1.88h1.87v1.88H20.7zm0 11.31v-1.88h1.87v1.88H20.7zm0-3.75v-1.94h1.87v1.94H20.7zm0-3.81V18.8h1.87v1.88H20.7z',
            'layout-grid4-alt' => 'M1.88 1.88V7.5H7.5V1.87H1.87zM9.43 7.5V1.87h5.62V7.5H9.44zm7.5 0V1.87h5.62V7.5h-5.62zm7.56-5.63h5.63V7.5H24.5V1.87zM1.87 15.07V9.43H7.5v5.62H1.87zm7.57 0V9.43h5.62v5.62H9.44zm7.5 0V9.43h5.62v5.62h-5.62zm7.56 0V9.43h5.63v5.62H24.5zm-22.63 7.5v-5.63H7.5v5.62H1.87zm7.57 0v-5.63h5.62v5.62H9.44zm7.5 0v-5.63h5.62v5.62h-5.62zm7.56 0v-5.63h5.63v5.62H24.5zM1.87 30.11V24.5H7.5v5.63H1.87zm7.57 0V24.5h5.62v5.63H9.44zm7.5 0V24.5h5.62v5.63h-5.62zm7.56 0V24.5h5.63v5.63H24.5z',
            'layout-grid3-alt' => 'M0 0v9.44h9.44V0H0zm11.31 9.44V0h9.38v9.44H11.3zM22.56 0H32v9.44h-9.44V0zM0 20.69V11.3h9.44v9.38H0zm11.31 0V11.3h9.38v9.38H11.3zm11.25 0V11.3H32v9.38h-9.44zM0 32v-9.44h9.44V32H0zm11.31 0v-9.44h9.38V32H11.3zm11.25 0v-9.44H32V32h-9.44z',
            'layout-grid2-alt' => 'M0 0v13.19h13.19V0H0zm16.94 0h13.19v13.19h-13.2V0zM0 30.13v-13.2h13.19v13.2H0zm16.94 0v-13.2h13.19v13.2h-13.2z',
            'layout-column4-alt' => 'M1.88 0v32H7.5V0H1.87zm7.56 32V0h5.62v32H9.44zm7.5 0V0h5.62v32h-5.62zM24.5 0h5.63v32H24.5V0z',
            'layout-column3-alt' => 'M0 0v32h9.44V0H0zm11.31 32V0h9.38v32H11.3zM22.56 0H32v32h-9.44V0z',
            'layout-column2-alt' => 'M0 0v32h15.06V0H0zm16.94 0H32v32H16.94V0z',
            'instagram' => 'M24.5 0C28.63 0 32 3.38 32 7.5v17c0 4.13-3.38 7.5-7.5 7.5h-17A7.52 7.52 0 0 1 0 24.5v-17C0 3.37 3.38 0 7.5 0h17zm5.63 24.5V13.19h-6.07c.57 1.12.88 2.37.88 3.75a8.94 8.94 0 1 1-17.88 0c0-1.38.31-2.63.88-3.75H1.87V24.5a5.68 5.68 0 0 0 5.63 5.63h17a5.68 5.68 0 0 0 5.62-5.63zm-7.07-7.56c0-3.88-3.19-7.07-7.06-7.07s-7.06 3.2-7.06 7.07S12.13 24 16 24s7.06-3.19 7.06-7.06zm-.18-5.63h7.25V7.5a5.68 5.68 0 0 0-5.63-5.63h-17A5.68 5.68 0 0 0 1.87 7.5v3.81h7.25C10.75 9.31 13.25 8 16 8s5.25 1.31 6.88 3.31zm4.3-6.19c0-.56-.43-1-1-1h-2.56c-.56 0-1.06.44-1.06 1v2.44c0 .57.5 1 1.07 1h2.56c.56 0 1-.44 1-1V5.13z',
            'google' => 'M32 4.94h-4.94V0h-2.44v4.94H19.7v2.44h4.93v4.93h2.44V7.38H32V4.94zM19.56 24.06c0-5.37-5.75-6.37-5.75-8.87s4.32-2.88 4.32-8c0-2.13-1-4.5-2.88-5.69h2.56L20.44 0H12c-1.19 0-2.37.13-3.56.38-3.5.74-6.32 3.87-6.32 7.56 0 3.87 3.2 6.62 6.94 6.62.44 0 .88-.06 1.32-.12-.2.62-.38 1-.38 1.69 0 1.06.56 2 1.19 2.8-3.44.13-8.75 1-10.5 4.45A6.56 6.56 0 0 0 0 26c0 4.44 5.19 6 8.81 6 2.82 0 5.82-.62 8.07-2.5 1.62-1.44 2.69-3.25 2.69-5.44zm-5-14.94c0 2.38-.94 4.25-3.56 4.25-3.44 0-5.31-4.56-5.31-7.5 0-2.25 1.18-4.5 3.68-4.5 3.57 0 5.2 4.82 5.2 7.75zm2.31 16.57c0 3.37-3.25 4.56-6.06 4.56-3.12 0-7.25-1.44-7.25-5.12 0-4 4.69-5 7.82-5h1c1.93 1.37 4.5 2.87 4.5 5.56z',
            'github' => 'M24.63 20.94c0-1.44-.75-3.69-2.5-3.69-1.7 0-2.44 2.25-2.44 3.69 0 1.37.75 3.69 2.44 3.69 1.75 0 2.5-2.32 2.5-3.7zM9.88 17.25c1.68 0 2.43 2.25 2.43 3.69 0 1.37-.75 3.69-2.44 3.69-1.74 0-2.5-2.32-2.5-3.7 0-1.43.75-3.68 2.5-3.68zm22.12.31c0-2.81-.75-5.5-2.63-7.68.38-1 .5-2.13.5-3.26 0-1.43-.3-2.87-.93-4.18-3 0-4.94 1.31-7.25 3.12a22.15 22.15 0 0 0-5.38-.62c-2 0-4 .18-5.94.68-2.3-1.8-4.25-3.18-7.3-3.18a9.75 9.75 0 0 0-.95 4.18c0 1.13.13 2.25.5 3.32C.75 12.06 0 14.75 0 17.56c0 2.13.19 4.38 1.19 6.32 2.62 5.25 10.06 5.68 15.12 5.68 5 0 12-.5 14.5-5.68 1-1.94 1.19-4.2 1.19-6.32zm-4.31 3.38c0 5.87-5.38 6.75-10.07 6.75h-3.25c-4.68 0-10.06-.88-10.06-6.75 0-2.94 1.81-5.57 4.94-5.57 1.25 0 2.5.26 3.75.44a24.16 24.16 0 0 0 6 0c1.31-.18 2.5-.43 3.75-.43 3.13 0 4.94 2.62 4.94 5.56z',
            'flickr' => 'M13.75 16a6.9 6.9 0 0 0-6.88-6.88 6.88 6.88 0 0 0 .01 13.76A6.9 6.9 0 0 0 13.75 16zM32 16a6.86 6.86 0 0 0-6.88-6.88c-3.75 0-6.87 3.07-6.87 6.88s3.13 6.88 6.88 6.88A6.86 6.86 0 0 0 32 16zm-1.88 0c0 2.75-2.25 5-5 5s-5-2.25-5-5 2.25-5 5-5 5 2.25 5 5z',
            'facebook' => 'M23.44 10.5h-5V7.75c0-1.44.19-2.25 2.25-2.25h2.75V0H19c-5.31 0-7.13 2.69-7.13 7.19v3.31h-3.3V16h3.3v16h6.57V16h4.44z',
            'dropbox' => 'm31.75 8.25-5.88 4.63 5.88 4.68-6.44 4.2v2.93L16 30.19l-9.25-5.5V21.8l-6.5-4.25 5.87-4.68L.25 8.25l10-6.5L16 6.5l5.75-4.75zm-9.88-4.19-4.25 3.57 6.7 4.12 4.18-3.37zm.7 8.81L16 8.82l-6.56 4.06L16 16.95zM3.5 8.38l4.19 3.38 6.69-4.13-4.25-3.56zm0 9 6.63 4.38 4.24-3.56-6.68-4.13zm19.94 6.25V23l-1.69 1.06L16 19.31l-5.75 4.75L8.62 23v.63L16 28zm5.06-6.25-4.19-3.3-6.69 4.12 4.25 3.56z',
            'dribbble' => 'M16 0c8.81 0 16 7.19 16 16s-7.19 16-16 16S0 24.81 0 16 7.19 0 16 0zm14.13 16.25V16c0-3.44-1.25-6.63-3.38-9.13-2.31 2.57-5.38 4.32-8.56 5.57.62 1.25 1.12 2.44 1.62 3.62 2.94-.62 6.38-.68 10.31.2zm-4.7-10.69a13.83 13.83 0 0 0-13.37-3.12 52.6 52.6 0 0 1 5.31 8.25 20.7 20.7 0 0 0 8.07-5.13zM10.26 3.13a14.38 14.38 0 0 0-8.13 10.12c2.2 0 7.82-.19 13.44-1.94a49.39 49.39 0 0 0-5.31-8.19zM1.87 16c0 3.69 1.44 7.06 3.82 9.63 1.44-2.13 5.5-7 12.25-9.13a53.01 53.01 0 0 0-1.5-3.44A48.77 48.77 0 0 1 2.3 15.2c-.12 0-.25 0-.37-.07 0 .32-.06.57-.06.88zm5.2 10.94c2.43 2 5.56 3.19 8.93 3.19 2 0 3.88-.44 5.56-1.2a58.31 58.31 0 0 0-2.93-10.62 22.17 22.17 0 0 0-11.57 8.63zm16.24 1.12c3.5-2.12 6-5.75 6.63-9.93a22.1 22.1 0 0 0-9.44-.25 64.65 64.65 0 0 1 2.81 10.18z',
            'apple' => 'M26.4 21a6 6 0 0 0 3 2.4 18 18 0 0 1-2.4 4.8c-1.6 2.5-3.3 3.7-5 3.7-.6 0-1.4-.1-2.6-.6-1.2-.4-2.2-.6-2.9-.6s-1.7.2-2.8.7-1.8.6-2.5.6c-2 0-3.9-1.7-5.8-5s-2.8-6.5-2.8-9.6c0-3 .7-5.4 2.1-7.3a6.8 6.8 0 0 1 5.5-2.7c1 0 2.1.2 3.4.5a11 11 0 0 0 2.7.7c.6 0 1.4-.3 2.8-.7 1.2-.5 2.3-.6 3.3-.6 1.5 0 2.8.3 4.1 1.2a13.5 13.5 0 0 1 2 1.9c-1 .9-1.8 1.6-2.3 2.3a6.8 6.8 0 0 0-1.2 4c0 1.5.5 3 1.4 4.2zm-1 6.1a15.7 15.7 0 0 0 1.6-2.8 8.7 8.7 0 0 1-2.2-2.3 9 9 0 0 1 1-11.7l-.4-.2a5 5 0 0 0-3-1c-.7 0-1.6.2-2.8.6-1.4.5-2.5.7-3.3.7-.5 0-1.2 0-3.2-.7-1.2-.3-2.1-.5-2.9-.5-1.6 0-2.8.7-4 2.1a9.6 9.6 0 0 0-1.7 6c0 2.8.8 5.7 2.6 8.8 1.5 2.6 3 4 4.2 4 0 0 .6 0 1.7-.5a9 9 0 0 1 3.5-.8c1 0 2.3.3 3.6.8l2 .5c.9 0 2-1.1 3.3-3zM17.8 7.4a5 5 0 0 0 2-1.3c.8-.8 1.4-1.7 1.8-2.7s.6-1.8.6-2.6V.4L22 0c-2.3.5-4 1.4-4.9 2.9-1 1.4-1.4 3-1.4 5l2-.5z',
            'android' => 'M7.19 10.75v12.81a2.1 2.1 0 0 0 2.12 2.07h1.38l.06 4.37a1.97 1.97 0 1 0 3.94 0v-4.37h2.62V30c0 1.13.88 2 2 2s2-.87 2-2v-4.37h1.44c1.13 0 2.06-.94 2.06-2.07V10.75H7.2zm-2.75-.38c1.06 0 1.94.88 1.94 1.94v8.25c0 1.13-.82 2-1.94 2s-2-.87-2-2v-8.25c0-1.06.87-1.93 2-1.93zM24.88 10c0-3-1.82-5.69-4.5-7.06l1.37-2.5c.06-.2 0-.32-.13-.44-.12-.06-.3 0-.37.12L19.87 2.7c-1.18-.5-2.5-.82-3.87-.82s-2.69.32-3.88.82L10.75.12c-.06-.12-.25-.18-.38-.12-.12.12-.18.25-.12.44l1.38 2.5A8.1 8.1 0 0 0 7.05 10h17.81zm-12.2-3.94c0 .44-.3.75-.74.75a.76.76 0 0 1-.75-.75.8.8 0 0 1 .75-.75c.44 0 .75.38.75.75zm8.13 0c0 .44-.37.75-.75.75a.72.72 0 0 1-.75-.75c0-.37.32-.75.75-.75a.8.8 0 0 1 .75.75zm6.75 4.32c1.13 0 2 .87 2 1.93v8.25c0 1.13-.87 2-2 2a1.96 1.96 0 0 1-1.93-2v-8.25c0-1.06.87-1.93 1.93-1.93z',
            'save' => 'M26.7 0 32 5.3v23.9a2.8 2.8 0 0 1-2.8 2.8H2.8A2.8 2.8 0 0 1 0 29.2V2.8A2.8 2.8 0 0 1 2.8 0h23.9zM15 1.9H7.5v9.4h15V2h-1.8v7.5h-5.6V2zM5.6 30h20.8V18.8H5.6v11.3zm24.5-1V6L26 1.9h-1.4v11.3h-19V1.9H2.8a1 1 0 0 0-1 1v26.3c0 .5.5 1 1 1h1V16.8h24.5V30h.9c.5 0 1-.4 1-.9z',
            'save-alt' => 'M29.2 0A2.8 2.8 0 0 1 32 2.8v26.4a2.8 2.8 0 0 1-2.8 2.8H2.8A2.8 2.8 0 0 1 0 29.2v-24L5.3 0h23.9zm-4.7 1.9h-15v3.7h15V2zM5.6 30h20.8v-1.9H5.6v2zm24.5-1V2.9c0-.5-.4-1-1-1h-2.7v5.7H7.5V1.9H6.1L2 6v23.2c0 .5.4 1 1 1h.9v-3.8h24.4V30h1c.5 0 1-.4 1-1zM16 9.5a6.6 6.6 0 1 1 0 13.2 6.6 6.6 0 0 1 0-13.2zm0 11.3c2.6 0 4.7-2 4.7-4.7s-2-4.7-4.7-4.7-4.7 2-4.7 4.7 2 4.7 4.7 4.7z',
            'yahoo' => 'm17.88 31.06-.25-12.81c2.12-3.69 4.25-7.38 6.43-11 1.25-2.13 2.44-4.31 3.88-6.31-.69.19-1.38.25-2.07.25s-1.3-.07-1.93-.25C21.5 5.44 18.69 9.8 16 14.19 13.3 9.8 10.56 5.44 8.06.94c-.69.12-1.37.25-2.06.25A6.9 6.9 0 0 1 4.06.94c3.75 5.62 6.88 11.5 10.25 17.31l-.25 12.81a10.18 10.18 0 0 1 3.81 0z',
            'wordpress' => 'M31.06 16a15.07 15.07 0 1 0-30.14.02A15.07 15.07 0 0 0 31.06 16zm-.68 0a14.38 14.38 0 1 1-28.76 0 14.38 14.38 0 0 1 28.75 0zm-26.2-5.25A13.39 13.39 0 0 0 3.07 16c0 5.13 3 9.5 7.32 11.63zm19.57 8.75c.5-1.75 1-3.06 1-4.13 0-1.62-.56-2.74-1.06-3.56-.7-1.12-1.32-2-1.32-3.06 0-1.19.94-2.25 2.2-2.25h.18A12.9 12.9 0 0 0 5.19 8.94h.87s1.31 0 3.44-.2c.69-.06.75 1 .06 1.07s-1.5.13-1.5.13l4.75 14 2.82-8.5-2-5.5-1.38-.13s-.62-1.12.06-1.06c2.2.19 3.44.19 3.44.19s1.32 0 3.44-.2c.69-.06.75 1 .06 1.07s-1.5.13-1.5.13l4.7 13.87zM20.19 28l-4-10.88-3.82 11.25a12.52 12.52 0 0 0 7.94-.19c-.06-.06-.12-.12-.12-.18zm8.75-12c0-2.25-.63-4.38-1.63-6.19.07.38.13.82.13 1.32 0 1.3-.38 2.75-1 4.62L22.5 27.19A13.05 13.05 0 0 0 28.94 16z',
            'vimeo-alt' => 'M30.38 4.31c.75 1 .8 2.32.56 3.57-.38 1.8-2.63 8.18-6.82 13.8A23.69 23.69 0 0 1 17.5 28c-1 .56-3 1.31-4.31.75-2.63-1.06-3.5-5.56-4.25-8.56a46.42 46.42 0 0 0-1.44-4.94c-.38-1.19-.56-2.37-1.19-3.44-1.06-1.75-2.56-.06-4.12-.25-.7-.12-.38-.81-1.25-1.25v-.18c2.56-1.82 4.3-4 6.87-5.5.88-.5 2.25-1 3.44-.7 1 .32 1.87 1.76 2.25 2.88.44 1.38.69 3.07.94 4.38.37 2.37.25 5.94 2 7.81 1.94 2.06 3.37-.81 4.19-2.25A11.3 11.3 0 0 0 22 12.94c.25-2.88-1.12-3.25-3.75-3.07a10.7 10.7 0 0 1 7.13-6.75c1.62-.25 3.87-.18 5 1.2z',
            'tumblr-alt' => 'M17.13.94H12.8a12.5 12.5 0 0 1-1 3.87 9.1 9.1 0 0 1-2.06 2.57 9.23 9.23 0 0 1-3 1.62v4.25h3.31v10.63c0 1.3.13 2.37.44 3.12.25.75.81 1.44 1.56 2.06a6.92 6.92 0 0 0 2.7 1.44c1.05.38 2.24.56 3.62.56 1.25 0 2.37-.12 3.43-.37 1-.25 2.2-.69 3.44-1.25v-4.75c-1.5 1-3 1.5-4.5 1.5a4.7 4.7 0 0 1-2.31-.63c-.5-.3-.88-.68-1-1.18-.25-.5-.31-1.63-.31-3.38v-7.75h7.12V8.56h-7.12V.94z',
            'trello' => 'M31.06 29.81V2.2c0-.69-.56-1.25-1.25-1.25H2.2C1.5.94.94 1.5.94 2.19V29.8c0 .7.56 1.25 1.25 1.25H29.8c.7 0 1.25-.56 1.25-1.25zM14.75 4.7v20.1c0 .32-.25.63-.63.63H4.7a.67.67 0 0 1-.63-.63V4.7c0-.32.32-.63.63-.63h9.44c.37 0 .62.32.62.63zm13.19 0v12.56c0 .38-.31.63-.63.63h-9.43c-.38 0-.63-.25-.63-.63V4.7c0-.32.25-.63.63-.63h9.43c.32 0 .63.32.63.63z',
            'stack-overflow' => 'M23.81 30.44V18.69h-2v10.37H6.25V18.7H4.19v12.37H23.8v-.62zm-4-3.44v-2.5H7.88v2.56zm.25-5.75L8.25 20.12 8 22.7l11.88 1.06zm.82-3.31L9.38 14.8l-.63 2.5 11.44 3.07zm1.5-2.94L12.13 9l-1.32 2.19 10.25 6zm2.5-1.75-6.7-9.81-2.12 1.43 6.69 9.82zm2.93-.56L25.75.94l-2.5.44 2.06 11.68z',
            'soundcloud' => 'm1.69 19.06-.32-1.68c0-.07 0-.07-.12-.07-.06 0-.06 0-.06.07l-.25 1.68.25 1.7c0 .05 0 .05.12.05.07 0 .07 0 .07-.06zm1.19 0-.38-2.68c0-.07-.06-.13-.13-.13s-.12.06-.12.13L2 19.05l.25 2.63c0 .12.06.12.13.12s.12 0 .12-.06zm1.18 0-.31-3.19c0-.12-.06-.18-.19-.18-.06 0-.12.06-.12.18l-.32 3.2.32 3.12c0 .06.06.12.12.12.13 0 .19-.06.19-.12zm1.19 0-.31-3.31c0-.06-.07-.13-.2-.13-.05 0-.12.07-.12.13l-.3 3.31.3 3.2c0 .12.07.18.13.18.12 0 .19-.06.19-.19zm1.19 0L6.19 16c0-.06-.13-.19-.19-.19-.13 0-.25.13-.25.19l-.25 3.06.25 3.25c0 .07.13.2.25.2.06 0 .19-.13.19-.2zm1.25 0-.25-4.93c0-.13-.13-.26-.25-.26s-.25.13-.25.26l-.25 4.93.25 3.25c0 .13.12.2.25.2s.25-.07.25-.2zm1.18.07L8.63 13c0-.19-.13-.25-.26-.25s-.24.06-.24.25l-.2 6.13.2 3.18c0 .13.12.25.24.25s.26-.12.26-.25zm1.32-.07-.25-6.62c0-.13-.13-.25-.31-.25a.27.27 0 0 0-.26.25l-.24 6.62.24 3.2c0 .12.13.24.26.24.18 0 .3-.12.3-.25zm1.19 0-.2 3.2c0 .12-.12.24-.3.24-.13 0-.32-.12-.32-.25l-.19-3.19.2-6.81c0-.19.18-.31.3-.31.2 0 .32.12.32.31zm1.24 0-.18-6.68c0-.13-.13-.32-.32-.32s-.3.19-.3.31l-.2 6.7.2 3.12c0 .19.12.31.3.31s.32-.12.32-.31zm1.32 0-.19-6.43c0-.2-.13-.32-.38-.32-.18 0-.3.13-.3.31l-.2 6.44.2 3.13c0 .19.12.31.3.31.26 0 .38-.12.38-.31zm1.25 0-.13 2.75v.32c0 .12-.06.25-.12.3s-.19.13-.25.13a.35.35 0 0 1-.31-.18c-.07-.07-.07-.13-.07-.2v-.06l-.19-3.06.13-7.56.06-.06c0-.13.06-.25.13-.32s.12-.06.25-.06c.06 0 .12 0 .18.06.13.07.2.2.2.32zm1.12 3.06.2-3.06-.2-8.31c0-.19-.06-.31-.18-.38-.07 0-.13-.06-.2-.06-.12 0-.18.06-.24.13a.35.35 0 0 0-.2.3l-.12 8.32.07 1.57.06 1.5c.06.18.19.37.44.37s.37-.19.37-.38zm11.07.38c2 0 3.68-1.63 3.68-3.69 0-2-1.68-3.69-3.69-3.69-.5 0-1 .13-1.43.32a6.58 6.58 0 0 0-6.5-6c-.88 0-1.7.19-2.38.5-.31.06-.37.19-.37.37v11.75c0 .25.18.44.37.44h10.32z',
            'sharethis' => 'M31.06 24.81A6.28 6.28 0 0 0 20.5 20.2l-7.06-3.5c.06-.25.06-.5.06-.69s0-.44-.06-.69l7.06-3.5a6.27 6.27 0 0 0 10.56-4.56 6.28 6.28 0 1 0-12.56 0c0 .19 0 .44.06.62l-7.06 3.57a6.2 6.2 0 0 0-4.31-1.69C3.75 9.75.94 12.5.94 16s2.81 6.25 6.25 6.25a6.2 6.2 0 0 0 4.31-1.69l7.06 3.57c-.06.18-.06.43-.06.68a6.28 6.28 0 0 0 12.56 0z',
            'sharethis-alt' => 'M31.06 25.44V6.56A5.68 5.68 0 0 0 25.44.94H6.56A5.68 5.68 0 0 0 .94 6.56v18.88a5.68 5.68 0 0 0 5.62 5.62h18.88a5.68 5.68 0 0 0 5.62-5.62zm-9.19-7.75a4.23 4.23 0 0 1 4.2 4.19 4.27 4.27 0 0 1-4.2 4.18 4.23 4.23 0 0 1-4.18-4.18v-.44l-4.7-2.38a4.23 4.23 0 0 1-2.87 1.13c-2.25 0-4.18-1.88-4.18-4.19s1.93-4.19 4.18-4.19c1.13 0 2.13.44 2.88 1.13l4.69-2.38v-.44a4.23 4.23 0 0 1 4.18-4.18 4.27 4.27 0 0 1 4.2 4.18 4.23 4.23 0 0 1-4.2 4.2A4.24 4.24 0 0 1 19 13.18l-4.69 2.37v.88L19 18.8a4.23 4.23 0 0 1 2.88-1.12z',
            'reddit' => 'M29.31 18.69a3.32 3.32 0 0 0 1.75-2.94 3.43 3.43 0 0 0-3.44-3.44c-.87 0-1.68.31-2.3.88a17.46 17.46 0 0 0-8.5-2.57l1.8-5.5 4.75 1.13c0 1.5 1.25 2.81 2.82 2.81a2.85 2.85 0 0 0 0-5.69c-1.13 0-2.13.7-2.57 1.7l-5.3-1.26c-.26-.06-.57.13-.7.44l-2 6.37c-3.37.07-6.56.94-9 2.5a3.54 3.54 0 0 0-2.25-.8 3.43 3.43 0 0 0-3.43 3.43 3.5 3.5 0 0 0 1.62 2.87c-.06.32-.06.7-.06 1 0 2.44 1.37 4.75 4 6.44 2.56 1.7 5.87 2.57 9.44 2.57s6.87-.88 9.43-2.57 4-4 4-6.44c0-.3 0-.62-.06-.93zM2.88 17.44a2.48 2.48 0 0 1-.75-1.69c0-1.25 1-2.31 2.25-2.31.43 0 .87.18 1.25.37a8.78 8.78 0 0 0-2.75 3.63zm25.37 2.18c0 2.07-1.25 4-3.5 5.44-2.38 1.57-5.5 2.38-8.81 2.38s-6.44-.82-8.82-2.38c-2.25-1.43-3.5-3.37-3.5-5.43s1.25-4 3.5-5.44c2.38-1.5 5.5-2.38 8.82-2.38s6.43.88 8.81 2.38c2.25 1.44 3.5 3.44 3.5 5.44zm-16.75.44c1.13 0 2.06-.93 2.06-2.06s-.93-2.13-2.06-2.13c-1.19 0-2.13 1-2.13 2.13s.94 2.06 2.13 2.06zm9.38 3c-.25-.18-.63-.18-.82 0-.81.82-2.12 1.2-4.06 1.2-1.94 0-3.25-.38-4.06-1.2-.2-.18-.57-.18-.82 0a.75.75 0 0 0 0 .88c1.07 1 2.63 1.5 4.88 1.5s3.81-.5 4.87-1.5a.75.75 0 0 0 0-.88zM22.63 18c0-1.13-.94-2.13-2.07-2.13s-2.12 1-2.12 2.13 1 2.06 2.12 2.06 2.07-.93 2.07-2.06zm1.93-11.81a1.65 1.65 0 1 1 3.31.06 1.65 1.65 0 0 1-3.3-.06zm5.32 9.56A2.2 2.2 0 0 1 29 17.5a8.1 8.1 0 0 0-2.69-3.63c.38-.24.82-.43 1.32-.43a2.3 2.3 0 0 1 2.25 2.31z',
            'pinterest-alt' => 'M16 .94a15.07 15.07 0 0 1 0 30.12c-1.5 0-2.94-.25-4.25-.62.56-.88 1.19-2.06 1.5-3.25.19-.63 1.06-4.13 1.06-4.13.5 1 2.07 1.88 3.7 1.88 4.8 0 8.12-4.38 8.12-10.31 0-4.44-3.82-8.63-9.57-8.63-7.12 0-10.75 5.13-10.75 9.44 0 2.56 1 4.87 3.07 5.75.37.12.68 0 .75-.38.12-.3.25-.93.3-1.25.13-.37.07-.5-.18-.8-.62-.76-1-1.63-1-2.95a7.18 7.18 0 0 1 7.44-7.25c4 0 6.25 2.5 6.25 5.82 0 4.3-1.94 8-4.75 8-1.63 0-2.81-1.32-2.44-2.94.5-1.88 1.38-3.94 1.38-5.31 0-1.25-.7-2.25-2.07-2.25-1.62 0-2.87 1.62-2.87 3.87 0 1.44.44 2.38.44 2.38s-1.63 7-1.94 8.18c-.25 1.2-.25 2.44-.25 3.5A15.1 15.1 0 0 1 16 .94z',
            'microsoft-alt' => 'M0 4.38v10.87h13.13V2.62zm0 23.25V16.88h13.13v12.5zM14.56 2.38 32 0v15.25H14.56V2.37zm0 27.25V16.88H32V32z',
            'linux' => 'M26.06 28.69c1.25-.63 4.07-1.69 2-2.94-.43-.31-1.62-.63-1.68-2.81-.44.37-.38 2.44.8 2.81 1.32.44 2.2 1.25-.3 2.06a7.08 7.08 0 0 0-3.25 1.88c-1.32 1.06-3.32.62-2.94-1.69.12-1.19.25-2.19-.07-3.25a4.88 4.88 0 0 1-.12-1.63c.19-.93.69-1.18 1.19-.3.31.5.37 1.18 1.5 1.24 1.68.07 2-1.69 2.5-1.75.37-.06.75-1.06.5-2.75-.32-1.75-1.38-4.5-2.7-5.94A8.24 8.24 0 0 1 21.26 10a10.57 10.57 0 0 1-.5-3.63 5.61 5.61 0 0 0-2-4.5 5.88 5.88 0 0 0-3.31-.93 4 4 0 0 0-1.75.37c-1.94 1.06-2.2 2.56-2.2 4.31.07 1.57.13 3.44.32 5.2-.25.8-1.37 2.3-2.12 3.24-1 1-1.44 2.82-2.13 4.5-.31.82-.87 1.25-.94 2.38 0 .31 0 1.12.32.87 1.12-.87 2.56 1.32 4.75 4.75.37.63 1.87 3.38-.7 3.75-.87.07-2.24-.5-3.55-.87C6.24 29.19 5 29 4.3 28.8c-.37-.12-.56-.25-.62-.44-.07-.43.5-1.12.56-1.62 0-.56-.19-.81-.38-1.25s-.25-.81-.12-1c.12-.13.37-.19.75-.13.5 0 1.06-.06 1.37-.25.57-.37.82-1 .57-1.8 0 .8-.25 1.05-.94 1.43-.56.37-1.5.06-1.94.44-.5.43.19 1.62.13 2.5-.07.62-.7 1.37-.44 2 .31.68 1.75.75 3.25 1.06 2.12.44 3.31 1.19 4.31 1.25 1.44 0 1.62-1.38 3.87-1.44.63-.06 1.25-.06 1.94-.06h2.2c1.43.06.93.81 1.93 1.31.81.44 2.25.25 2.62-.06.44-.5 1.75-1.56 2.7-2.06zm-2.81-8.13c.25.13.94.44.94.75-.69-.56-2.75-.68-2.82.7-.37 0-.62 0-.87.3-.81.94-.06 2.94-.13 4-.06.94-.37 1.88-.5 2.82-.5 0-.43-.38-.3-.88.18-.44.37-1 .37-1.56.06-.5 0-.81-.13-.88s-.31.07-.56.5c-.63.94-1.81 1.38-3 1.5-1.13.13-2.19 0-2.81-.62-.2-.19-.5.06-.5.12-.07.07.12.25.3.57.32.5.57 1.18-.05 1.56 0-1.69-.57-1.81-1.13-2.88 1.13-.06 1.25-1.25.75-1.75-.44-.37-2.75-2.12-3.31-2.75-.31-.3-.69-.5-.88-.8-.31-.82-.56-2-.12-2.82.06-.13.12-.06.06.19-.37 1.81.81 3.25 1.06 2.5.2-.5 0-1.44.07-2.13.19-1.31 1.37-3.75 1.87-3.94-.81-1.43.94-2.56.94-3.87-.06-.88.69 1 1.44 1.44.87.43 1.81-.88 3.12-1.5.38-.2.82-.38.82-.57-.2-.75-1.75.94-3.13 1-.69 0-.87-.12-1.12-.37-.75-.69.06-.13 1.18-.31.44-.07.63-.2 1.13-.38.56-.19 1.12-.5 1.75-.69.44-.12.37-.44.19-.5-.07-.06-.2-.06-.32.13-.25.44-1.43.69-1.8.81-.5.13-1 .25-1.7.25-1.12-.06-.87-.56-1.62-1-.19-.12-.13-.44.12-.75.2-.12.63-.25.82-.62.06 0 .3-.32.5-.44.06-.07.06-1.38-.57-1.38-.56-.06-.75.38-.75.82.07.43.32.8.44.8.31 0 0 .32-.12.38-.25.07-.63-1-.57-1.5s.32-1.43 1-1.43c.57 0 1 .75 1 2.06 0 .25 1-.06 1.32.25.25.25-.82-2.31 1.5-2.5.62.12 1.18.31 1.43 1.75-.06.12.2 1.12-.18 1.25-.5.12-.75-.06-.5-.5.18-.44 0-1.5-.94-1.44s-.82 1.69-.57 1.75c.32 0 .94.5 1.38.56 1.44.25.38 1.13.56 2.13.25 1.19 1 .87 1.7 3.94.12.18.68.31 1.24 2.68.5 2.13-.19 3.63 1 3.5.25 0 .63-.06.81-.68.44-1.57-.25-3.44-.93-4.7a4.35 4.35 0 0 0-.94-1.37c.81.44 1.75 1.88 2 3 .31 1.44.5 2 .06 3.5zM9.5 15.75c.19-.25.13-.56.31-.5.13.06.07.19-.06.5-.06.25-.31.44-.38.44-.24-.07.07-.25.13-.44zm3.88-9.13c.12.07.3.38.24.75 0 .07-.06.07-.06.07-.12 0-.19-.13-.12-.32 0-.18-.07-.25-.13-.25-.12 0-.12-.3.06-.25zm.43 1.57c.2 0 .07-.31.44-.31-.56-.07-.56.3-.44.3zm1.38-.31c.31-.07.31.25.5.18s0-.37-.5-.18zm2.06-1.32c.06-.06.44.2.44.57 0 .06-.19.12-.19.06-.06-.25-.19-.44-.31-.5s-.2-.13.06-.13zm1-3.62c.13.06.31.19.31.25-.06.19-.43.12-.56.19-.31.12-.38.43-.56.3s.06-.3.18-.5c0-.12-.12-.5.2-.55.12 0 .24.12.43.3zm1.81 7.37c.32.2.5.07.63.38 0 .25-.13.5-.32.5-.37-.06-1.12-.88-.8-1.25.12-.13.18.19.5.37z',
            'jsfiddle' => 'M31.06 20.44a5.8 5.8 0 0 0-3.62-5.38v-.56c0-4.81-4-8.81-8.94-8.81a8.94 8.94 0 0 0-8.13 5.06 3.93 3.93 0 0 0-2.5-.88 4.07 4.07 0 0 0-3.93 5.32c-1.81 1-3 2.94-3 5.12 0 3.25 2.69 5.75 6 5.94H24.8c.13 0 .2.06.32.06a5.92 5.92 0 0 0 5.93-5.87zm-18.93 2.43c-2.38 0-4.32-1.43-4.32-3.87s2-3.88 4.32-3.88c4.56 0 5.43 5.7 8.56 5.7 1.06 0 1.94-.76 1.94-1.88 0-1-1-1.69-1.94-1.69-.88 0-1.5.31-2.13.94-.43-.57-.87-1.13-1.37-1.63a4.8 4.8 0 0 1 3.56-1.43c2.31 0 4.31 1.43 4.31 3.87s-2 3.88-4.25 3.88c-4.75 0-5.43-5.63-8.62-5.63-1.06 0-1.94.69-1.94 1.75s.88 1.75 1.94 1.75c.87 0 1.5-.31 2.12-.94.44.57.94 1.07 1.32 1.57-1 1-2.07 1.5-3.5 1.5z',
            'joomla' => 'm18.81 22.63 3.13-3.13-3-3-3.13 3.13-2.94 3-.62.56c-.94.94-2.5.94-3.5 0-.94-1-.94-2.57 0-3.5L9 19.5l-3-3-.19.25a6.59 6.59 0 0 0-1.75 6.38C2.25 23.5.94 25.13.94 27a4.04 4.04 0 0 0 4 4.06 3.97 3.97 0 0 0 3.94-3.12 6.76 6.76 0 0 0 6.37-1.75l.56-.63zM15.5 6.3l-.25-.19A6.76 6.76 0 0 0 9 4.32 4.1 4.1 0 0 0 5 .93C2.81.94 1 2.75 1 5c0 1.88 1.31 3.5 3.13 3.88a6.7 6.7 0 0 0 1.68 6.68l.57.57 2.93 3 3.2 3.12 2.93-3-6.69-6.69a2.53 2.53 0 0 1 0-3.5c1-.94 2.57-.94 3.5 0l.25.25zm12 2.7A4.04 4.04 0 0 0 27 .94a4 4 0 0 0-4 3.5 6.63 6.63 0 0 0-6.63 1.68l-6.68 6.7 3 3 6.69-6.76c.93-.94 2.5-.94 3.5 0 .93 1 .93 2.57 0 3.5l-.25.25 2.93 3 .25-.25A6.52 6.52 0 0 0 27.51 9zm-.44 22.06c2.2 0 4-1.81 4-4.06 0-2-1.5-3.69-3.5-3.94a6.6 6.6 0 0 0-1.75-6.31l-.56-.63L19.12 10l-3 3 6.13 6.12.63.57c.93 1 .93 2.56 0 3.5-1 .93-2.57.93-3.5 0l-.25-.25-2.94 3 .18.25a6.7 6.7 0 0 0 6.7 1.62c.37 1.88 2 3.25 4 3.25z',
            'html5' => 'M29.25.94H2.75L5.19 28l10.75 3.06L26.8 28zM24.31 6.5 24 9.75H11.31l.31 3.44h12.13l-.94 10.25-6.75 1.81v.06h-.12l-6.82-1.87-.37-5.25H12l.25 2.62 3.69 1 3.75-1 .37-4.3H8.56l-.87-10H24.3z',
            'flickr-alt' => 'M16 .94a15.07 15.07 0 1 1-.02 30.14A15.07 15.07 0 0 1 16 .94zm-5.75 19.75c2.56 0 4.69-2.13 4.69-4.75s-2.07-4.75-4.69-4.75a4.75 4.75 0 0 0 0 9.5zm11.88 0a4.75 4.75 0 1 0 0-9.5 4.75 4.75 0 0 0 0 9.5z',
            'email' => 'M0 3.75h32v24.5H0V3.75zM16 18.5 29 5.62H3zM10.81 16 1.87 7.19V24.8zm1.38 1.38-9.13 9h25.7l-9-8.94L16 21.12zm8.87-1.25L30.13 25V7.19z',
            'drupal' => 'M16.13 31.06c7 0 13.06-5.06 13.06-12.75S23.5 7.13 22.56 6.56c-1.56-1-3-1.37-4.43-2.31-.94-.63-2.2-2.06-3.2-3.31-.18 2-.8 2.81-1.5 3.37C11.94 5.5 11 5.87 9.76 6.56c-1.06.56-6.94 4-6.94 11.5s6.31 13 13.31 13zm10.3-12.44c1.45 0 1.82 1.5 1.82 2.44 0 .88-.25 2.5-.94 3.5-.75 1.07-1.18 1.44-2 1.38-1-.07-3.12-3.38-4.43-3.44-1.7-.06-5.32 3.5-8.25 3.5-1.7 0-2.25-.19-2.82-.63-.87-.56-1.31-1.5-1.25-2.8 0-2.26 2.13-4.38 4.82-4.38 3.37-.07 5.75 3.37 7.43 3.31 1.44 0 4.25-2.88 5.63-2.88zm-4 9.13c.26-.19.38-.06.38.06.07.13.13.32-.06.5-.19.13-1.5 1.07-3.06 1.25-1.57.13-3.7.25-5-.93-.2-.2-.13-.5 0-.63.19-.13.31-.19.5-.19.12 0 .12 0 .19.07.56.43 1.43.8 3.3.8s3.2-.5 3.76-.93zm-.93-2.94c.38.25.56.75.69 1.07.12.25 0 .43-.25.56-.19.12-.25.06-.44-.31s-.37-.75-1.37-.75-1.38.37-1.82.75c-.5.37-.69.56-.87.3s-.13-.43.19-.74c.37-.31.87-.75 1.37-.94.5-.25.75-.19 1.19-.19.5 0 1 .07 1.31.25z',
            'dropbox-alt' => 'm.94 17.56 6.12-4.87 8.94 5.5-6.19 5.19zM9.8 2 16 7.19l-8.95 5.5L.94 7.75zm21.25 5.75-6.12 4.94L16 7.19 22.19 2zM16 18.19l8.94-5.5 6.12 4.87-8.87 5.82zm0 1.12 6.25 5.13 2.63-1.69v1.94L16 30l-8.88-5.3v-1.94l2.7 1.69z',
            'css3' => 'M31.06 2.38H5.44l-1 5.06H25l-.62 3.25H3.75l-1 5.06h20.56L22.2 21.5l-8.31 2.75-7.2-2.75.5-2.5H2.14l-1.2 6.06 11.88 4.57 13.69-4.57z',
            'rss' => 'M18.75 26.38c0-7.13-5.88-12.94-13.13-12.94v1.87c6.2 0 11.25 4.94 11.25 11.06h1.88zM5.62 6.55a19.58 19.58 0 0 1 19.82 19.82H23.5A17.64 17.64 0 0 0 5.62 8.5V6.56zm5.7 17a2.9 2.9 0 0 1-2.82 2.82 2.9 2.9 0 0 1-2.88-2.82A2.9 2.9 0 0 1 8.5 20.7a2.9 2.9 0 0 1 2.81 2.87zm-1.88 0c0-.56-.44-1-.94-1-.56 0-1 .44-1 1 0 .5.44.94 1 .94.5 0 .94-.44.94-.94zM32 29.2a2.8 2.8 0 0 1-2.81 2.8H2.8A2.8 2.8 0 0 1 0 29.2V2.8A2.8 2.8 0 0 1 2.8 0h26.4A2.8 2.8 0 0 1 32 2.81V29.2zM29.19 1.87H2.8c-.5 0-.94.44-.94.94V29.2c0 .5.44.94.94.94h26.4c.5 0 .94-.44.94-.94V2.8c0-.5-.44-.94-.94-.94z',
            'rss-alt' => 'M21.06 32c0-11.44-9.44-20.69-21.06-20.69v1.88c10.56 0 19.13 8.44 19.13 18.81h1.93zM0 0c17.94 0 32 14.06 32 32h-1.88A29.83 29.83 0 0 0 0 1.87V0zm7.5 28.25C7.5 30.31 5.81 32 3.75 32S0 30.31 0 28.25s1.69-3.75 3.75-3.75 3.75 1.69 3.75 3.75zm-1.88 0c0-1.06-.8-1.88-1.87-1.88-1 0-1.88.82-1.88 1.88 0 1 .88 1.88 1.88 1.88a1.9 1.9 0 0 0 1.88-1.88z',
            'lottie'=>'M26.92 9.5c-4.44 0-6.97 4.43-9.35 8.7-1.9 3.65-3.8 7.13-6.49 7.13-.95 0-1.58.63-1.58 1.59 0 .95.63 1.58 1.58 1.58 4.44 0 6.97-4.43 9.35-8.7 1.9-3.65 3.8-7.13 6.49-7.13.95 0 1.58-.63 1.58-1.59 0-.95-.63-1.58-1.58-1.58Zm3.16-6.33H7.92a4.67 4.67 0 0 0-4.75 4.75v22.16c0 2.7 2.06 4.75 4.75 4.75h22.16c2.7 0 4.75-2.06 4.75-4.75V7.92c0-2.7-2.06-4.75-4.75-4.75Zm1.59 26.91c0 .96-.63 1.59-1.59 1.59H7.92c-.96 0-1.59-.63-1.59-1.59V7.92c0-.96.63-1.59 1.59-1.59h22.16c.96 0 1.59.63 1.59 1.59Zm0 0'
        );
        if ($icon !== '') {
            return isset($icons[$icon]) ? $icons[$icon] : '';
        }
        return $icons;
    }
}

new Themify_Icon_Themify();
